/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended.tags;

import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.tags.SimpleSameIDExtSpans;
import com.ibm.supa.search.spans.extended.tags.TagExtSpans;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameIDExtSpanQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = 5000212251086426330L;
    private ExtSpanQuery[] clauses;
    private String field;
    private boolean allSubSpans = false;

    public SameIDExtSpanQuery(ExtSpanQuery primaryClause, ExtSpanQuery ... secondaryClauses) {
        this(primaryClause.getField(), primaryClause, secondaryClauses);
    }

    public SameIDExtSpanQuery(String field, ExtSpanQuery primaryClause, ExtSpanQuery ... secondaryClauses) {
        this.clauses = new ExtSpanQuery[secondaryClauses.length + 1];
        this.clauses[0] = primaryClause;
        System.arraycopy(secondaryClauses, 0, this.clauses, 1, secondaryClauses.length);
        for (int i = 0; i < this.clauses.length; ++i) {
            SameIDExtSpanQuery.confirmResultClass(this.clauses[i]);
        }
        this.field = field;
    }

    public static void confirmResultClass(ExtSpanQuery extSpanQuery) {
        if (!TagExtSpans.class.isAssignableFrom(extSpanQuery.getResultClass())) {
            throw new IllegalArgumentException("All clauses must return TagExtSpans. Received: " + extSpanQuery.getResultClass());
        }
    }

    public boolean isAllSubSpans() {
        return this.allSubSpans;
    }

    public void setAllSubSpans(boolean primaryClauseOnly) {
        this.allSubSpans = primaryClauseOnly;
    }

    @Override
    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        if (this.allSubSpans) {
            throw new UnsupportedOperationException("Doesn't support returning all sub-span variations");
        }
        return new SimpleSameIDExtSpans(this, this.clauses, reader);
    }

    @Override
    public ExtSpanQuery includedClause(int i) {
        return this.clauses[i];
    }

    @Override
    public int numIncludedClauses() {
        return this.allSubSpans ? 1 : this.clauses.length;
    }

    @Override
    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery result = this;
        if (this.clauses.length <= 1) {
            result = this.clauses[0];
            if (recurseToClauses) {
                result = result.optimize(true);
            }
        } else if (recurseToClauses) {
            SameIDExtSpanQuery clone = this;
            for (int i = 0; i < this.clauses.length; ++i) {
                ExtSpanQuery optimized = this.clauses[i].optimize(true);
                if (optimized == this.clauses[i]) continue;
                if (clone == this) {
                    clone = (SameIDExtSpanQuery)((Object)this.clone());
                    clone.clauses = (ExtSpanQuery[])clone.clauses.clone();
                }
                clone.clauses[i] = optimized;
            }
            result = clone;
        }
        if (result != this) {
            result = new ExtSpanQueryFieldChanger(result, this.field).optimize(false);
        }
        return result;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        HashSet result = new HashSet();
        for (ExtSpanQuery clause : this.clauses) {
            clause.extractTerms(result);
        }
        return result;
    }

    @Override
    public Class<? extends ExtSpans> getResultClass() {
        return TagExtSpans.class;
    }

    public String toString(String field) {
        StringBuilder result = new StringBuilder();
        result.append("sameId(");
        result.append(this.clauses[0].toString(field)).append(", [");
        result.append(this.clauses[1].toString(field));
        if (this.clauses.length > 1) {
            for (int i = 2; i < this.clauses.length; ++i) {
                result.append(", ").append(this.clauses[i].toString(field));
            }
        }
        result.append("],").append(this.field).append(",").append(this.allSubSpans);
        result.append(")");
        return result.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SameIDExtSpanQuery)) {
            return false;
        }
        SameIDExtSpanQuery other = (SameIDExtSpanQuery)((Object)o);
        other.allSubSpans = this.allSubSpans && other.field.equals(this.field) && Arrays.deepEquals((Object[])other.clauses, (Object[])this.clauses);
        return other.allSubSpans;
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode((Object[])this.clauses);
        result ^= result << 8 | result >>> 24;
        result ^= this.field.hashCode();
        result ^= result << 7 | result >>> 25;
        return result ^= this.allSubSpans ? -1716530243 : 0;
    }
}

