/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanResultExtSpanScorer
implements ExtSpanScorer {
    private List<SpanResult> spanResults;
    private int currIndex = 0;

    public SpanResultExtSpanScorer(List<SpanResult> spanResults, boolean sorted) {
        this.spanResults = spanResults;
        if (!sorted) {
            Collections.sort(this.spanResults, SpanResult.POSITION_COMPARATOR);
        }
    }

    @Override
    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        this.internalUpdate(result, extSpans.doc(), extSpans.start(), extSpans.end());
    }

    private SpanResult currSpanResult() {
        return this.spanResults.get(this.currIndex);
    }

    private void internalUpdate(PenaltyScore result, int docNum, int start, int end) {
        while (docNum > this.currSpanResult().doc()) {
            if (this.currIndex < this.spanResults.size()) {
                ++this.currIndex;
                continue;
            }
            return;
        }
        if (docNum != this.currSpanResult().doc()) {
            return;
        }
        while (start > this.currSpanResult().start()) {
            if (this.currIndex < this.spanResults.size()) {
                ++this.currIndex;
                continue;
            }
            return;
        }
        if (start != this.currSpanResult().start()) {
            return;
        }
        while (end > this.currSpanResult().end()) {
            if (this.currIndex < this.spanResults.size()) {
                ++this.currIndex;
                continue;
            }
            return;
        }
        if (end != this.currSpanResult().end()) {
            return;
        }
        result.penalize(this.currSpanResult().getPenaltyScore().getPenalty());
    }
}

