/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class SlopExtSpanScorer
implements ExtSpanScorer {
    private double factor;

    public SlopExtSpanScorer(double factor) {
        this.factor = factor;
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        if (extSpans.numSubExtSpans() <= 1) {
            return;
        }
        int totalSlop = 0;
        int maxEnd = extSpans.subExtSpan(0).end();
        for (int i = 1; i < extSpans.numSubExtSpans(); ++i) {
            ExtSpans curr = extSpans.subExtSpan(i);
            int slop = curr.start() - maxEnd;
            totalSlop += Math.max(0, slop);
            maxEnd = Math.max(maxEnd, curr.end());
        }
        result.penalize(this.factor * (double)totalSlop);
    }
}

