/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class SimpleContainsExtSpans
extends IterableExtSpans {
    private ExtSpanContainsQuery query;
    private ExtSpans outer;
    private ExtSpans inner;
    private boolean moreOuter;
    private boolean moreInner;

    public SimpleContainsExtSpans(ExtSpanContainsQuery query, ExtSpanQuery container, ExtSpanQuery containee, IndexReader reader) throws IOException {
        super(reader);
        this.query = query;
        this.outer = container.getExtSpans(reader);
        this.inner = containee.getExtSpans(reader);
        this.moreOuter = true;
        this.moreInner = true;
        if (query.isIncludeContainer()) {
            this.moreInner = this.inner.next();
        } else {
            this.moreOuter = this.outer.next();
        }
    }

    public int numSubExtSpans() {
        return 2;
    }

    public ExtSpanQuery query() {
        return this.query;
    }

    public ExtSpans subExtSpan(int index) {
        return index == 0 ? this.outer : this.inner;
    }

    private ExtSpans getResultSpans() {
        return this.query.isIncludeContainer() ? this.outer : this.inner;
    }

    public int doc() {
        return this.getResultSpans().doc();
    }

    public int start() {
        return this.getResultSpans().start();
    }

    public int end() {
        return this.getResultSpans().end();
    }

    public boolean next() throws IOException {
        if (this.moreOuter && this.query.isIncludeContainer()) {
            this.moreOuter = this.outer.next();
        } else if (this.moreInner && !this.query.isIncludeContainer()) {
            this.moreInner = this.inner.next();
        }
        return this.innerNext();
    }

    public boolean skipTo(int target) throws IOException {
        if (this.moreOuter && this.query.isIncludeContainer()) {
            this.moreOuter = this.outer.skipTo(target);
        } else if (this.moreInner && !this.query.isIncludeContainer()) {
            this.moreInner = this.inner.skipTo(target);
        }
        return this.innerNext();
    }

    private boolean innerNext() throws IOException {
        while (this.moreOuter && this.moreInner) {
            if (this.outer.doc() > this.inner.doc()) {
                this.moreInner = this.inner.skipTo(this.outer.doc());
            }
            this.moveInner();
            if (this.atMatch()) {
                return true;
            }
            if (!this.moreInner) continue;
            this.moreOuter = this.outer.skipTo(this.inner.doc());
        }
        return false;
    }

    private void moveInner() throws IOException {
        while (this.moreInner && this.outer.doc() == this.inner.doc() && this.inner.start() < this.outer.start()) {
            this.moreInner = this.inner.next();
        }
    }

    private boolean atMatch() {
        return this.moreInner && this.outer.doc() == this.inner.doc() && this.outer.end() >= this.inner.end();
    }
}

