/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.search.spans.extended.ExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.OneSpanExtSpans;

public class ScoringExtSpanCopyHandler
implements ExtSpanCopyHandler,
ExtSpanScorer {
    private ExtSpanScorer scorer;
    private boolean generateExplanations;
    private OneSpanExtSpans spansWrapper;
    private Map<ExtSpans, PenaltyScore> shallowCopyScores;

    public ScoringExtSpanCopyHandler(ExtSpanScorer scorer, boolean generateExplanations) {
        this.scorer = scorer;
        this.generateExplanations = generateExplanations;
        this.spansWrapper = new OneSpanExtSpans();
        this.shallowCopyScores = new WeakHashMap<ExtSpans, PenaltyScore>();
    }

    public void copied(ExtSpans original, ExtSpans shallowCopy) {
        PenaltyScore penaltyScore = new PenaltyScore();
        this.spansWrapper.setExtSpans(original);
        this.scorer.updatePenaltyScore(this.spansWrapper, penaltyScore, this.generateExplanations);
        this.shallowCopyScores.put(shallowCopy, penaltyScore);
    }

    public void free(ExtSpans copy) {
        this.shallowCopyScores.remove(copy);
    }

    public void freeAll() {
        this.shallowCopyScores.clear();
    }

    public boolean usesResourcesForShallowCopies() {
        return true;
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        PenaltyScore savedScore = this.shallowCopyScores.get(extSpans);
        if (savedScore == null) {
            this.scorer.updatePenaltyScore(extSpans, result, generateExplanations);
            return;
        }
        if (generateExplanations != this.generateExplanations) {
            // empty if block
        }
        result.penalize(savedScore.getPenalty());
        result.setExplanation(savedScore.getExplanation());
        List<PenaltyScore> children = result.getChildren();
        List<PenaltyScore> savedChildren = savedScore.getChildren();
        if (savedChildren != null) {
            if (children == null) {
                for (PenaltyScore child : savedChildren) {
                    result.addChild(child);
                }
            } else {
                children.addAll(savedChildren);
            }
        }
    }
}

