/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import com.ibm.supa.search.spans.extended.MultiExtSpanScorer;
import com.ibm.supa.search.spans.extended.NullExtSpanScorer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.OneSpanExtSpans;

public class RecursiveExtSpanScorer
implements ExtSpanScorer {
    private ExtSpanScorer defaultScorer;
    private Map<ExtSpanQuery, ExtSpanScorer> scorers;
    private Map<ExtSpanQuery, Double> weightUpdates;
    private OneSpanExtSpans extSpansForScoring;

    public RecursiveExtSpanScorer() {
        this(NullExtSpanScorer.instance);
    }

    public RecursiveExtSpanScorer(ExtSpanScorer defaultScorer) {
        this.defaultScorer = defaultScorer;
        this.scorers = new IdentityHashMap<ExtSpanQuery, ExtSpanScorer>();
        this.weightUpdates = new IdentityHashMap<ExtSpanQuery, Double>();
        this.extSpansForScoring = new OneSpanExtSpans();
    }

    public void clearScorers() {
        this.scorers.clear();
    }

    public void addScorer(ExtSpanQuery query, ExtSpanScorer scorer) {
        this.addScorer(query, scorer, true);
    }

    public void addWeighting(ExtSpanQuery query, double weight) {
        this.addWeighting(query, weight, true);
    }

    public void addWeighting(ExtSpanQuery query, double weight, boolean accumulateWeights) {
        if (accumulateWeights && this.weightUpdates.containsKey((Object)query)) {
            weight *= this.weightUpdates.get((Object)query).doubleValue();
        }
        this.weightUpdates.put(query, weight);
    }

    public void addScorer(ExtSpanQuery query, ExtSpanScorer scorer, boolean accumulateScorers) {
        if (!accumulateScorers) {
            this.scorers.put(query, scorer);
            return;
        }
        ExtSpanScorer oldScorer = this.scorers.get((Object)query);
        if (oldScorer == null) {
            this.scorers.put(query, scorer);
        } else {
            this.scorers.put(query, new MultiExtSpanScorer(oldScorer, scorer));
        }
    }

    public ExtSpanScorer lookupScorer(ExtSpanQuery query) {
        return this.scorers.get((Object)query);
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        if (extSpans == null) {
            return;
        }
        double oldPenalty = result.getPenalty();
        int length = extSpans.numSubExtSpans();
        for (int i = 0; i < length; ++i) {
            if (generateExplanations) {
                PenaltyScore sonScore = new PenaltyScore();
                this.updatePenaltyScore(extSpans.subExtSpan(i), sonScore, generateExplanations);
                result.addChild(sonScore);
                continue;
            }
            this.updatePenaltyScore(extSpans.subExtSpan(i), result, false);
        }
        ExtSpanQuery query = extSpans.query();
        ExtSpanScorer scorer = this.scorers.get((Object)query);
        if (scorer == null) {
            scorer = this.defaultScorer;
        }
        this.extSpansForScoring.setExtSpans(extSpans);
        scorer.updatePenaltyScore(this.extSpansForScoring, result, generateExplanations);
        Double weightUpdate = this.weightUpdates.get((Object)query);
        if (weightUpdate != null) {
            double penalty = result.getPenalty() - oldPenalty;
            result.setPenalty(oldPenalty + weightUpdate * penalty);
        }
    }
}

