/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class QueryOrderScorer
implements ExtSpanScorer {
    private Map<ExtSpanQuery, Set<ExtSpanQuery>> queryMap;
    private double factor;
    private ExtSpans[] extSpanArray;

    public QueryOrderScorer(ExtSpanQuery[] clauses, double factor) {
        this(clauses, factor, false);
    }

    public QueryOrderScorer(ExtSpanQuery[] clauses, double factor, boolean normalize) {
        if (clauses.length <= 1) {
            return;
        }
        this.queryMap = new IdentityHashMap<ExtSpanQuery, Set<ExtSpanQuery>>();
        for (int i = 1; i < clauses.length; ++i) {
            IdentityHashMap subMap = new IdentityHashMap();
            for (int j = 0; j < i; ++j) {
                subMap.put(clauses[j], null);
            }
            Set set = subMap.keySet();
            this.queryMap.put(clauses[i], set);
        }
        this.factor = factor / (double)(normalize ? QueryOrderScorer.maxBadPositions(clauses.length) : 1);
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        int i;
        if (this.queryMap == null) {
            return;
        }
        int numBadPositions = 0;
        int numSubExtSpans = extSpans.numSubExtSpans();
        if (this.extSpanArray == null || this.extSpanArray.length < numSubExtSpans) {
            this.extSpanArray = new ExtSpans[numSubExtSpans];
        }
        for (i = 0; i < numSubExtSpans; ++i) {
            this.extSpanArray[i] = extSpans.subExtSpan(i);
        }
        Arrays.sort(this.extSpanArray, 0, numSubExtSpans, ExtSpanUtils.POSITION_COMPARATOR);
        for (i = 0; i < numSubExtSpans - 1; ++i) {
            Set<ExtSpanQuery> preQueries = this.queryMap.get((Object)this.extSpanArray[i].query());
            if (preQueries == null) continue;
            int found = 0;
            for (int j = i + 1; found < preQueries.size() && j < numSubExtSpans; ++j) {
                if (ExtSpanUtils.POSITION_COMPARATOR.compare(this.extSpanArray[j], this.extSpanArray[i]) == 0 || !preQueries.contains((Object)this.extSpanArray[j].query())) continue;
                ++found;
            }
            numBadPositions += found;
        }
        result.penalize((double)numBadPositions * this.factor);
        if (generateExplanations) {
            // empty if block
        }
        Arrays.fill(this.extSpanArray, null);
    }

    public static int maxBadPositions(int numClauses) {
        return numClauses * (numClauses - 1) / 2;
    }
}

