/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class MultiExtSpanScorer
implements ExtSpanScorer {
    private ExtSpanScorer[] scorers;
    private PenaltyScore[] penaltyScores;

    public MultiExtSpanScorer(ExtSpanScorer ... scorers) {
        this.scorers = scorers;
        this.penaltyScores = new PenaltyScore[scorers.length];
        for (int i = 0; i < this.penaltyScores.length; ++i) {
            this.penaltyScores[i] = new PenaltyScore();
        }
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        for (int i = 0; i < this.scorers.length; ++i) {
            this.penaltyScores[i].clear();
            this.scorers[i].updatePenaltyScore(extSpans, this.penaltyScores[i], generateExplanations);
            result.penalize(this.penaltyScores[i].getPenalty());
        }
        if (generateExplanations) {
            // empty if block
        }
    }
}

