/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class MissingClauseExtSpanScorer
implements ExtSpanScorer {
    private Map<ExtSpanQuery, Double> lookup = new IdentityHashMap<ExtSpanQuery, Double>();
    private Map<ExtSpanQuery, Object> clauses = new IdentityHashMap<ExtSpanQuery, Object>();
    private boolean deep;

    public MissingClauseExtSpanScorer(boolean deep) {
        this.deep = deep;
    }

    public MissingClauseExtSpanScorer(ExtSpanQuery query, boolean deep, double ... factors) {
        this.deep = deep;
        int length = Math.min(query.numIncludedClauses(), factors.length);
        for (int i = 0; i < length; ++i) {
            this.add(query.includedClause(i), factors[i]);
        }
    }

    public void add(ExtSpanQuery query, double factor) {
        this.lookup.put(query, factor);
    }

    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        this.clauses.clear();
        this.extractQueries(extSpans);
        for (Map.Entry<ExtSpanQuery, Double> entry : this.lookup.entrySet()) {
            if (this.clauses.containsKey((Object)entry.getKey())) continue;
            result.penalize(entry.getValue());
        }
        this.clauses.clear();
    }

    private void extractQueries(ExtSpans extSpans) {
        for (int i = 0; i < extSpans.numSubExtSpans(); ++i) {
            ExtSpans subExtSpan = extSpans.subExtSpan(i);
            this.clauses.put(subExtSpan.query(), null);
            if (!this.deep) continue;
            this.extractQueries(subExtSpan);
        }
    }
}

