/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class ExtSpansRepeaterQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = -6622940948820777645L;
    private final ExtSpans[] extSpans;

    public ExtSpansRepeaterQuery(ExtSpans ... extSpans) {
        this.extSpans = extSpans;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new IterableExtSpans(reader){
            int index;
            {
                this.index = -1;
            }

            public int doc() {
                return ExtSpansRepeaterQuery.this.extSpans[this.index].doc();
            }

            public int start() {
                return ExtSpansRepeaterQuery.this.extSpans[this.index].start();
            }

            public int end() {
                return ExtSpansRepeaterQuery.this.extSpans[this.index].end();
            }

            public boolean next() throws IOException {
                ++this.index;
                return this.index < ExtSpansRepeaterQuery.this.extSpans.length;
            }

            public boolean skipTo(int target) throws IOException {
                int low = this.index + 1;
                int high = ExtSpansRepeaterQuery.this.extSpans.length;
                while (low < high) {
                    int mid = low + high >>> 1;
                    if (ExtSpansRepeaterQuery.this.extSpans[mid].doc() < target) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid;
                }
                this.index = low;
                return this.index < ExtSpansRepeaterQuery.this.extSpans.length;
            }

            public ExtSpanQuery query() {
                return ExtSpansRepeaterQuery.this;
            }

            public int numSubExtSpans() {
                return 1;
            }

            public ExtSpans subExtSpan(int index) {
                return ExtSpansRepeaterQuery.this.extSpans[index];
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpansRepeaterQuery)) {
            return false;
        }
        ExtSpansRepeaterQuery other = (ExtSpansRepeaterQuery)((Object)o);
        return Arrays.equals(this.extSpans, other.extSpans);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.extSpans);
        result ^= result << 20 | result >>> 11;
        return result;
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }

    public String getField() {
        if (this.extSpans.length == 0) {
            return null;
        }
        return this.extSpans[0].query().getField();
    }

    @Deprecated
    public Collection getTerms() {
        if (this.extSpans.length == 0) {
            return null;
        }
        return this.extSpans[0].query().getTerms();
    }

    public String toString(String field) {
        return "repeater";
    }
}

