/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.AlignedDocExtSpanQuery;
import com.ibm.supa.search.spans.extended.ExtSpanWildcardQuery;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtSpansPositionsFilter
implements ExtSpansFilter {
    final Map<ExtSpanQuery, Set<Integer>> combinedPositionsLookup;
    final Set<Integer> requiredQueryPositions;
    HashSet<Integer> positionsLeft = new HashSet();

    public ExtSpansPositionsFilter(Map<ExtSpanQuery, Set<Integer>> combinedPositionsLookup, Set<Integer> requiredQueryPositions) {
        this.combinedPositionsLookup = combinedPositionsLookup;
        this.requiredQueryPositions = requiredQueryPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(ExtSpans extSpans) {
        try {
            if (this.requiredQueryPositions.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            this.positionsLeft.addAll(this.requiredQueryPositions);
            boolean bl = this.subTreeContainsRequiredPositions(extSpans, extSpans.query());
            return bl;
        }
        finally {
            this.positionsLeft.clear();
        }
    }

    @Override
    public ExtSpansFilter clone() {
        return new ExtSpansPositionsFilter(this.combinedPositionsLookup, this.requiredQueryPositions);
    }

    private boolean subTreeContainsRequiredPositions(ExtSpans extSpans, ExtSpanQuery ancestorQuery) {
        if (extSpans.query() instanceof AlignedDocExtSpanQuery) {
            return false;
        }
        int numSubExtSpans = extSpans.numSubExtSpans();
        if (numSubExtSpans == 0) {
            Set<Integer> positions;
            ExtSpanQuery lookupQuery = extSpans.query();
            if (ancestorQuery instanceof ExtSpanWildcardQuery) {
                lookupQuery = ancestorQuery;
            }
            if ((positions = this.combinedPositionsLookup.get((Object)lookupQuery)) != null) {
                this.positionsLeft.removeAll(positions);
            }
            return this.positionsLeft.isEmpty();
        }
        for (int i = 0; i < numSubExtSpans; ++i) {
            ExtSpanQuery passQuery = extSpans.query();
            if (ancestorQuery instanceof ExtSpanWildcardQuery) {
                passQuery = ancestorQuery;
            }
            if (!this.subTreeContainsRequiredPositions(extSpans.subExtSpan(i), passQuery)) continue;
            return true;
        }
        return false;
    }
}

