/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.common.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpanTermQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class ExtSpanWildcardQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = -7378941351568281705L;
    public static final String SINGLE_CHAR = ".";
    public static final String OPTIONAL_CHAR = "#";
    public static final String ZERO_OR_MORE_CHARS = "*";
    public static final String CHAR_CLASS_START_CHAR = "[";
    public static final String CHAR_CLASS_END_CHAR = "]";
    public static final String OPTIONAL_MARKERS = "#*";
    public static final String MULTIPLE_TIMES_START_CHAR = "{";
    public static final String MULTIPLE_TIMES_END_CHAR = "}";
    public static final String OPTIONALS = "#*.[";
    final Term preTerm;
    final Pattern prePattern;
    final Pattern pattern;
    final String[] excludedSuffixes;

    public ExtSpanWildcardQuery(String field, String wildCardPattern, String ... excludedSuffixes) {
        int wcIndex = Math.min(ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, SINGLE_CHAR), Math.min(ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, OPTIONAL_CHAR), ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, ZERO_OR_MORE_CHARS)));
        int preIndex = ExtSpanWildcardQuery.nextPreStringIndex(wildCardPattern, 0);
        this.excludedSuffixes = excludedSuffixes;
        this.pattern = Pattern.compile(ExtSpanWildcardQuery.getRegExPattern(wildCardPattern, wildCardPattern.length()));
        String termText = this.getPreTerm(wildCardPattern, 0, wcIndex, preIndex);
        String prePatternText = this.getPrePattern(wildCardPattern);
        this.preTerm = new Term(field, ((Object)TextUtils.slashUnescape(termText)).toString());
        this.prePattern = Pattern.compile(prePatternText);
    }

    private static int nextPreStringIndex(String str, int start) {
        return Math.min(ExtSpanWildcardQuery.posFirstIndexofUnescaped(str, start, CHAR_CLASS_START_CHAR), ExtSpanWildcardQuery.posFirstIndexofUnescaped(str, start, MULTIPLE_TIMES_START_CHAR));
    }

    private boolean hasNumPart(String wildCardPattern, int endIndex) {
        return endIndex + 1 < wildCardPattern.length() && wildCardPattern.charAt(endIndex + 1) == '{';
    }

    private int getMinNumCharClassTimes(String wildCardPattern, int endIndex) {
        int result = 1;
        if (this.hasNumPart(wildCardPattern, endIndex)) {
            result = 0;
            int i = endIndex + 2;
            while (Character.isDigit(wildCardPattern.charAt(i))) {
                result = 10 * result + (wildCardPattern.charAt(i) - 48);
                ++i;
            }
        }
        return result;
    }

    private boolean numTimesIsExact(String wildCardPattern, int endIndex) {
        boolean result = true;
        if (this.hasNumPart(wildCardPattern, endIndex)) {
            int closeIndex = this.getEndNumPartIndex(wildCardPattern, endIndex);
            if (ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, endIndex + 2, ",") < closeIndex) {
                result = false;
            }
        }
        return result;
    }

    private int getEndNumPartIndex(String wildCardPattern, int endIndex) {
        return ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, endIndex + 2, MULTIPLE_TIMES_END_CHAR);
    }

    private int getNextStartIndex(String wildCardPattern, int endIndex) {
        if (this.hasNumPart(wildCardPattern, endIndex)) {
            return this.getEndNumPartIndex(wildCardPattern, endIndex) + 1;
        }
        return endIndex + 1;
    }

    private String getPreTerm(String wildCardPattern, int startIndex, int wcIndex, int preIndex) {
        int nextStartIndex;
        int endIndex;
        if (preIndex == wildCardPattern.length()) {
            endIndex = wildCardPattern.length();
        } else if (wildCardPattern.charAt(preIndex) == CHAR_CLASS_START_CHAR.charAt(0)) {
            endIndex = ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, preIndex, CHAR_CLASS_END_CHAR);
            int openIndex = preIndex;
            while ((openIndex = ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, openIndex + 1, CHAR_CLASS_START_CHAR)) < endIndex) {
                endIndex = ExtSpanWildcardQuery.posFirstIndexofUnescaped(wildCardPattern, endIndex + 1, CHAR_CLASS_END_CHAR);
            }
        } else {
            endIndex = --preIndex;
            if (preIndex > 0 && wildCardPattern.charAt(preIndex - 1) == '\\') {
                --preIndex;
            }
        }
        String termText = wildCardPattern.substring(startIndex, Math.min(preIndex, wcIndex));
        int numTimes = endIndex < wcIndex ? this.getMinNumCharClassTimes(wildCardPattern, endIndex) : 0;
        if (numTimes > 0) {
            Pattern termPattern = Pattern.compile(ExtSpanWildcardQuery.getRegExPattern(wildCardPattern, preIndex, endIndex + 1));
            AllCharSeq seq = new AllCharSeq();
            for (int i = 0; i <= 0x10FFFF; ++i) {
                seq.set((char)i);
                if (!termPattern.matcher(seq).matches()) continue;
                String charStr = Character.toString((char)i);
                for (int j = 0; j < numTimes; ++j) {
                    termText = termText + charStr;
                }
                break;
            }
        }
        if (numTimes > 0 && this.numTimesIsExact(wildCardPattern, endIndex) && (nextStartIndex = this.getNextStartIndex(wildCardPattern, endIndex)) < wcIndex) {
            int nextIndex = ExtSpanWildcardQuery.nextPreStringIndex(wildCardPattern, nextStartIndex);
            termText = termText + this.getPreTerm(wildCardPattern, nextStartIndex, wcIndex, nextIndex);
        }
        return termText;
    }

    private String getPrePattern(CharSequence wildCardPattern) {
        int nextIndex = 0;
        StringBuilder prePatternBuf = new StringBuilder();
        for (int curIndex = 0; curIndex < wildCardPattern.length(); ++curIndex) {
            char curChar = wildCardPattern.charAt(curIndex);
            String curCharAsSequence = (String)wildCardPattern.subSequence(curIndex, curIndex + 1);
            if (this.isEscaped(wildCardPattern, curIndex)) {
                prePatternBuf.append(wildCardPattern.charAt(curIndex));
                continue;
            }
            if (OPTIONALS.contains(curCharAsSequence)) {
                CharSequence needToAppend = "";
                if (curChar == '[') {
                    nextIndex = ExtSpanWildcardQuery.posFirstIndexofUnescaped((String)wildCardPattern, curIndex, CHAR_CLASS_END_CHAR);
                    needToAppend = wildCardPattern.subSequence(curIndex, nextIndex + 1);
                    curIndex = nextIndex;
                } else if (curChar == '*') {
                    needToAppend = ".*";
                } else if (curChar == '#') {
                    needToAppend = ".?";
                } else if (curChar == '.') {
                    needToAppend = SINGLE_CHAR;
                }
                int minNumCharClassTimes = this.getMinNumCharClassTimes((String)wildCardPattern, curIndex);
                if (minNumCharClassTimes == 0) break;
                prePatternBuf.append(needToAppend);
                break;
            }
            if (MULTIPLE_TIMES_START_CHAR.contains(curCharAsSequence)) {
                nextIndex = ExtSpanWildcardQuery.posFirstIndexofUnescaped((String)wildCardPattern, curIndex, MULTIPLE_TIMES_END_CHAR);
                prePatternBuf.append(wildCardPattern.subSequence(curIndex, nextIndex + 1));
                curIndex = nextIndex;
                continue;
            }
            prePatternBuf.append(curChar);
        }
        if (prePatternBuf.toString().trim().equals("")) {
            return ".?";
        }
        return prePatternBuf.toString();
    }

    private boolean isEscaped(CharSequence userQueryCharArr, int curCharIndex) {
        if (curCharIndex == 0) {
            return false;
        }
        int escapeCharCounter = 0;
        for (int i = curCharIndex - 1; i >= 0; --i) {
            if (userQueryCharArr.charAt(i) == '\\') {
                ++escapeCharCounter;
                continue;
            }
            return escapeCharCounter % 2 != 0;
        }
        return escapeCharCounter % 2 != 0;
    }

    public static boolean containsWildcard(String str) {
        return ExtSpanWildcardQuery.containsUnescaped(str, SINGLE_CHAR) || ExtSpanWildcardQuery.containsUnescaped(str, OPTIONAL_CHAR) || ExtSpanWildcardQuery.containsUnescaped(str, ZERO_OR_MORE_CHARS) || ExtSpanWildcardQuery.containsUnescaped(str, CHAR_CLASS_START_CHAR) || str.charAt(0) != '{' && ExtSpanWildcardQuery.containsUnescaped(str, MULTIPLE_TIMES_START_CHAR);
    }

    private static boolean containsUnescaped(String str, String match) {
        return ExtSpanWildcardQuery.firstIndexOfUnescaped(str, match) >= 0;
    }

    private static int posFirstIndexofUnescaped(String str, String match) {
        return ExtSpanWildcardQuery.posFirstIndexofUnescaped(str, 0, match);
    }

    private static int posFirstIndexofUnescaped(String str, int start, String match) {
        int result = ExtSpanWildcardQuery.firstIndexOfUnescaped(str, start, match);
        if (result < start) {
            result = str.length();
        }
        return result;
    }

    private static int firstIndexOfUnescaped(String str, String match) {
        return ExtSpanWildcardQuery.firstIndexOfUnescaped(str, 0, match);
    }

    private static int firstIndexOfUnescaped(String str, int start, String match) {
        int index = start - 1;
        while ((index = str.indexOf(match, index + 1)) != -1 && index != 0 && str.charAt(index - 1) == '\\') {
        }
        return index;
    }

    public static boolean containsNonOptional(String str) {
        if (str.indexOf("\\") >= 0) {
            return true;
        }
        StringTokenizer sTok = new StringTokenizer(str, OPTIONAL_MARKERS);
        return sTok.hasMoreTokens();
    }

    private static String getRegExPattern(String wildCardPattern, int length) {
        return ExtSpanWildcardQuery.getRegExPattern(wildCardPattern, 0, length);
    }

    private static String getRegExPattern(String wildCardPattern, int start, int end) {
        StringBuilder newPattern = new StringBuilder();
        boolean escaped = false;
        for (int i = start; i < end; ++i) {
            char ch = wildCardPattern.charAt(i);
            if (escaped) {
                if (Character.isLetterOrDigit(ch)) {
                    newPattern.setCharAt(newPattern.length() - 1, ch);
                } else {
                    newPattern.append(ch);
                }
                escaped = false;
                continue;
            }
            if (ch == '\\') {
                newPattern.append(ch);
                escaped = true;
                continue;
            }
            if (OPTIONAL_CHAR.charAt(0) == ch || ZERO_OR_MORE_CHARS.charAt(0) == ch) {
                newPattern.append('.');
                if (OPTIONAL_CHAR.charAt(0) == ch) {
                    ch = '?';
                }
            }
            newPattern.append(ch);
        }
        return newPattern.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        String field = this.preTerm.field();
        ArrayList<ExtSpanTermQuery> termQueries = new ArrayList<ExtSpanTermQuery>();
        TermEnum termEnum = reader.terms(this.preTerm);
        try {
            Term term;
            while ((term = termEnum.term()) != null) {
                block10: {
                    if (term.field() != field) {
                        break;
                    }
                    String termText = term.text();
                    if (!this.prePattern.matcher(termText).lookingAt()) {
                        break;
                    }
                    for (String suffix : this.excludedSuffixes) {
                        if (!termText.endsWith(suffix)) {
                            continue;
                        }
                        break block10;
                    }
                    if (this.pattern.matcher(termText).matches()) {
                        termQueries.add(new ExtSpanTermQuery(term));
                    }
                }
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
        ExtSpanQuery[] clauses = termQueries.toArray(new ExtSpanQuery[termQueries.size()]);
        return new DelegatedExtSpans(new ExtSpanOrQuery(clauses).optimize(false).getExtSpans(reader), this);
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public String getField() {
        return this.preTerm.field();
    }

    public Collection getTerms() {
        HashSet<Term> result = new HashSet<Term>();
        result.add(this.preTerm);
        return result;
    }

    public String toString(String field) {
        StringBuilder result = new StringBuilder();
        result.append("extSpanWildCard(");
        result.append(this.preTerm.field()).append(',');
        result.append(this.pattern.pattern());
        if (this.excludedSuffixes != null) {
            for (String suffix : this.excludedSuffixes) {
                result.append(',').append(suffix);
            }
        }
        result.append(')');
        return result.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanWildcardQuery)) {
            return false;
        }
        ExtSpanWildcardQuery w = (ExtSpanWildcardQuery)((Object)o);
        return w.preTerm.equals((Object)this.preTerm) && w.pattern.equals(this.pattern) && Arrays.deepEquals(w.excludedSuffixes, this.excludedSuffixes);
    }

    public int hashCode() {
        int result = this.preTerm.hashCode();
        result ^= result >>> 12 | result << 20;
        result ^= this.pattern.hashCode();
        result ^= result >>> 13 | result << 19;
        return result ^= Arrays.hashCode(this.excludedSuffixes);
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }

    private static class AllCharSeq
    implements CharSequence {
        private char ch;

        private AllCharSeq() {
        }

        public void set(char c) {
            this.ch = c;
        }

        public char charAt(int index) {
            return this.ch;
        }

        public int length() {
            return 1;
        }

        public CharSequence subSequence(int start, int end) {
            return Character.toString(this.ch);
        }
    }
}

