/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.es.nuvo.util.Vint8;
import com.ibm.supa.common.SUPAUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class ExtSpanVint8Query
extends ExtSpanQuery {
    private static final long serialVersionUID = -5503651734479508655L;
    private String readField;
    private String field;
    private int length;
    private int minStart;

    public ExtSpanVint8Query(String readField, String field, int length) {
        this(readField, field, length, 0);
    }

    public ExtSpanVint8Query(String readField, String field, int length, int minStart) {
        this.readField = readField;
        this.field = field;
        this.minStart = minStart;
        this.length = length;
    }

    public ExtSpans getExtSpans(final IndexReader reader) throws IOException {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.readField);
        SetBasedFieldSelector selector = new SetBasedFieldSelector(fields, Collections.EMPTY_SET);
        return new IterableExtSpans(reader, (FieldSelector)selector){
            int doc;
            Vint8.Position pos;
            int end;
            final /* synthetic */ FieldSelector val$selector;
            {
                this.val$selector = fieldSelector;
                super(x0);
                this.doc = -1;
                this.pos = new Vint8.Position();
            }

            public int numSubExtSpans() {
                return 0;
            }

            public ExtSpanQuery query() {
                return ExtSpanVint8Query.this;
            }

            public ExtSpans subExtSpan(int index) {
                return null;
            }

            public int start() {
                return Math.max(ExtSpanVint8Query.this.minStart, this.end - ExtSpanVint8Query.this.length);
            }

            public int doc() {
                return this.doc;
            }

            public int end() {
                return this.end;
            }

            public boolean next() throws IOException {
                do {
                    ++this.doc;
                    if (this.doc < reader.maxDoc()) continue;
                    return false;
                } while (reader.isDeleted(this.doc));
                Document document = reader.document(this.doc, this.val$selector);
                this.end = SUPAUtils.getEndPlainTextPos(document, this.pos);
                return true;
            }

            public boolean skipTo(int target) throws IOException {
                if (this.doc < target) {
                    this.doc = target - 1;
                }
                return this.next();
            }
        };
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        return Collections.EMPTY_SET;
    }

    public String toString(String arg0) {
        StringBuilder sBuf = new StringBuilder();
        sBuf.append("vint8(").append(this.readField).append(",").append(this.field).append(",");
        sBuf.append(this.length).append(",").append(this.minStart).append(")");
        return sBuf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanVint8Query)) {
            return false;
        }
        ExtSpanVint8Query other = (ExtSpanVint8Query)((Object)o);
        return this.readField.equals(other.readField) && this.field.equals(other.field) && this.length == other.length && this.minStart == other.minStart;
    }

    public int hashCode() {
        int result = this.readField.hashCode();
        result ^= result << 7 | result >>> 25;
        result ^= this.field.hashCode();
        result ^= result << 8 | result >>> 24;
        result ^= this.length;
        result ^= result << 9 | result >>> 23;
        return result ^= this.minStart;
    }
}

