/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.SpansPriorityQueue;
import com.ibm.supa.tokenizers.TTokenUtils;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.extended.ExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpanTermQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtSpanUtils {
    public static final Aligner<ExtSpans> DOC_ALIGNER = new Aligner<ExtSpans>(){

        @Override
        public boolean advance(ExtSpans from, ExtSpans to) throws IOException {
            return from.skipTo(to.doc());
        }

        @Override
        public boolean lessThan(ExtSpans o1, ExtSpans o2) {
            return o1.doc() < o2.doc();
        }
    };
    public static Comparator<Spans> POSITION_COMPARATOR = new Comparator<Spans>(){

        @Override
        public int compare(Spans o1, Spans o2) {
            int diff = o1.doc() - o2.doc();
            if (diff != 0) {
                return diff;
            }
            diff = o1.start() - o2.start();
            if (diff != 0) {
                return diff;
            }
            return o1.end() - o2.end();
        }
    };

    public static ExtSpanQuery[] makeTermQueries(String field, TToken ... tokens) {
        ExtSpanQuery[] result = new ExtSpanQuery[tokens.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ExtSpanUtils.makeTermQuery(field, tokens[i]);
        }
        return result;
    }

    public static ExtSpanTermQuery makeTermQuery(String field, TToken token) {
        Term term = new Term(field, ((Object)TTokenUtils.getMarkedUpText(token, false)).toString());
        return new ExtSpanTermQuery(term);
    }

    public static ExtSpanQuery[] makeTermQueries(String field, String ... termTexts) {
        ExtSpanQuery[] result = new ExtSpanQuery[termTexts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ExtSpanTermQuery(new Term(field, termTexts[i]));
        }
        return result;
    }

    public static ExtSpanAllNearQuery makeSinglePosQuery(ExtSpanQuery ... clauses) {
        return new ExtSpanAllNearQuery(clauses, null, -1, 0, true);
    }

    public static int getSpanLength(Spans spans) {
        return ExtSpanUtils.getSpanLength(spans.start(), spans.end());
    }

    public static int getSpanLength(int start, int end) {
        return end - start - 1;
    }

    public static boolean alignDocs(LinkedList<ExtSpans> workList, int minDoc, ExtSpans ... extSpans) throws IOException {
        return ExtSpanUtils.align(DOC_ALIGNER, workList, (int)minDoc, (ExtSpans[])extSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends ExtSpans> boolean align(Aligner<E> aligner, LinkedList<E> workList, int minDoc, E ... extSpans) throws IOException {
        boolean i;
        if (extSpans.length == 0) {
            return true;
        }
        workList.clear();
        workList.add((ExtSpans)extSpans[0]);
        for (i = true; i < extSpans.length; i += 1) {
            if (aligner.lessThan((ExtSpans)extSpans[i], (ExtSpans)workList.getLast())) {
                workList.addFirst((ExtSpans)extSpans[i]);
                continue;
            }
            workList.addLast((ExtSpans)extSpans[i]);
        }
        try {
            if (((ExtSpans)workList.getLast()).doc() < minDoc && !((ExtSpans)workList.getLast()).skipTo(minDoc)) {
                i = false;
                return i;
            }
            while (aligner.lessThan((ExtSpans)workList.getFirst(), (ExtSpans)workList.getLast())) {
                ExtSpans firstSpan = (ExtSpans)workList.removeFirst();
                if (!aligner.advance(firstSpan, (ExtSpans)workList.getLast())) {
                    boolean bl = false;
                    return bl;
                }
                if (firstSpan.doc() < ((ExtSpans)workList.getLast()).doc()) {
                    throw new IllegalStateException("advance() or skipTo() failed!");
                }
                workList.addLast(firstSpan);
            }
        }
        finally {
            workList.clear();
        }
        return true;
    }

    public static ExtSpans nonIterableCopy(ExtSpans original, boolean deepCopy, ExtSpanCopyHandler copyHandler) {
        ExtSpans result = original.nonIterableCopy(deepCopy);
        if (!deepCopy) {
            copyHandler.copied(original, result);
        }
        return result;
    }

    public static ExtSpans getLowestRoot(ExtSpans extSpans) {
        while (extSpans.numSubExtSpans() != 1) {
            extSpans = extSpans.subExtSpan(0);
        }
        return extSpans;
    }

    public static void extractDocSpans(List<ExtSpans> results, SpansPriorityQueue workingHeap, ExtSpanCopyHandler copyHandler, boolean deepCopy, ExtSpans ... extSpans) throws IOException {
        if (extSpans.length == 0) {
            return;
        }
        int currDoc = extSpans[0].doc();
        workingHeap.clear();
        for (int i = 0; i < extSpans.length; ++i) {
            workingHeap.put(extSpans[i]);
        }
        while (workingHeap.size() > 0 && currDoc == ((ExtSpans)workingHeap.top()).doc()) {
            ExtSpans top = (ExtSpans)workingHeap.top();
            ExtSpans currSpan = ExtSpanUtils.nonIterableCopy(top, deepCopy, copyHandler);
            results.add(currSpan);
            if (top.next()) {
                workingHeap.adjustTop();
                continue;
            }
            workingHeap.pop();
        }
    }

    public static String getField(ExtSpanQuery[] clauses) throws IllegalArgumentException {
        String result = null;
        for (int i = 0; i < clauses.length; ++i) {
            if (i == 0) {
                result = clauses[i].getField();
                continue;
            }
            if (clauses[i].getField().equals(result)) continue;
            throw new IllegalArgumentException("Clauses must all have the same field");
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtSpanQueryAdapter
    extends ExtSpanQuery {
        private static final long serialVersionUID = -4364192451976834332L;
        private final ExtSpanQuery query;
        private final Class<? extends ExtSpans> resultClass;

        public ExtSpanQueryAdapter(ExtSpanQuery query, Class<? extends ExtSpans> resultClass) {
            this.query = query;
            this.resultClass = resultClass;
        }

        @Override
        public ExtSpans getExtSpans(IndexReader reader) throws IOException {
            Class[] classArray;
            final ExtSpans extSpans = this.query.getExtSpans(reader);
            InvocationHandler eHandler = new InvocationHandler(){
                HashSet<Method> methods = new HashSet();

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        if (this.methods.contains(method)) {
                            return method.invoke((Object)extSpans.subExtSpan(0), args);
                        }
                        return method.invoke((Object)extSpans, args);
                    }
                    catch (IllegalArgumentException e) {
                        this.methods.add(method);
                        return method.invoke((Object)extSpans.subExtSpan(0), args);
                    }
                }
            };
            if (this.resultClass.isInterface()) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = this.resultClass;
            } else {
                classArray = this.resultClass.getInterfaces();
            }
            Class[] interfaces = classArray;
            return (ExtSpans)Proxy.newProxyInstance(this.resultClass.getClassLoader(), interfaces, eHandler);
        }

        @Override
        public ExtSpanQuery includedClause(int i) {
            return this.query.includedClause(i);
        }

        @Override
        public int numIncludedClauses() {
            return this.query.numIncludedClauses();
        }

        @Override
        public ExtSpanQuery optimize(boolean recurseToClauses) {
            return this;
        }

        public String getField() {
            return this.query.getField();
        }

        @Deprecated
        public Collection getTerms() {
            return this.query.getTerms();
        }

        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public Class<? extends ExtSpans> getResultClass() {
            return this.resultClass;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ExtSpanQueryAdapter)) {
                return false;
            }
            ExtSpanQueryAdapter other = (ExtSpanQueryAdapter)((Object)o);
            return other.query.equals((Object)this.query) && other.resultClass.equals(this.resultClass);
        }

        @Override
        public int hashCode() {
            return this.query.hashCode() ^ this.resultClass.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Aligner<E extends ExtSpans> {
        public boolean advance(E var1, E var2) throws IOException;

        public boolean lessThan(E var1, E var2);
    }
}

