/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class ExtSpanQuerySelector
extends ExtSpanQuery {
    private static final long serialVersionUID = -6622940948820777645L;
    private final ExtSpanQuery query;
    private final ExtSpanQuery targetSubQuery;

    public ExtSpanQuerySelector(ExtSpanQuery query, ExtSpanQuery targetSubQuery) {
        this.query = query;
        this.targetSubQuery = targetSubQuery;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new DelegatedExtSpans(this.query.getExtSpans(reader), this, null, this.targetSubQuery);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanQuerySelector)) {
            return false;
        }
        ExtSpanQuerySelector other = (ExtSpanQuerySelector)((Object)o);
        return other.query.equals((Object)this.query) && other.targetSubQuery == this.targetSubQuery;
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result ^= result << 27 | result >>> 5;
        if (this.targetSubQuery != null) {
            result ^= this.targetSubQuery.hashCode();
        }
        return result;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }

    public ExtSpanQuery includedClause(int i) {
        return this.query;
    }

    public int numIncludedClauses() {
        return 1;
    }

    public String getField() {
        return this.query.getField();
    }

    @Deprecated
    public Collection getTerms() {
        return this.query.getTerms();
    }

    public String toString(String field) {
        return "selector(" + this.query.toString(field) + "," + this.targetSubQuery.toString(field) + ")";
    }
}

