/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.filter.ResultFilter;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeSet;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtSpanQueryScorer {
    private static final double ETA = 1.0E-6;
    private ExtSpanScorer scorer;
    private boolean saveExtSpans = true;
    private boolean generateExplanations;
    private int maxResults;
    private int maxInMemoryResults;
    private TreeSet<SpanResult> spanResults;
    private int totalResults;
    private Map<String, ScoreDoc[]> scoreDocs;

    public ExtSpanQueryScorer() {
        this(null);
    }

    public ExtSpanQueryScorer(ExtSpanScorer scorer) {
        this.scorer = scorer;
        this.generateExplanations = false;
        this.maxResults = Integer.MAX_VALUE;
        this.maxInMemoryResults = Integer.MAX_VALUE;
        this.spanResults = new TreeSet();
        this.scoreDocs = null;
    }

    public ExtSpanScorer getScorer() {
        return this.scorer;
    }

    public void setScorer(ExtSpanScorer scorer) {
        this.scorer = scorer;
    }

    public boolean savesExtSpans() {
        return this.saveExtSpans;
    }

    public void setSaveExtSpans(boolean saveExtSpans) {
        this.saveExtSpans = saveExtSpans;
    }

    public boolean isGenerateExplanations() {
        return this.generateExplanations;
    }

    public void setGenerateExplanations(boolean generateExplanations) {
        this.generateExplanations = generateExplanations;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxInMemoryResults() {
        return this.maxInMemoryResults;
    }

    public void setMaxInMemoryResults(int maxInMemoryResults) {
        this.maxInMemoryResults = maxInMemoryResults;
    }

    public void clearResults() {
        this.spanResults.clear();
        this.totalResults = 0;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean score(long timeout, ExtSpans extSpans, SearchWrapper wrapper, SearchSnapshot snapshot, SupaQuery activeSupaQuery) throws IOException {
        try {
            if (!extSpans.next()) {
                boolean bl = true;
                return bl;
            }
            SpanResult currentResult = this.makePenalizedSpanResult(extSpans, wrapper, snapshot, activeSupaQuery);
            PenaltyScore rootScore = null;
            while (System.currentTimeMillis() <= timeout && extSpans.next()) {
                if (currentResult.isAtSameLocation(extSpans)) {
                    if ((rootScore = this.updatePenaltyScore(extSpans, rootScore)).getPenalty() < currentResult.penalty()) {
                        if (this.generateExplanations) {
                            PenaltyScore temp = currentResult.getPenaltyScore();
                            currentResult.setPenaltyScore(rootScore);
                            rootScore = temp;
                            rootScore.clear();
                        } else {
                            currentResult.setPenalty(rootScore.getPenalty());
                            rootScore.clear();
                        }
                        if (!this.saveExtSpans) continue;
                        currentResult.setExtSpans(extSpans);
                        continue;
                    }
                    rootScore.clear();
                    currentResult.incrementNumSamePosExtSpans();
                    continue;
                }
                this.addResult(currentResult);
                currentResult = this.makePenalizedSpanResult(extSpans, wrapper, snapshot, activeSupaQuery);
            }
            this.addResult(currentResult);
            this.ensureNoOverflow(this.maxResults);
            boolean bl = System.currentTimeMillis() <= timeout;
            return bl;
        }
        finally {
            if (snapshot != null) {
                ArrayList<SpanResult> resultsList = new ArrayList<SpanResult>();
                resultsList.addAll(this.spanResults);
                Collections.sort(resultsList, SpanResult.POSITION_COMPARATOR);
                snapshot.setResults(wrapper.getCollectionId(), resultsList, wrapper.getIndexVersion());
            }
        }
    }

    private void addResult(SpanResult current) {
        this.spanResults.add(current);
        ++this.totalResults;
        this.ensureNoOverflow(this.maxInMemoryResults);
        if (!this.saveExtSpans) {
            return;
        }
    }

    private void ensureNoOverflow(int max) {
        while (this.spanResults.size() > max) {
            this.spanResults.remove(this.spanResults.last());
        }
    }

    private SpanResult makePenalizedSpanResult(ExtSpans extSpans, SearchWrapper wrapper, SearchSnapshot snapshot, SupaQuery activeSupaQuery) {
        SpanResult result = ExtSpanQueryScorer.makeSpanResult(extSpans, wrapper);
        result.setType(SpanResult.Type.PARTIAL_DOC);
        SupaQuery returnedQuery = null;
        returnedQuery = snapshot == null ? activeSupaQuery : snapshot.getReturnedSnapshot().getQueryClone();
        if (returnedQuery != null && returnedQuery.getType() == SupaQuery.Type.DOC) {
            result.setType(SpanResult.Type.COMPLETE_DOC);
        }
        result.setPenaltyScore(this.updatePenaltyScore(extSpans, null));
        if (this.saveExtSpans) {
            result.setExtSpans(extSpans);
        }
        return result;
    }

    private PenaltyScore updatePenaltyScore(ExtSpans extSpans, PenaltyScore result) {
        if (result == null) {
            result = new PenaltyScore();
        }
        this.scorer.updatePenaltyScore(extSpans, result, this.generateExplanations);
        return result;
    }

    public static SpanResult makeSpanResult(ExtSpans extSpans, SearchWrapper wrapper) {
        return new SpanResult(wrapper, extSpans.start(), extSpans.end(), extSpans.doc());
    }

    public int size() {
        return this.spanResults.size();
    }

    public boolean isEmpty() {
        return this.spanResults.isEmpty();
    }

    public int extractTopLevel(List<SpanResult> spanResultsList) {
        return this.extractTopLevel(spanResultsList, 1.0E-6);
    }

    public int extractTopLevel(List<SpanResult> spanResultsList, double eta) {
        if (this.spanResults.isEmpty()) {
            return 0;
        }
        SpanResult top = this.pop();
        spanResultsList.add(top);
        int result = 1;
        double topPenalty = top.penalty();
        while (!this.spanResults.isEmpty() && Math.abs(topPenalty - this.spanResults.first().penalty()) < eta) {
            spanResultsList.add(this.pop());
            ++result;
        }
        return result;
    }

    public void copySameDocExtSpans(List<ExtSpans> extSpansList, SpanResult sourceResult) {
        PriorityQueue<Spans> orderedSpans = null;
        for (SpanResult result : this.spanResults) {
            if (result.getSearchWrapper() != sourceResult.getSearchWrapper() || result.doc() != sourceResult.doc()) continue;
            if (orderedSpans == null) {
                orderedSpans = new PriorityQueue<Spans>(11, ExtSpanUtils.POSITION_COMPARATOR);
            }
            orderedSpans.add(result.getExtSpans());
        }
        if (orderedSpans != null) {
            while (!orderedSpans.isEmpty()) {
                extSpansList.add((ExtSpans)orderedSpans.poll());
            }
        }
    }

    public int copyOut(List<SpanResult> spanResultsList, int firstRequestedResult, int numRequestedResults, String[] collectionIds, ResultFilter[][] filters) throws ExtendedException {
        IdentityHashMap<String, ScoreDoc[]> filteredDocs = null;
        IdentityHashMap<String, Integer> collectionIndexLookup = null;
        boolean useFilters = false;
        if (filters != null && filters.length != 0) {
            for (ResultFilter[] subFilters : filters) {
                if (subFilters == null || subFilters.length == 0) continue;
                useFilters = true;
                break;
            }
        }
        boolean resultsAvailable = false;
        if (useFilters) {
            filteredDocs = new IdentityHashMap<String, ScoreDoc[]>();
            collectionIndexLookup = new IdentityHashMap<String, Integer>();
            this.buildScoreDocs();
            filteredDocs.putAll(this.scoreDocs);
            for (int i = 0; i < collectionIds.length; ++i) {
                String collectionId;
                ScoreDoc[] colFilterDocs;
                if (filters[i] == null || filters[i].length == 0 || (colFilterDocs = (ScoreDoc[])filteredDocs.get(collectionId = collectionIds[i])) == null) continue;
                for (ResultFilter filter : filters[i]) {
                    colFilterDocs = filter.filter(colFilterDocs, firstRequestedResult, numRequestedResults);
                }
                if (colFilterDocs.length != 0) {
                    resultsAvailable = true;
                }
                filteredDocs.put(collectionId, colFilterDocs);
                collectionIndexLookup.put(collectionId, i);
            }
        } else {
            resultsAvailable = true;
        }
        if (!resultsAvailable) {
            return 0;
        }
        int current = 0;
        int[] docIndeces = new int[collectionIds.length];
        for (SpanResult spanResult : this.spanResults) {
            String collectionId;
            ScoreDoc[] colFilterDocs;
            if (filteredDocs != null && (colFilterDocs = (ScoreDoc[])filteredDocs.get(collectionId = spanResult.getCollectionId())) != null) {
                int index = (Integer)collectionIndexLookup.get(collectionId);
                int docIndex = docIndeces[index];
                if (docIndex >= colFilterDocs.length) continue;
                while (docIndex < colFilterDocs.length && colFilterDocs[docIndex].doc < spanResult.doc()) {
                    ++docIndex;
                }
                docIndeces[index] = docIndex;
                if (docIndex >= colFilterDocs.length || colFilterDocs[docIndex].doc > spanResult.doc()) continue;
            }
            if (current >= firstRequestedResult && spanResultsList.size() < numRequestedResults) {
                spanResultsList.add(spanResult);
                if (filteredDocs == null && spanResultsList.size() == numRequestedResults) {
                    return this.spanResults.size();
                }
            }
            ++current;
        }
        return current;
    }

    public void collectHits(HitCollector collector, String collectionId) {
        this.buildScoreDocs();
        ScoreDoc[] collectionScoreDocs = this.scoreDocs.get(collectionId);
        if (collectionScoreDocs == null) {
            return;
        }
        for (ScoreDoc scoreDoc : collectionScoreDocs) {
            collector.collect(scoreDoc.doc, scoreDoc.score);
        }
    }

    private void buildScoreDocs() {
        if (this.scoreDocs != null) {
            return;
        }
        Comparator<SpanResult> comparator = new Comparator<SpanResult>(){

            @Override
            public int compare(SpanResult o1, SpanResult o2) {
                return o1.doc() - o2.doc();
            }
        };
        IdentityHashMap<String, TreeSet<SpanResult>> spanResultDocs = new IdentityHashMap<String, TreeSet<SpanResult>>();
        for (SpanResult spanResult : this.spanResults) {
            TreeSet<SpanResult> docs = (TreeSet<SpanResult>)spanResultDocs.get(spanResult.getCollectionId());
            if (docs == null) {
                docs = new TreeSet<SpanResult>(comparator);
                spanResultDocs.put(spanResult.getCollectionId(), docs);
            }
            docs.add(spanResult);
        }
        this.scoreDocs = new HashMap<String, ScoreDoc[]>();
        for (Map.Entry entry : spanResultDocs.entrySet()) {
            ScoreDoc[] collectionScoreDocs = new ScoreDoc[((TreeSet)entry.getValue()).size()];
            int current = 0;
            for (SpanResult result : (TreeSet)entry.getValue()) {
                collectionScoreDocs[current] = new ScoreDoc(result.doc(), (float)result.penalty());
                ++current;
            }
            this.scoreDocs.put((String)entry.getKey(), collectionScoreDocs);
        }
    }

    private SpanResult pop() {
        SpanResult result = this.spanResults.first();
        this.spanResults.remove(result);
        return result;
    }
}

