/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;

public class ExtSpanQueryFilter
extends ExtSpanQuery {
    private static final long serialVersionUID = -6622940948820777645L;
    private final ExtSpanQuery query;
    private final ExtSpansFilter filter;

    public ExtSpanQueryFilter(ExtSpanQuery query, ExtSpansFilter filter) {
        this.query = query;
        this.filter = filter;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new DelegatedExtSpans(this.query.getExtSpans(reader), this, this.filter.clone());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanQueryFilter)) {
            return false;
        }
        ExtSpanQueryFilter other = (ExtSpanQueryFilter)((Object)o);
        return other.query.equals((Object)this.query) && other.filter.equals(this.filter);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result ^= result << 28 | result >>> 4;
        return result ^= this.filter.hashCode();
    }

    public ExtSpanQuery includedClause(int i) {
        return this.query;
    }

    public int numIncludedClauses() {
        return 1;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery child;
        ExtSpanQueryFilter result = this;
        if (recurseToClauses && (child = this.query.optimize(true)) != this.query) {
            result = new ExtSpanQueryFilter(child, this.filter.clone());
        }
        return result;
    }

    public String getField() {
        return this.query.getField();
    }

    @Deprecated
    public Collection getTerms() {
        return this.query.getTerms();
    }

    public String toString(String field) {
        return "filter(" + this.query.toString(field) + "," + this.filter.toString() + ")";
    }
}

