/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class ExtSpanQueryFieldChanger
extends ExtSpanQuery {
    private static final long serialVersionUID = 2750656615756176744L;
    final ExtSpanQuery query;
    final String field;

    public ExtSpanQueryFieldChanger(ExtSpanQuery query, String field) {
        this.query = query;
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new DelegatedExtSpans(this.query.getExtSpans(reader), this);
    }

    public ExtSpanQuery includedClause(int i) {
        return this.query;
    }

    public int numIncludedClauses() {
        return 1;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery optimized;
        ExtSpanQueryFieldChanger result = this;
        if (recurseToClauses && (optimized = this.query.optimize(true)) != this.query) {
            result = new ExtSpanQueryFieldChanger(optimized, this.field);
        }
        return result;
    }

    @Deprecated
    public Collection getTerms() {
        HashSet result = new HashSet();
        this.extractTerms(result);
        return result;
    }

    public void extractTerms(Set terms) {
        Collection oldTerms = this.query.getTerms();
        for (Term term : oldTerms) {
            if (term.field().equals(this.query.getField())) {
                terms.add(new Term(this.field, term.text()));
                continue;
            }
            terms.add(term);
        }
    }

    public String toString(String field) {
        StringBuilder result = new StringBuilder();
        result.append("fieldChanger(").append(this.query.toString(field));
        result.append(",").append(this.field).append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof ExtSpanQueryFieldChanger) {
            ExtSpanQueryFieldChanger other = (ExtSpanQueryFieldChanger)((Object)o);
            return other.field.equals(this.field) && other.query.equals((Object)this.query);
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.field.hashCode() + 7;
    }
}

