/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.AllContainsExtSpans;
import com.ibm.supa.search.spans.extended.SimpleContainsExtSpans;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanContainsQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = 1231395140830218689L;
    private ExtSpanQuery container;
    private ExtSpanQuery containee;
    private boolean allSpans;
    private boolean forceAllSpans = false;
    private boolean includeContainer;

    public ExtSpanContainsQuery(ExtSpanQuery container, ExtSpanQuery containee) {
        this(container, containee, true);
    }

    public ExtSpanContainsQuery(ExtSpanQuery container, ExtSpanQuery containee, boolean includeContainer) {
        this.container = container;
        this.containee = containee;
        this.allSpans = true;
        this.includeContainer = includeContainer;
        if (!container.getField().equals(containee.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public boolean isAllSpans() {
        return this.allSpans;
    }

    public void setAllSpans(boolean allSpans) {
        this.allSpans = allSpans;
    }

    public boolean isForceAllSpans() {
        return this.forceAllSpans;
    }

    public void setForceAllSpans(boolean forceAllSpans) {
        this.forceAllSpans = forceAllSpans;
    }

    public boolean isIncludeContainer() {
        return this.includeContainer;
    }

    public void setIncludeContainer(boolean includeContainer) {
        this.includeContainer = includeContainer;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        if (this.forceAllSpans || this.allSpans && this.includeContainer) {
            return new AllContainsExtSpans(this, this.container, this.containee, reader);
        }
        return new SimpleContainsExtSpans(this, this.container, this.containee, reader);
    }

    public ExtSpanQuery includedClause(int i) {
        if (i == 0 && this.includeContainer) {
            return this.container;
        }
        return this.containee;
    }

    public int numIncludedClauses() {
        return this.includeContainer ? 2 : 1;
    }

    public String getField() {
        return this.container.getField();
    }

    @Deprecated
    public Collection getTerms() {
        HashSet result = new HashSet();
        result.addAll(this.container.getTerms());
        result.addAll(this.containee.getTerms());
        return result;
    }

    public void extractTerms(Set terms) {
        this.container.extractTerms(terms);
        this.containee.extractTerms(terms);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("extSpanContains([");
        buffer.append(this.container.toString(field));
        buffer.append(", ");
        buffer.append(this.containee.toString(field));
        buffer.append("], ");
        buffer.append(this.allSpans);
        buffer.append(", ");
        buffer.append(this.includeContainer);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanContainsQuery result = this;
        if (recurseToClauses) {
            ExtSpanQuery c1 = this.container.optimize(true);
            ExtSpanQuery c2 = this.containee.optimize(true);
            if (c1 != this.container || c2 != this.containee) {
                result = (ExtSpanContainsQuery)((Object)this.clone());
                result.container = c1;
                result.containee = c2;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanContainsQuery)) {
            return false;
        }
        ExtSpanContainsQuery other = (ExtSpanContainsQuery)((Object)o);
        return other.forceAllSpans == this.forceAllSpans && other.allSpans == this.allSpans && other.includeContainer == this.includeContainer && other.container.equals((Object)this.container) && other.containee.equals((Object)this.containee);
    }

    public int hashCode() {
        int result = this.container.hashCode();
        result ^= result << 13 | result >>> 19;
        result ^= this.containee.hashCode();
        result ^= result << 14 | result >>> 18;
        result ^= this.forceAllSpans ? -1716530243 : 0;
        result ^= result << 15 | result >>> 17;
        result ^= this.allSpans ? -1716530243 : 0;
        result ^= result << 16 | result >>> 16;
        return result ^= this.includeContainer ? -1716530243 : 0;
    }
}

