/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.AllNearExtSpans;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.extended.DefaultExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanAllNearQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = 4722297926282722775L;
    private int localSlop;
    private int globalSlop;
    private int overlapGlobalSlop;
    private ExtSpanQuery[] clauses;
    private boolean[] optionals;
    private int minNumOptionalInResult = 0;
    private boolean allowPartialResults = true;
    private boolean deepCopySubSpans = true;
    private ExtSpanCopyHandler copyHandler = DefaultExtSpanCopyHandler.instance;
    private int maxOverlapAllowed = Integer.MAX_VALUE;
    private boolean inOrder;
    private String field;
    private ExtSpanQuery[] subSpanQuerySortOrder;

    private static boolean[] getOptionals(boolean clausesOptional, int numClauses) {
        boolean[] optionals = null;
        if (clausesOptional) {
            optionals = new boolean[numClauses];
            Arrays.fill(optionals, true);
        }
        return optionals;
    }

    public ExtSpanAllNearQuery(int localSlop, boolean inOrder, boolean clausesOptional, ExtSpanQuery ... clauses) {
        this(clauses, ExtSpanAllNearQuery.getOptionals(clausesOptional, clauses.length), localSlop, inOrder);
    }

    public ExtSpanAllNearQuery(ExtSpanQuery[] clauses, int localSlop, boolean inOrder) {
        this(clauses, null, localSlop, inOrder);
    }

    public ExtSpanAllNearQuery(ExtSpanQuery[] clauses, boolean[] optionals, int localSlop, boolean inOrder) {
        this(clauses, optionals, localSlop, Math.max(0, (clauses.length - 1) * localSlop), inOrder);
    }

    public ExtSpanAllNearQuery(ExtSpanQuery[] clauses, boolean[] optionals, int localSlop, int globalSlop, boolean inOrder) {
        this.clauses = clauses;
        this.optionals = new boolean[clauses.length];
        if (optionals != null) {
            System.arraycopy(optionals, 0, this.optionals, 0, Math.min(clauses.length, optionals.length));
        }
        this.field = ExtSpanUtils.getField(clauses);
        this.localSlop = localSlop;
        this.globalSlop = globalSlop;
        this.overlapGlobalSlop = globalSlop;
        this.inOrder = inOrder;
    }

    public boolean[] getOptionals() {
        return this.optionals;
    }

    public void setOptionals(boolean[] optional) {
        this.optionals = optional;
    }

    public boolean isAllowPartialResults() {
        return this.allowPartialResults;
    }

    public void setAllowPartialResults(boolean allowPartialResults) {
        this.allowPartialResults = allowPartialResults;
    }

    public int getMinNumOptionalInResult() {
        return this.minNumOptionalInResult;
    }

    public void setMinNumOptionalInResult(int minNumOptionalInResult) {
        this.minNumOptionalInResult = minNumOptionalInResult;
    }

    public int getMaxOverlapAllowed() {
        return this.maxOverlapAllowed;
    }

    public void setMaxOverlapAllowed(int maxOverlapAllowed) {
        this.maxOverlapAllowed = maxOverlapAllowed;
    }

    public boolean isDeepCopySubSpans() {
        return this.deepCopySubSpans;
    }

    public void setDeepCopySubSpans(boolean deepCopySubSpans) {
        this.deepCopySubSpans = deepCopySubSpans;
    }

    public ExtSpanCopyHandler getCopyHandler() {
        return this.copyHandler;
    }

    public void setCopyHandler(ExtSpanCopyHandler copier) {
        this.copyHandler = copier;
    }

    public ExtSpanQuery[] getClauses() {
        return this.clauses;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public int getGlobalSlop() {
        return this.globalSlop;
    }

    public int getLocalSlop() {
        return this.localSlop;
    }

    public int getOverlapGlobalSlop() {
        return this.overlapGlobalSlop;
    }

    public void setOverlapGlobalSlop(int maxSpanLength) {
        this.overlapGlobalSlop = maxSpanLength;
    }

    public ExtSpanQuery[] getSubSpanQuerySortOrder() {
        return this.subSpanQuerySortOrder;
    }

    public void setSubSpanQuerySortOrder(ExtSpanQuery ... subQuerySortOrder) {
        this.subSpanQuerySortOrder = subQuerySortOrder;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        if (this.clauses.length <= 1) {
            ExtSpans extSpans = this.clauses.length == 0 ? new ExtSpanOrQuery(this.clauses).getExtSpans(reader) : this.clauses[0].getExtSpans(reader);
            return new DelegatedExtSpans(extSpans, this);
        }
        return new AllNearExtSpans(this, reader);
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery result = this;
        if (this.clauses.length <= 1) {
            result = this.clauses.length == 0 ? new ExtSpanOrQuery(this.clauses) : this.clauses[0];
            if (recurseToClauses) {
                result = result.optimize(true);
            }
        } else if (recurseToClauses) {
            ExtSpanAllNearQuery clone = this;
            for (int i = 0; i < this.clauses.length; ++i) {
                ExtSpanQuery optimized = this.clauses[i].optimize(true);
                if (optimized == this.clauses[i]) continue;
                if (clone == this) {
                    clone = (ExtSpanAllNearQuery)((Object)this.clone());
                    clone.clauses = (ExtSpanQuery[])clone.clauses.clone();
                }
                clone.clauses[i] = optimized;
            }
            result = clone;
        }
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ExtSpanAllNearQuery clone = null;
        for (int i = 0; i < this.clauses.length; ++i) {
            ExtSpanQuery c = this.clauses[i];
            ExtSpanQuery query = (ExtSpanQuery)this.clauses[i].rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = (ExtSpanAllNearQuery)((Object)this.clone());
            }
            clone.clauses[i] = query;
        }
        return clone != null ? clone : this;
    }

    public String getField() {
        return this.field;
    }

    @Deprecated
    public Collection getTerms() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.clauses.length; ++i) {
            result.addAll(this.clauses[i].getTerms());
        }
        return result;
    }

    public ExtSpanQuery includedClause(int i) {
        return this.clauses[i];
    }

    public int numIncludedClauses() {
        return this.clauses.length;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("extSpanAllNear([");
        if (this.clauses.length > 0) {
            buffer.append(this.clauses[0].toString(field));
            for (int i = 1; i < this.clauses.length; ++i) {
                buffer.append(", ").append(this.clauses[i].toString(field));
            }
        }
        buffer.append("], ");
        buffer.append(this.localSlop);
        buffer.append(", ");
        buffer.append(this.globalSlop);
        buffer.append(", ");
        buffer.append(this.overlapGlobalSlop);
        buffer.append(", ");
        buffer.append(this.maxOverlapAllowed);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanAllNearQuery)) {
            return false;
        }
        ExtSpanAllNearQuery other = (ExtSpanAllNearQuery)((Object)o);
        if (this.inOrder != other.inOrder) {
            return false;
        }
        if (this.localSlop != other.localSlop) {
            return false;
        }
        if (this.globalSlop != other.globalSlop) {
            return false;
        }
        if (this.overlapGlobalSlop != other.overlapGlobalSlop) {
            return false;
        }
        if (this.deepCopySubSpans != other.deepCopySubSpans) {
            return false;
        }
        if (!this.copyHandler.equals(other.copyHandler)) {
            return false;
        }
        if (this.maxOverlapAllowed != other.maxOverlapAllowed) {
            return false;
        }
        if (!Arrays.equals((Object[])this.clauses, (Object[])other.clauses)) {
            return false;
        }
        return this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int result = Arrays.hashCode((Object[])this.clauses);
        result ^= result << 12 | result >>> 20;
        result += this.localSlop;
        result ^= result << 13 | result >>> 19;
        result += this.globalSlop;
        result ^= result << 14 | result >>> 18;
        result += this.overlapGlobalSlop;
        result ^= result << 15 | result >>> 17;
        result += this.maxOverlapAllowed;
        result ^= result << 16 | result >>> 16;
        result ^= this.copyHandler.hashCode();
        result ^= result << 17 | result >>> 15;
        result ^= this.inOrder ? -1716530243 : 0;
        result ^= result << 18 | result >>> 14;
        result ^= this.deepCopySubSpans ? -1716530243 : 0;
        result ^= result << 19 | result >>> 13;
        return result += Float.floatToRawIntBits(this.getBoost());
    }
}

