/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocExtSpanScorer
implements ExtSpanScorer {
    private List<ScoreDoc> scoreDocs;
    private int currIndex = 0;
    private final float normFactor;
    private final float boost = 20.0f;
    private HashMap<Integer, Double> docsScoreFactor;

    public DocExtSpanScorer(HashMap<Integer, Double> docsScoreFactor, List<ScoreDoc> scoreDocs, boolean scoreDocsAreSorted, float highestScore) {
        this.docsScoreFactor = docsScoreFactor;
        this.scoreDocs = scoreDocs;
        if (!scoreDocsAreSorted) {
            Collections.sort(this.scoreDocs, new Comparator<ScoreDoc>(){

                @Override
                public int compare(ScoreDoc o1, ScoreDoc o2) {
                    return o1.doc - o2.doc;
                }
            });
        }
        this.normFactor = highestScore > 0.0f && highestScore <= 1.0f ? (0.8f + 0.2f * highestScore) / highestScore : (highestScore > 1.0f ? 1.0f / highestScore : 1.0f);
    }

    @Override
    public void updatePenaltyScore(ExtSpans extSpans, PenaltyScore result, boolean generateExplanations) {
        int docNum = extSpans.doc();
        this.internalUpdate(result, docNum);
    }

    private void internalUpdate(PenaltyScore result, int docNum) {
        while (docNum > this.scoreDocs.get((int)this.currIndex).doc) {
            if (this.currIndex < this.scoreDocs.size()) {
                ++this.currIndex;
                continue;
            }
            return;
        }
        if (docNum == this.scoreDocs.get((int)this.currIndex).doc) {
            float normScore = this.scoreDocs.get((int)this.currIndex).score;
            if (normScore < 0.0f) {
                normScore = 0.0f;
            } else if ((normScore *= this.normFactor) > 1.0f) {
                normScore = 1.0f;
            }
            Double scorePenalty = new Double(1.0);
            if (this.docsScoreFactor != null) {
                scorePenalty = this.docsScoreFactor.get(docNum);
            }
            double f = scorePenalty;
            double p = (1.0f - normScore) * 20.0f;
            double gp = this.convertFactorAndPenalizeToGlobalPenalize(p, f);
            result.penalize(gp);
            return;
        }
    }

    private double convertFactorAndPenalizeToGlobalPenalize(double p, double f) {
        return p + (1.0 - f) * (100.0 - p);
    }
}

