/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.extended.ExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComplexExtSpans<E extends ExtSpanQuery>
extends IterableExtSpans {
    protected ExtSpans[] extSpans;
    protected boolean[] spansValid;
    protected final E query;
    protected final boolean deepCopy;
    protected final ExtSpanCopyHandler copyHandler;

    public BaseComplexExtSpans(IndexReader reader, E query, boolean deepCopy, ExtSpanCopyHandler copyHandler) {
        super(reader);
        this.query = query;
        this.deepCopy = deepCopy;
        this.copyHandler = copyHandler;
    }

    protected void initialize(IndexReader reader, ExtSpanQuery ... clauses) throws IOException {
        this.extSpans = new ExtSpans[clauses.length];
        this.spansValid = new boolean[this.extSpans.length];
        for (int i = 0; i < clauses.length; ++i) {
            this.extSpans[i] = clauses[i].getExtSpans(reader);
            this.spansValid[i] = this.extSpans[i].next();
        }
    }

    protected boolean allValid() {
        for (boolean valid : this.spansValid) {
            if (valid) continue;
            return false;
        }
        return true;
    }

    protected boolean increment(int i) throws IOException {
        if (this.spansValid[i]) {
            this.spansValid[i] = this.extSpans[i].next();
        }
        return this.spansValid[i];
    }

    protected ExtSpans nonIterableCopy(ExtSpans originalSubSpan) {
        return ExtSpanUtils.nonIterableCopy(originalSubSpan, this.deepCopy, this.copyHandler);
    }

    protected void free(ExtSpans copy) {
        this.copyHandler.free(copy);
    }

    protected boolean manageLifecycle() {
        return !this.deepCopy && this.copyHandler.usesResourcesForShallowCopies();
    }

    @Override
    public ExtSpanQuery query() {
        return this.query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Cell
    implements Comparable<Cell> {
        private final int extSpanIndex;
        private LinkedList<ExtSpans> docSpans;
        private ListIterator<ExtSpans> iter;
        private ExtSpans curr;
        private ExtSpans headCopy;
        private boolean reset = false;
        private int lastDoc = -1;

        Cell(int extSpanIndex) throws IOException {
            this.extSpanIndex = extSpanIndex;
            this.docSpans = new LinkedList();
            this.docSpans.add(BaseComplexExtSpans.this.extSpans[extSpanIndex]);
            this.clear(-1);
        }

        boolean updateLastDoc() {
            if (!BaseComplexExtSpans.this.spansValid[this.extSpanIndex]) {
                return false;
            }
            this.lastDoc = BaseComplexExtSpans.this.extSpans[this.extSpanIndex].doc();
            return true;
        }

        public int extSpanIndex() {
            return this.extSpanIndex;
        }

        @Override
        public int compareTo(Cell o) {
            int result = this.compare(this.curr, o.curr);
            if (result == 0) {
                result = this.extSpanIndex - o.extSpanIndex;
            }
            return result;
        }

        protected int compare(Spans s1, Spans s2) {
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            int diff = s1.doc() - s2.doc();
            if (diff != 0) {
                return diff;
            }
            diff = s1.start() - s2.start();
            if (diff != 0) {
                return diff;
            }
            return s1.end() - s2.end();
        }

        boolean currentExists() {
            return this.curr != null;
        }

        boolean next() throws IOException {
            return this.next(false);
        }

        boolean hasResults() {
            return BaseComplexExtSpans.this.spansValid[this.extSpanIndex] || this.docSpans.size() > 1;
        }

        boolean next(boolean removeCurrent) throws IOException {
            this.reset = false;
            this.loadNext(removeCurrent);
            return this.currentExists();
        }

        private void loadNext(boolean removeCurrent) throws IOException {
            if (this.iter.hasNext()) {
                if (removeCurrent && this.iter.hasPrevious()) {
                    BaseComplexExtSpans.this.free(this.iter.previous());
                    this.iter.remove();
                }
                this.curr = this.iter.next();
                return;
            }
            assert (this.curr == BaseComplexExtSpans.this.extSpans[this.extSpanIndex]);
            if (!removeCurrent) {
                this.iter.set(this.currentAsCopy());
                this.postIterOp();
            }
            if (BaseComplexExtSpans.this.increment(this.extSpanIndex)) {
                if (!removeCurrent) {
                    this.iter.add(this.curr);
                    this.postIterOp();
                }
            } else {
                this.curr = null;
                if (removeCurrent) {
                    this.iter.remove();
                }
            }
            this.headCopy = null;
        }

        private void postIterOp() {
            if (this.iter.hasPrevious()) {
                this.iter.previous();
                this.iter.next();
            } else if (this.iter.hasNext()) {
                this.iter.next();
                this.iter.previous();
            }
        }

        ExtSpans current() {
            return this.curr;
        }

        ExtSpans currentAsCopy() {
            if (this.curr != BaseComplexExtSpans.this.extSpans[this.extSpanIndex]) {
                return this.curr;
            }
            if (this.headCopy == null) {
                this.headCopy = BaseComplexExtSpans.this.nonIterableCopy(this.curr);
            }
            return this.headCopy;
        }

        void resetIter() throws IOException {
            if (this.reset) {
                return;
            }
            this.reset = true;
            this.iter = this.docSpans.listIterator();
            this.curr = null;
            this.loadNext(false);
        }

        void clear(int currentDoc) throws IOException {
            while (this.docSpans.size() > 1) {
                BaseComplexExtSpans.this.free(this.docSpans.removeFirst());
            }
            if (this.headCopy != null && currentDoc != this.lastDoc) {
                BaseComplexExtSpans.this.free(this.headCopy);
                this.headCopy = null;
            }
            this.reset = false;
            if (BaseComplexExtSpans.this.spansValid[this.extSpanIndex]) {
                this.resetIter();
            }
        }

        int doc() {
            return this.curr.doc();
        }

        int start() {
            return this.curr.start();
        }

        int end() {
            return this.curr.end();
        }
    }
}

