/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.BaseComplexExtSpans;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AllNearExtSpans
extends BaseComplexExtSpans<ExtSpanAllNearQuery> {
    private LinkedList<ExtSpans> workList;
    private List<NewResult> newResults;
    private PriorityQueue<Result> results;
    private Result resultSpans;
    private int currentResultStart;
    private boolean more;
    private boolean moreInCurrentDoc;
    private WeakHashMap<ExtSpans, ExtSpans> exportedCopies;
    private Queue<BaseComplexExtSpans.Cell> cellQueue;
    private StackQueue<BaseComplexExtSpans.Cell> cells;
    private int[] maxEnds;
    private int numOptional;
    private int currentDoc;
    private int currentSlop;
    private int currentOverlapSlop;
    private BaseComplexExtSpans.Cell lastHandled;

    public AllNearExtSpans(ExtSpanAllNearQuery query, IndexReader reader) throws IOException {
        super(reader, query, query.isDeepCopySubSpans(), query.getCopyHandler());
        ExtSpanQuery[] clauses = query.getClauses();
        assert (clauses.length > 1);
        this.initialize(reader, clauses);
        this.workList = new LinkedList();
        this.newResults = new ArrayList<NewResult>();
        this.results = new PriorityQueue<Result>(10, new Comparator<Result>(){
            ExtSpanQuery[] subSpanSortOrder;
            {
                this.subSpanSortOrder = ((ExtSpanAllNearQuery)AllNearExtSpans.this.query).getSubSpanQuerySortOrder();
            }

            private ExtSpans find(Result r, ExtSpanQuery subQuery) {
                for (int i = 0; i < r.extSpans.length; ++i) {
                    if (r.extSpans[i].query() != subQuery) continue;
                    return r.extSpans[i];
                }
                return null;
            }

            @Override
            public int compare(Result o1, Result o2) {
                int diff = o1.extSpans[0].doc() - o2.extSpans[0].doc();
                if (diff != 0) {
                    return diff;
                }
                diff = o1.extSpans[0].start() - o2.extSpans[0].start();
                if (diff != 0) {
                    return diff;
                }
                diff = o1.end - o2.end;
                if (diff != 0) {
                    return diff;
                }
                if (this.subSpanSortOrder == null) {
                    return 0;
                }
                for (ExtSpanQuery subQuery : this.subSpanSortOrder) {
                    ExtSpans first = this.find(o1, subQuery);
                    ExtSpans second = this.find(o2, subQuery);
                    if (first == null) {
                        if (second == null) continue;
                        return 1;
                    }
                    if (second == null) {
                        return -1;
                    }
                    diff = first.start() - second.start();
                    if (diff != 0) {
                        return diff;
                    }
                    diff = first.end() - second.end();
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }
        });
        if (super.manageLifecycle()) {
            this.exportedCopies = new WeakHashMap();
        }
        this.cells = new StackQueue(this.extSpans.length);
        this.more = true;
        this.numOptional = 0;
        for (int i = 0; i < this.extSpans.length; ++i) {
            boolean optional = query.getOptionals()[i];
            if (this.spansValid[i]) {
                this.cells.add(new BaseComplexExtSpans.Cell(this, i));
            } else {
                this.more &= optional;
            }
            this.numOptional += optional ? 1 : 0;
        }
        this.cellQueue = this.inStrictOrder() ? new StackQueue<BaseComplexExtSpans.Cell>(this.extSpans.length) : new PriorityQueue<BaseComplexExtSpans.Cell>();
        this.maxEnds = new int[this.extSpans.length];
        this.currentSlop = 0;
        this.currentOverlapSlop = 0;
        this.alignDocs(0);
    }

    private boolean inStrictOrder() {
        return ((ExtSpanAllNearQuery)this.query).isInOrder() && this.numOptional == 0;
    }

    private void dumpQueueToCells() {
        while (!this.cellQueue.isEmpty()) {
            this.cells.add(this.cellQueue.poll());
        }
    }

    private void resetQueue(BaseComplexExtSpans.Cell curr) throws IOException {
        int oldSize = this.cells.size();
        this.dumpQueueToCells();
        while (this.cells.size() > oldSize) {
            BaseComplexExtSpans.Cell cell = this.cells.poll();
            cell.resetIter();
            while (cell.compareTo(curr) < 0 && cell.next()) {
            }
            this.cellQueue.add(cell);
        }
    }

    @Override
    protected void free(ExtSpans extSpan) {
        if (this.exportedCopies != null && !this.exportedCopies.containsKey(extSpan)) {
            super.free(extSpan);
        }
    }

    protected void alignDocs(int minDoc) throws IOException {
        BaseComplexExtSpans.Cell cell;
        this.moreInCurrentDoc = false;
        while (!this.cells.isEmpty()) {
            cell = this.cells.poll();
            if (!cell.currentExists()) {
                this.more &= this.isOptional(cell);
                continue;
            }
            this.cellQueue.add(cell);
        }
        while (!this.cellQueue.isEmpty()) {
            cell = this.cellQueue.poll();
            if (cell.updateLastDoc()) {
                this.cells.add(cell);
                continue;
            }
            this.more &= this.isOptional(cell);
        }
        this.more &= !this.cells.isEmpty();
        if (!this.more) {
            return;
        }
        if (this.extSpans.length == this.numOptional) {
            this.currentDoc = Integer.MAX_VALUE;
            while (!this.cells.isEmpty()) {
                cell = this.cells.poll();
                if (minDoc > cell.doc() && !this.extSpans[cell.extSpanIndex()].skipTo(minDoc)) continue;
                this.currentDoc = Math.min(this.currentDoc, cell.doc());
                this.cellQueue.add(cell);
            }
            if (this.cellQueue.isEmpty()) {
                this.more = false;
                return;
            }
            this.dumpQueueToCells();
            while (!this.cells.isEmpty()) {
                cell = this.cells.poll();
                cell.clear(this.currentDoc);
                this.cellQueue.add(cell);
            }
            this.moreInCurrentDoc = true;
            return;
        }
        ExtSpans[] alignSpans = this.extSpans;
        if (this.numOptional != 0) {
            if (this.cells.isEmpty()) {
                this.more = false;
                return;
            }
            alignSpans = new ExtSpans[this.extSpans.length - this.numOptional];
            int i = 0;
            for (BaseComplexExtSpans.Cell cell2 : this.cells) {
                if (this.isOptional(cell2)) continue;
                alignSpans[i++] = this.extSpans[cell2.extSpanIndex()];
            }
        }
        int minOptionalToAlign = Math.min(this.numOptional, ((ExtSpanAllNearQuery)this.query).getMinNumOptionalInResult());
        while (this.more) {
            int numOptionalAligned = 0;
            if (ExtSpanUtils.alignDocs(this.workList, minDoc, alignSpans)) {
                this.currentDoc = alignSpans[0].doc();
                while (!this.cells.isEmpty()) {
                    BaseComplexExtSpans.Cell cell2;
                    cell2 = this.cells.poll();
                    if (this.isOptional(cell2)) {
                        if (cell2.doc() < this.currentDoc && !this.extSpans[cell2.extSpanIndex()].skipTo(this.currentDoc)) continue;
                        if (numOptionalAligned < minOptionalToAlign && cell2.doc() == this.currentDoc) {
                            ++numOptionalAligned;
                        }
                    }
                    cell2.clear(this.currentDoc);
                    this.cellQueue.add(cell2);
                }
                this.moreInCurrentDoc = true;
                if (numOptionalAligned >= minOptionalToAlign) break;
                minDoc = this.currentDoc + 1;
                this.cells.addAll(this.cellQueue);
                this.cellQueue.clear();
                continue;
            }
            this.more = false;
        }
    }

    private boolean isOptional(BaseComplexExtSpans.Cell cell) {
        return ((ExtSpanAllNearQuery)this.query).getOptionals()[cell.extSpanIndex()];
    }

    public boolean next() throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (this.loadResult()) {
            return true;
        }
        while (this.more && !Thread.currentThread().isInterrupted()) {
            this.createSpans();
            if (this.loadResult()) {
                return true;
            }
            this.alignDocs(0);
        }
        return false;
    }

    private boolean load() throws IOException {
        BaseComplexExtSpans.Cell prev = null;
        if (!this.cells.isEmpty()) {
            prev = this.cells.peek();
        }
        this.lastHandled = this.cellQueue.poll();
        if (prev != null) {
            int boundary = this.calcStartBoundary(prev);
            if (this.lastHandled.start() < boundary) {
                this.lastHandled.next();
                this.cellQueue.add(this.lastHandled);
                return false;
            }
            int slop = this.lastHandled.start() - this.lastCellEnd();
            this.currentSlop += Math.max(slop, 0);
            this.currentOverlapSlop += slop;
        }
        this.maxEnds[this.cells.size()] = this.lastHandled.end();
        if (!this.cells.isEmpty()) {
            this.maxEnds[this.cells.size()] = Math.max(this.lastCellEnd(), this.maxEnds[((StackQueue)this.cells).size]);
        }
        this.cells.add(this.lastHandled);
        return true;
    }

    private int calcStartBoundary(BaseComplexExtSpans.Cell prev) {
        return this.calcStartBoundary(prev.start(), prev.end());
    }

    private int calcStartBoundary(int start, int end) {
        int prevLength = end - start;
        return start + Math.max(0, prevLength - ((ExtSpanAllNearQuery)this.query).getMaxOverlapAllowed());
    }

    private void unload() throws IOException {
        if (this.cells.isEmpty()) {
            throw new IllegalStateException();
        }
        this.lastHandled = this.cells.poll();
        if (this.lastHandled == null) {
            throw new IllegalStateException();
        }
        if (this.cells.isEmpty() && this.inStrictOrder()) {
            this.orderedMoveForward();
            this.currentSlop = 0;
            this.currentOverlapSlop = 0;
            return;
        }
        this.resetQueue(this.lastHandled);
        if (this.cells.isEmpty()) {
            this.moveFirstForward();
        } else {
            int slop = this.lastHandled.start() - this.lastCellEnd();
            this.currentSlop -= Math.max(slop, 0);
            this.currentOverlapSlop -= slop;
            this.lastHandled.next();
        }
        this.cellQueue.add(this.lastHandled);
    }

    private int lastCellEnd() {
        return this.maxEnds[this.cells.size() - 1];
    }

    private void orderedMoveForward() throws IOException {
        assert (this.cells.isEmpty() && this.inStrictOrder());
        this.moveFirstForward();
        if (this.more && this.moreInCurrentDoc) {
            this.cells.add(this.lastHandled);
            this.dumpQueueToCells();
            for (int i = 1; this.more && this.moreInCurrentDoc && i < this.cells.size(); ++i) {
                BaseComplexExtSpans.Cell prev = this.cells.get(i - 1);
                BaseComplexExtSpans.Cell cell = this.cells.get(i);
                cell.resetIter();
                int boundary = this.calcStartBoundary(prev);
                while (this.inCurrentDoc(cell) && cell.start() < boundary) {
                    cell.next(true);
                }
                this.updateAfterMove(cell);
            }
            if (this.more && this.moreInCurrentDoc) {
                while (!this.cells.isEmpty()) {
                    this.cellQueue.add(this.cells.poll());
                }
            }
        } else {
            this.cellQueue.add(this.lastHandled);
        }
    }

    private boolean inCurrentDoc(BaseComplexExtSpans.Cell cell) {
        return cell.currentExists() && cell.doc() == this.currentDoc;
    }

    private void moveFirstForward() throws IOException {
        assert (this.cells.isEmpty());
        BaseComplexExtSpans.Cell first = this.lastHandled;
        int start = first.start();
        int end = first.end();
        int boundary = this.calcStartBoundary(start, end);
        BaseComplexExtSpans.Cell nextCell = this.cellQueue.peek();
        if (boundary != start && (nextCell == null || nextCell.doc() > this.currentDoc || nextCell.start() >= boundary)) {
            boundary = start;
        }
        first.next(true);
        while (!Thread.currentThread().isInterrupted() && this.inRange(first, start, end, boundary, nextCell)) {
            if (!this.newResults.isEmpty()) {
                int firstStart = first.start();
                int firstEnd = first.end();
                if (firstStart == start && firstEnd == end) {
                    for (NewResult result : this.newResults) {
                        this.addResultClone(first, result.extSpans);
                    }
                } else {
                    int newBoundary = this.calcStartBoundary(firstStart, firstEnd);
                    for (NewResult result : this.newResults) {
                        if (result.extSpans.length > 1) {
                            if (result.extSpans[1].start() < newBoundary) continue;
                            int slop = result.extSpans[1].start() - firstEnd;
                            int globalSlop = result.adjGlobalSlop + Math.max(0, slop);
                            int overlapSlop = result.adjOverallSlop + slop;
                            if (slop > ((ExtSpanAllNearQuery)this.query).getLocalSlop() || globalSlop > ((ExtSpanAllNearQuery)this.query).getGlobalSlop() || overlapSlop > ((ExtSpanAllNearQuery)this.query).getOverlapGlobalSlop()) continue;
                            this.addResultClone(first, result.extSpans);
                            continue;
                        }
                        this.addResultClone(first, result.extSpans);
                    }
                }
            }
            first.next(true);
        }
        if (!this.newResults.isEmpty()) {
            for (NewResult result : this.newResults) {
                this.results.add(new Result(result.extSpans));
            }
            this.newResults.clear();
        }
        this.updateAfterMove(first);
    }

    private void updateAfterMove(BaseComplexExtSpans.Cell cell) {
        boolean optional = this.isOptional(cell);
        if (!cell.currentExists()) {
            this.more = optional;
            this.moreInCurrentDoc = false;
        } else {
            this.moreInCurrentDoc = cell.doc() == this.currentDoc ? true : optional;
        }
    }

    private void addResultClone(BaseComplexExtSpans.Cell first, ExtSpans[] result) {
        ExtSpans[] newResult = (ExtSpans[])result.clone();
        newResult[0] = first.currentAsCopy();
        this.results.add(new Result(newResult));
    }

    private boolean inRange(BaseComplexExtSpans.Cell first, int start, int end, int boundary, BaseComplexExtSpans.Cell nextCell) {
        if (!this.inCurrentDoc(first)) {
            return false;
        }
        int firstStart = first.start();
        boolean atStart = firstStart == start;
        return !(first.end() > end || !atStart && firstStart < boundary || !atStart && !this.inStrictOrder() && nextCell != null && first.compareTo(nextCell) >= 0);
    }

    private boolean checkSlops() {
        BaseComplexExtSpans.Cell lastCell = this.cellQueue.peek();
        if (!this.inCurrentDoc(lastCell)) {
            return false;
        }
        if (this.cells.isEmpty()) {
            return true;
        }
        int slop = lastCell.start() - this.lastCellEnd();
        return slop <= ((ExtSpanAllNearQuery)this.query).getLocalSlop() && this.currentSlop + slop <= ((ExtSpanAllNearQuery)this.query).getGlobalSlop() && this.checkOverslapSlop(lastCell, slop);
    }

    private boolean checkOverslapSlop(BaseComplexExtSpans.Cell lastCell, int slop) {
        if (((ExtSpanAllNearQuery)this.query).getGlobalSlop() <= ((ExtSpanAllNearQuery)this.query).getOverlapGlobalSlop()) {
            return true;
        }
        if (this.cellQueue.size() > 2) {
            return true;
        }
        int minSlop = slop;
        if (this.cellQueue.size() == 2) {
            minSlop -= lastCell.end() - lastCell.start();
        }
        return this.currentOverlapSlop + minSlop <= ((ExtSpanAllNearQuery)this.query).getOverlapGlobalSlop();
    }

    private void createSpans() throws IOException {
        while (this.more && this.moreInCurrentDoc && !Thread.currentThread().isInterrupted()) {
            if (this.cells.isEmpty() && !this.results.isEmpty() && !this.cellQueue.isEmpty() && this.cellQueue.peek().start() != this.currentResultStart) {
                assert (this.cellQueue.peek().doc() > this.currentDoc || this.cellQueue.peek().start() > this.currentResultStart);
                return;
            }
            boolean unload = false;
            if (this.checkSlops()) {
                if (this.load()) {
                    if (this.cellQueue.isEmpty()) {
                        unload = true;
                    }
                } else {
                    unload = this.canForceUnload();
                }
            } else {
                if (this.cells.isEmpty()) {
                    this.moreInCurrentDoc = false;
                    break;
                }
                unload = true;
            }
            if (!unload) continue;
            boolean firstResult = true;
            do {
                int nonOptionalLeft = this.extSpans.length - this.numOptional;
                boolean resultCreated = false;
                if (this.cells.size() >= nonOptionalLeft + ((ExtSpanAllNearQuery)this.query).getMinNumOptionalInResult() && (firstResult || ((ExtSpanAllNearQuery)this.query).isAllowPartialResults())) {
                    if (nonOptionalLeft == 0) {
                        resultCreated = this.createResult();
                    } else {
                        for (BaseComplexExtSpans.Cell cell : this.cells) {
                            if ((nonOptionalLeft -= this.isOptional(cell) ? 0 : 1) != 0) continue;
                            resultCreated = this.createResult();
                            break;
                        }
                    }
                }
                this.unload();
                if (!resultCreated) continue;
                firstResult = false;
            } while (this.canForceUnload());
        }
    }

    private boolean canForceUnload() {
        return !this.cells.isEmpty() && !this.inCurrentDoc(this.lastHandled);
    }

    private boolean createResult() {
        if (((ExtSpanAllNearQuery)this.query).isInOrder() && !this.inStrictOrder()) {
            int prevCellIndex = -1;
            for (BaseComplexExtSpans.Cell cell : this.cells) {
                if (cell.extSpanIndex() < prevCellIndex) {
                    return false;
                }
                prevCellIndex = cell.extSpanIndex();
            }
        }
        NewResult result = new NewResult();
        result.extSpans = new ExtSpans[this.cells.size()];
        int i = 0;
        for (BaseComplexExtSpans.Cell cell : this.cells) {
            result.extSpans[i] = cell.currentAsCopy();
            ++i;
        }
        if (result.extSpans.length > 1) {
            int firstSlop = result.extSpans[1].start() - result.extSpans[0].end();
            result.adjGlobalSlop = this.currentSlop - Math.max(0, firstSlop);
            result.adjOverallSlop = this.currentOverlapSlop - firstSlop;
        }
        if (this.results.isEmpty() && this.newResults.isEmpty()) {
            this.currentResultStart = result.extSpans[0].start();
        }
        this.newResults.add(result);
        if (this.exportedCopies != null) {
            this.exportedCopies.put(result.extSpans[0], null);
            if (((ExtSpanAllNearQuery)this.query).isInOrder()) {
                for (i = 1; i < result.extSpans.length; ++i) {
                    this.exportedCopies.put(result.extSpans[i], null);
                }
            }
        }
        return true;
    }

    public boolean skipTo(int doc) throws IOException {
        if (doc > this.currentDoc) {
            this.clearResults();
            this.alignDocs(doc);
        }
        return this.next();
    }

    protected void clearResults() {
        assert (this.newResults.isEmpty());
        for (Result result : this.results) {
            for (ExtSpans subSpan : result.extSpans) {
                this.free(subSpan);
            }
        }
        this.results.clear();
        this.resultSpans = null;
    }

    protected boolean loadResult() {
        if (this.results.isEmpty()) {
            return false;
        }
        this.resultSpans = this.results.poll();
        int start = this.resultSpans.extSpans[0].start();
        if (start != this.currentResultStart) {
            this.results.add(this.resultSpans);
            this.currentResultStart = start;
            return false;
        }
        if (this.exportedCopies != null) {
            for (ExtSpans subSpan : this.resultSpans.extSpans) {
                this.exportedCopies.put(subSpan, null);
            }
        }
        return true;
    }

    public int doc() {
        return this.resultSpans.extSpans[0].doc();
    }

    public int start() {
        return this.resultSpans.extSpans[0].start();
    }

    public int end() {
        return this.resultSpans.end;
    }

    @Override
    public int numSubExtSpans() {
        return this.resultSpans.extSpans.length;
    }

    @Override
    public ExtSpans subExtSpan(int index) {
        return this.resultSpans.extSpans[index];
    }

    private static class Result {
        final ExtSpans[] extSpans;
        final int end;

        Result(ExtSpans[] extSpans) {
            this.extSpans = extSpans;
            int maxEnd = extSpans[0].end();
            for (int i = 1; i < extSpans.length; ++i) {
                maxEnd = Math.max(maxEnd, extSpans[i].end());
            }
            this.end = maxEnd;
        }
    }

    private static class NewResult {
        ExtSpans[] extSpans;
        int adjGlobalSlop;
        int adjOverallSlop;

        private NewResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackQueue<E>
    extends AbstractQueue<E> {
        private final E[] elements;
        private int size;

        public StackQueue(int maxCapacity) {
            this.elements = new Object[maxCapacity];
            this.size = 0;
        }

        @Override
        public boolean offer(E o) {
            if (this.size == this.elements.length || o == null) {
                return false;
            }
            this.elements[this.size] = o;
            ++this.size;
            return true;
        }

        @Override
        public E peek() {
            if (this.size == 0) {
                return null;
            }
            return this.elements[this.size - 1];
        }

        @Override
        public E poll() {
            E result = this.peek();
            if (result != null) {
                --this.size;
                this.elements[this.size] = null;
            }
            return result;
        }

        public E get(int i) {
            return this.elements[i];
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index + 1 < StackQueue.this.size;
                }

                @Override
                public E next() {
                    ++this.index;
                    return StackQueue.this.elements[this.index];
                }

                @Override
                public void remove() {
                    if (this.index < 0 || StackQueue.this.size == 0) {
                        throw new IllegalStateException();
                    }
                    for (int i = this.index + 1; i < StackQueue.this.size; ++i) {
                        ((StackQueue)StackQueue.this).elements[i - 1] = StackQueue.this.elements[i];
                    }
                    --this.index;
                    StackQueue.this.size--;
                    ((StackQueue)StackQueue.this).elements[((StackQueue)StackQueue.this).size] = null;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

