/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.BaseComplexExtSpans;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.DefaultExtSpanCopyHandler;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllContainsExtSpans
extends BaseComplexExtSpans<ExtSpanContainsQuery> {
    private LinkedList<ExtSpans> workList;
    private boolean more;
    private boolean incrementIter;
    private BaseComplexExtSpans.Cell outer;
    private BaseComplexExtSpans.Cell inner;
    private BaseComplexExtSpans.Cell iter;
    private BaseComplexExtSpans.Cell resultSpan;
    private int currentDoc;

    public AllContainsExtSpans(ExtSpanContainsQuery query, ExtSpanQuery container, ExtSpanQuery containee, IndexReader reader) throws IOException {
        super(reader, query, true, DefaultExtSpanCopyHandler.instance);
        this.initialize(reader, container, containee);
        this.workList = new LinkedList();
        this.more = this.allValid();
        this.outer = new BaseComplexExtSpans.Cell(this, 0);
        this.inner = new BaseComplexExtSpans.Cell(this, 1);
        if (query.isIncludeContainer()) {
            this.resultSpan = this.outer;
            this.iter = this.inner;
        } else {
            this.resultSpan = this.inner;
            this.iter = this.outer;
        }
        this.currentDoc = -1;
        this.alignDocs(0);
    }

    private boolean alignDocs(int minDoc) throws IOException {
        this.more &= this.allValid();
        if (!this.more) {
            return false;
        }
        this.inner.updateLastDoc();
        this.outer.updateLastDoc();
        if (ExtSpanUtils.alignDocs(this.workList, minDoc, this.extSpans)) {
            this.currentDoc = this.resultSpan.doc();
            this.inner.clear(this.currentDoc);
            this.outer.clear(this.currentDoc);
            this.incrementIter = false;
        } else {
            this.more = false;
        }
        return this.more;
    }

    @Override
    public int numSubExtSpans() {
        return 2;
    }

    @Override
    public ExtSpans subExtSpan(int index) {
        return index == 0 ? this.outer.current() : this.inner.current();
    }

    public int doc() {
        return this.resultSpan.doc();
    }

    public int start() {
        return this.resultSpan.start();
    }

    public int end() {
        return this.resultSpan.end();
    }

    public boolean next() throws IOException {
        if (!this.more) {
            return false;
        }
        if (this.incrementIter) {
            if (!this.iter.next()) {
                if (this.iter.hasResults() && this.resultSpan.next(true)) {
                    if (this.resultSpan.doc() == this.currentDoc) {
                        this.iter.resetIter();
                    } else {
                        this.alignDocs(0);
                    }
                } else {
                    this.more = false;
                }
            }
        } else {
            this.incrementIter = true;
        }
        while (this.more) {
            if (this.findMatch()) {
                return true;
            }
            if (this.iter.hasResults() && this.resultSpan.next(true)) {
                if (this.resultSpan.doc() == this.currentDoc) {
                    this.iter.resetIter();
                    continue;
                }
                this.alignDocs(0);
                continue;
            }
            this.more = false;
        }
        this.inner.clear(-1);
        this.outer.clear(-1);
        return false;
    }

    public boolean skipTo(int doc) throws IOException {
        if (doc > this.currentDoc) {
            this.alignDocs(doc);
        }
        return this.next();
    }

    private boolean findMatch() throws IOException {
        while (this.moveIter() && this.canMatch()) {
            if (this.inner.end() <= this.outer.end()) {
                return true;
            }
            if (this.iter.next()) continue;
            break;
        }
        return false;
    }

    private boolean moveIter() throws IOException {
        if (((ExtSpanContainsQuery)this.query).isIncludeContainer()) {
            while (this.inner.doc() == this.currentDoc && this.inner.start() < this.outer.start()) {
                if (this.inner.next(true)) continue;
                return false;
            }
        } else {
            while (this.outer.doc() == this.currentDoc && this.outer.end() <= this.inner.start()) {
                if (this.outer.next()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canMatch() {
        if (((ExtSpanContainsQuery)this.query).isIncludeContainer()) {
            return this.inner.doc() == this.currentDoc && this.inner.start() < this.outer.end();
        }
        return this.outer.doc() == this.currentDoc && this.outer.start() <= this.inner.start();
    }
}

