/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class AlignedDocExtSpans
extends IterableExtSpans {
    private ExtSpans[] extSpans;
    private LinkedList<ExtSpans> workList;
    private int currDoc;
    private ExtSpanQuery query;

    public AlignedDocExtSpans(ExtSpanQuery query, IndexReader reader, ExtSpanQuery[] clauses) throws IOException {
        super(reader);
        int i;
        this.query = query;
        this.extSpans = new ExtSpans[clauses.length];
        for (i = 0; i < clauses.length; ++i) {
            this.extSpans[i] = clauses[i].getExtSpans(reader);
        }
        this.currDoc = 0;
        for (i = 1; i < this.extSpans.length; ++i) {
            if (!this.extSpans[i].skipTo(this.currDoc)) {
                this.extSpans = null;
                return;
            }
            this.currDoc = Math.max(this.currDoc, this.extSpans[i].doc());
        }
        this.workList = new LinkedList();
        --this.currDoc;
    }

    public ExtSpanQuery query() {
        return this.query;
    }

    public int numSubExtSpans() {
        return this.extSpans.length;
    }

    public ExtSpans subExtSpan(int index) {
        return this.extSpans[index];
    }

    public int doc() {
        return this.currDoc;
    }

    public int end() {
        return Integer.MAX_VALUE;
    }

    public int start() {
        return Integer.MIN_VALUE;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.extSpans == null) {
            return false;
        }
        if (!this.extSpans[0].skipTo(target = Math.max(target, this.currDoc + 1))) {
            this.extSpans = null;
            return false;
        }
        if (!ExtSpanUtils.alignDocs(this.workList, 0, this.extSpans)) {
            this.extSpans = null;
            return false;
        }
        this.currDoc = this.extSpans[0].doc();
        return true;
    }

    public boolean next() throws IOException {
        return this.skipTo(0);
    }
}

