/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended;

import com.ibm.supa.search.spans.extended.AlignedDocExtSpans;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class AlignedDocExtSpanQuery
extends ExtSpanQuery {
    private static final long serialVersionUID = 2678040764977623318L;
    private ExtSpanQuery[] clauses;
    private String field;

    public AlignedDocExtSpanQuery(ExtSpanQuery[] clauses) {
        this.clauses = clauses;
        this.field = ExtSpanUtils.getField(clauses);
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new AlignedDocExtSpans(this, reader, this.clauses);
    }

    public ExtSpanQuery includedClause(int i) {
        return this.clauses[i];
    }

    public int numIncludedClauses() {
        return this.clauses.length;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        if (!recurseToClauses) {
            return this;
        }
        AlignedDocExtSpanQuery other = this;
        for (int i = 0; i < this.clauses.length; ++i) {
            ExtSpanQuery clause = this.clauses[i].optimize(true);
            if (clause == this.clauses[i]) continue;
            if (other == this) {
                other = (AlignedDocExtSpanQuery)((Object)this.clone());
            }
            other.clauses[i] = clause;
        }
        return other;
    }

    public String getField() {
        return this.field;
    }

    @Deprecated
    public Collection getTerms() {
        HashSet result = new HashSet();
        for (ExtSpanQuery clause : this.clauses) {
            clause.extractTerms(result);
        }
        return result;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("alignedDoc([");
        if (this.clauses.length > 0) {
            buffer.append(this.clauses[0].toString(field));
            for (int i = 1; i < this.clauses.length; ++i) {
                buffer.append(", ").append(this.clauses[i].toString(field));
            }
        }
        buffer.append("]");
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlignedDocExtSpanQuery)) {
            return false;
        }
        AlignedDocExtSpanQuery other = (AlignedDocExtSpanQuery)((Object)o);
        HashSet<ExtSpanQuery> clauseSet = new HashSet<ExtSpanQuery>();
        for (ExtSpanQuery clause : this.clauses) {
            clauseSet.add(clause);
        }
        for (ExtSpanQuery clause : other.clauses) {
            if (clauseSet.contains((Object)clause)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode((Object[])this.clauses);
        result ^= result << 14 | result >>> 18;
        return result;
    }
}

