/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.docInfo.DocumentCache;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.SpanResultFetcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanResultUtils {
    private static ExecutorService EXECUTOR = SUPAUtils.newDaemonExecutor();

    public static <E extends SpanResultFetcher> void visit(TreeSet<E> spanFetchers, TokenizedDocument[][] tDocs, VisitHandler<E> handler) throws ExtendedException, IOException, SiapiException {
        SearchWrapper lastWrapper = null;
        int tDocArrayIndex = -1;
        TokenizedDocument tDoc = null;
        int lastDoc = -1;
        int i = 0;
        for (SpanResultFetcher spanFetcher : spanFetchers) {
            SpanResult spanResult = spanFetcher.getSpanResult();
            if (spanResult.getSearchWrapper() != lastWrapper) {
                if (tDocArrayIndex >= 0 && i != tDocs[tDocArrayIndex].length) {
                    throw new RuntimeException();
                }
                lastWrapper = spanResult.getSearchWrapper();
                ++tDocArrayIndex;
                lastDoc = -1;
                i = 0;
            }
            if (spanResult.doc() != lastDoc) {
                tDoc = tDocs[tDocArrayIndex][i];
                handler.handleNewDoc(tDoc);
                lastDoc = spanResult.doc();
                ++i;
            }
            handler.handle(spanFetcher, tDoc);
        }
        if (i != tDocs[tDocArrayIndex].length) {
            throw new RuntimeException();
        }
    }

    public static Map<SpanResult, String> loadTexts(List<SpanResult> spanResultsList, String field) throws ExtendedException, IOException, SiapiException {
        TreeSet<SpanResult> spanFetchers = SpanResultUtils.toTreeSet(spanResultsList);
        CollectionDocs[] cDocs = SpanResultUtils.getCollectionDocs(spanFetchers);
        TokenizedDocument[][] tDocs = SpanResultUtils.loadTokenizedDocs(cDocs);
        return SpanResultUtils.loadTexts(spanFetchers, tDocs, field);
    }

    public static <E extends SpanResultFetcher> Map<SpanResult, String> loadTexts(TreeSet<E> spanFetchers, TokenizedDocument[][] tDocs, final String field) throws ExtendedException, IOException, SiapiException {
        final IdentityHashMap<SpanResult, String> result = new IdentityHashMap<SpanResult, String>();
        SpanResultUtils.visit(spanFetchers, tDocs, new VisitHandler<E>(){
            TokenVector lastVec = null;
            TokenVectorIterator iter = null;
            StringBuilder sBuf = new StringBuilder();

            @Override
            public void handleNewDoc(TokenizedDocument tDoc) {
                this.lastVec = tDoc.getField(field);
                this.iter = null;
            }

            @Override
            public void handle(E spanResultFetcher, TokenizedDocument tDoc) {
                SpanResult spanResult = spanResultFetcher.getSpanResult();
                if (this.iter == null || spanResult.start() < this.iter.getPosition()) {
                    this.iter = this.lastVec.iterator(TokenVectorIterator.Mode.SUMMARY);
                }
                SpanResultUtils.appendSpanText(spanResult.start(), spanResult.end(), this.iter, this.sBuf);
                result.put(spanResult, this.sBuf.toString());
                this.sBuf.delete(0, this.sBuf.length());
            }
        });
        return result;
    }

    public static <E extends SpanResultFetcher> TreeSet<E> toTreeSet(E ... spanResultFetchers) {
        SpanResult.WrapperPosComparator wrapperPosComparator = new SpanResult.WrapperPosComparator();
        TreeSet<SpanResultFetcher> result = new TreeSet<SpanResultFetcher>(wrapperPosComparator);
        for (E fetcher : spanResultFetchers) {
            wrapperPosComparator.register((SpanResultFetcher)fetcher);
            result.add((SpanResultFetcher)fetcher);
        }
        return result;
    }

    public static <E extends SpanResultFetcher> TreeSet<E> toTreeSet(Collection<E> spanResultFetchers) {
        SpanResult.WrapperPosComparator wrapperPosComparator = new SpanResult.WrapperPosComparator();
        TreeSet<SpanResultFetcher> result = new TreeSet<SpanResultFetcher>(wrapperPosComparator);
        wrapperPosComparator.registerAll(spanResultFetchers);
        result.addAll(spanResultFetchers);
        return result;
    }

    public static TokenizedDocument[][] loadTokenizedDocs(CollectionDocs[] cDocs) throws ExtendedException, IOException, SiapiException {
        final DocumentCache docCache = ConfigurationLoader.getGlobalConfig().getDocumentCache();
        FutureTask[] tasks = new FutureTask[cDocs.length];
        for (int i = 0; i < cDocs.length; ++i) {
            final CollectionDocs cDoc = cDocs[i];
            tasks[i] = new FutureTask<TokenizedDocument[]>(new Callable<TokenizedDocument[]>(){

                @Override
                public TokenizedDocument[] call() throws Exception {
                    return docCache.load(cDoc.searchWrapper, cDoc.docIds);
                }
            });
            EXECUTOR.submit(tasks[i]);
        }
        return SUPAUtils.completeTasks(tasks, TokenizedDocument[].class);
    }

    /*
     * WARNING - void declaration
     */
    public static CollectionDocs[] getCollectionDocs(TreeSet<? extends SpanResultFetcher> spanFetchers) {
        LinkedHashMap docIdMap = new LinkedHashMap();
        SearchWrapper lastWrapper = null;
        List docIdList = null;
        for (SpanResultFetcher spanResultFetcher : spanFetchers) {
            SpanResult spanResult = spanResultFetcher.getSpanResult();
            if (!spanResult.getSearchWrapper().equals(lastWrapper) && (docIdList = (List)docIdMap.get(lastWrapper = spanResult.getSearchWrapper())) == null) {
                docIdList = new ArrayList<Integer>();
                docIdMap.put(lastWrapper, docIdList);
            }
            if (!docIdList.isEmpty() && spanResult.doc() == ((Integer)docIdList.get(docIdList.size() - 1)).intValue()) continue;
            docIdList.add(spanResult.doc());
        }
        CollectionDocs[] result = new CollectionDocs[docIdMap.size()];
        boolean bl = false;
        for (Map.Entry entry : docIdMap.entrySet()) {
            void var5_7;
            CollectionDocs cDocs = new CollectionDocs((SearchWrapper)entry.getKey());
            docIdList = (List)entry.getValue();
            cDocs.docIds = new int[docIdList.size()];
            int j = 0;
            Iterator i$ = docIdList.iterator();
            while (i$.hasNext()) {
                int docId;
                cDocs.docIds[j] = docId = ((Integer)i$.next()).intValue();
                ++j;
            }
            result[var5_7] = cDocs;
            ++var5_7;
        }
        return result;
    }

    public static void appendSpanText(int start, int end, TokenVectorIterator iter, StringBuilder sBuf) {
        iter.skip(start - iter.getPosition());
        do {
            if (iter.getPosition() <= start) continue;
            sBuf.append(iter);
            if (iter.getPosition() >= end) break;
        } while (iter.next());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface VisitHandler<E extends SpanResultFetcher> {
        public void handleNewDoc(TokenizedDocument var1) throws ExtendedException, IOException, SiapiException;

        public void handle(E var1, TokenizedDocument var2) throws ExtendedException, IOException, SiapiException;
    }

    public static class CollectionDocs {
        public final SearchWrapper searchWrapper;
        public int[] docIds;

        public CollectionDocs(SearchWrapper searchWrapper) {
            this.searchWrapper = searchWrapper;
        }
    }
}

