/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans;

import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.spans.SpanResultFetcher;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanResult
implements SpanResultFetcher,
Comparable<SpanResult> {
    private static final Comparator<SpanResultFetcher> BASE_POS_COMPARATOR = new Comparator<SpanResultFetcher>(){

        @Override
        public int compare(SpanResultFetcher o1, SpanResultFetcher o2) {
            SpanResult s1 = o1.getSpanResult();
            SpanResult s2 = o2.getSpanResult();
            int result = s1.doc - s2.doc;
            if (result != 0) {
                return result;
            }
            result = s1.start - s2.start;
            if (result != 0) {
                return result;
            }
            return s1.end - s2.end;
        }
    };
    public static final Comparator<SpanResultFetcher> POSITION_COMPARATOR = new Comparator<SpanResultFetcher>(){

        @Override
        public int compare(SpanResultFetcher o1, SpanResultFetcher o2) {
            SpanResult s1 = o1.getSpanResult();
            SpanResult s2 = o2.getSpanResult();
            int result = s1.getCollectionId().compareTo(s2.getCollectionId());
            if (result == 0) {
                result = BASE_POS_COMPARATOR.compare(s1, s2);
            }
            return result;
        }
    };
    private final SearchWrapper wrapper;
    private final int start;
    private final int end;
    private final int doc;
    private Type type;
    private ExtSpans extSpans;
    private int numSamePosExtSpans;
    private List<ExtSpans> sameDocExtSpans;
    private PenaltyScore penaltyScore;

    public SpanResult(SearchWrapper wrapper, int start, int end, int doc) {
        this.wrapper = wrapper;
        this.start = start;
        this.end = end;
        this.doc = doc;
    }

    @Override
    public SpanResult getSpanResult() {
        return this;
    }

    public SearchWrapper getSearchWrapper() {
        return this.wrapper;
    }

    public String getCollectionId() {
        return this.wrapper.getCollectionId();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int doc() {
        return this.doc;
    }

    public double penalty() {
        if (this.penaltyScore == null) {
            return Double.NaN;
        }
        return this.penaltyScore.getPenalty();
    }

    public PenaltyScore getPenaltyScore() {
        return this.penaltyScore;
    }

    public void setPenaltyScore(PenaltyScore penaltyScore) {
        this.penaltyScore = penaltyScore;
    }

    public ExtSpans getExtSpans() {
        return this.extSpans;
    }

    public void setExtSpans(ExtSpans extSpans) {
        if (this.extSpans != null) {
            this.incrementNumSamePosExtSpans();
        }
        this.extSpans = extSpans.nonIterableCopy(true);
    }

    public void incrementNumSamePosExtSpans() {
        ++this.numSamePosExtSpans;
    }

    public boolean isAtSameLocation(Spans spans) {
        return spans.doc() == this.doc && spans.start() == this.start && spans.end() == this.end;
    }

    public boolean overlaps(Spans spans) {
        return spans.doc() == this.doc && spans.start() < this.end && spans.end() > this.start;
    }

    public List<ExtSpans> getSameDocExtSpans() {
        return this.sameDocExtSpans;
    }

    public void setSameDocExtSpans(List<ExtSpans> sameDocExtSpans) {
        this.sameDocExtSpans = sameDocExtSpans;
    }

    public void setPenalty(double penalty) {
        this.penaltyScore.setPenalty(penalty);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public int compareTo(SpanResult o) {
        int result = 0;
        if (this.penaltyScore == null) {
            if (o.penaltyScore != null) {
                return 1;
            }
        } else {
            if (o.penaltyScore == null) {
                return -1;
            }
            result = Double.compare(this.penalty(), o.penalty());
        }
        if (result != 0) {
            return result;
        }
        int oNumAtPos = 1 + o.numSamePosExtSpans;
        int numAtPos = 1 + this.numSamePosExtSpans;
        result = oNumAtPos * (this.end - this.start) - numAtPos * (o.end - o.start);
        if (result != 0) {
            return result;
        }
        result = numAtPos - oNumAtPos;
        if (result != 0) {
            return result;
        }
        return POSITION_COMPARATOR.compare(this, o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WrapperPosComparator
    implements Comparator<SpanResultFetcher> {
        private Map<SearchWrapper, Integer> wrappersSeen = new HashMap<SearchWrapper, Integer>();

        public void registerWrapper(SearchWrapper wrapper) {
            if (this.wrappersSeen.get(wrapper) == null) {
                this.wrappersSeen.put(wrapper, this.wrappersSeen.size());
            }
        }

        public void register(SpanResultFetcher fetcher) {
            this.registerWrapper(fetcher.getSpanResult().wrapper);
        }

        public void registerAll(Iterable<? extends SpanResultFetcher> resultFetchers) {
            for (SpanResultFetcher spanResultFetcher : resultFetchers) {
                this.register(spanResultFetcher);
            }
        }

        @Override
        public int compare(SpanResultFetcher o1, SpanResultFetcher o2) {
            SpanResult s1 = o1.getSpanResult();
            SpanResult s2 = o2.getSpanResult();
            int result = this.wrappersSeen.get(s1.wrapper) - this.wrappersSeen.get(s2.wrapper);
            if (result == 0) {
                result = BASE_POS_COMPARATOR.compare(s1, s2);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        COMPLETE_DOC,
        PARTIAL_DOC;

    }
}

