/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.resultsProcessors;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.SpanResultFetcher;
import com.ibm.supa.search.spans.SpanResultUtils;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import com.ibm.supa.search.spans.extended.tags.TagExtSpans;
import com.ibm.supa.search.summarizer.highlighter.ExtendedSummaryFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeSet;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummarizingResultsProcessor
implements ResultsProcessor {
    private static final String CONNECTION_WORD = " ... ";
    private static final int CONNECTION_WORD_LENGTH = " ... ".length();
    private static final int MAX_WORDS_BEFORE_RESULTS = 20;
    private static final int NO_WORDS_REPLACED_BY_CONNECTION_WORD = 10;
    private static final int NO_WORDS_REPLACED_AFTER_RESULT = 5;
    private final ExtendedSummaryFormatter formatter;

    public SummarizingResultsProcessor(ExtendedSummaryFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void process(SpanResultImpl[] resultImpls, SupaQuery query, Map<ExtSpanQuery, List<QueryFragment>> fragmentLookup) throws SiapiException {
        try {
            TreeSet orderedImpls = SpanResultUtils.toTreeSet((SpanResultFetcher[])resultImpls);
            TokenizedDocument[][] tDocs = SpanResultImpl.toTokenizedDocuments(orderedImpls);
            SpanResultUtils.visit(orderedImpls, tDocs, new ResultImplHandler(query, fragmentLookup));
        }
        catch (Exception e) {
            if (e instanceof SiapiException) {
                throw (SiapiException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultImplHandler
    implements SpanResultUtils.VisitHandler<SpanResultImpl> {
        SupaQuery query;
        Map<List<QueryFragment>, Integer> fragmentNums;
        Map<ExtSpanQuery, List<QueryFragment>> fragmentLookup;
        PriorityQueue<ExtSpans> leafSpans;
        PriorityQueue<ExtSpans> sameDocExtSpans;
        TVIter tvi;
        StringBuilder sBuf;
        ArrayList<String> lines;
        Vint8.Position pos = new Vint8.Position();
        TokensInSbuf tokensInsBuf;

        public ResultImplHandler(SupaQuery query, Map<ExtSpanQuery, List<QueryFragment>> fragmentLookup) {
            this.query = query;
            if (fragmentLookup == null) {
                fragmentLookup = Collections.emptyMap();
            }
            this.fragmentNums = new IdentityHashMap<List<QueryFragment>, Integer>();
            for (List<QueryFragment> fragments : fragmentLookup.values()) {
                this.fragmentNums.put(fragments, this.fragmentNums.size() + 1);
            }
            this.fragmentLookup = fragmentLookup;
            this.leafSpans = new PriorityQueue<Spans>(10, ExtSpanUtils.POSITION_COMPARATOR);
            this.sameDocExtSpans = new PriorityQueue<Spans>(10, ExtSpanUtils.POSITION_COMPARATOR);
            this.tvi = new TVIter();
            this.sBuf = new StringBuilder();
            this.tokensInsBuf = new TokensInSbuf();
        }

        private boolean resetIfNeeded(SpanResult result, boolean lineDeleted, int bufStart) {
            if (!lineDeleted && this.tvi.lineNum > 2) {
                this.tvi.reset();
                this.sBuf.delete(bufStart, this.sBuf.length());
                this.tokensInsBuf.reset();
                this.extractSameDocExtSpans(result);
                return true;
            }
            return false;
        }

        private void extractSameDocExtSpans(SpanResult result) {
            if (result.getSameDocExtSpans() != null) {
                this.sameDocExtSpans.clear();
                for (ExtSpans extSpans : result.getSameDocExtSpans()) {
                    this.extractContainedLeaves(this.sameDocExtSpans, extSpans, false, result, false, true);
                }
                if (this.sameDocExtSpans.isEmpty()) {
                    for (ExtSpans extSpans : result.getSameDocExtSpans()) {
                        this.extractContainedLeaves(this.sameDocExtSpans, extSpans, false, result, true, true);
                    }
                }
            }
        }

        private ExtSpans getFirst(ExtSpans leaf, ExtSpans sameDocLeaf) {
            if (sameDocLeaf == null) {
                return leaf;
            }
            if (leaf == null) {
                return sameDocLeaf;
            }
            return ExtSpanUtils.POSITION_COMPARATOR.compare(leaf, sameDocLeaf) <= 0 ? leaf : sameDocLeaf;
        }

        private void extractContainedLeaves(PriorityQueue<ExtSpans> resultSpans, ExtSpans root, boolean subSpansNotRecursivelyContainedOk, SpanResult containingResult, boolean tagSpansOk, boolean notContainedInSpanResultOk) {
            if (root.numSubExtSpans() == 0) {
                if ((tagSpansOk || !(root instanceof TagExtSpans)) && (notContainedInSpanResultOk || containingResult.start() <= root.start() && root.end() <= containingResult.end())) {
                    resultSpans.add(root);
                }
                return;
            }
            for (int i = 0; i < root.numSubExtSpans(); ++i) {
                ExtSpans subSpan = root.subExtSpan(i);
                if (!subSpansNotRecursivelyContainedOk && (root.start() > subSpan.start() || subSpan.end() > root.end())) continue;
                this.extractContainedLeaves(resultSpans, subSpan, subSpansNotRecursivelyContainedOk, containingResult, tagSpansOk, notContainedInSpanResultOk);
            }
        }

        @Override
        public void handleNewDoc(TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
            this.tvi.vector = tDoc.getField("_plain");
            this.tvi.iter = null;
            this.tvi.endPos = SUPAUtils.getEndPlainTextPos(tDoc.getDocument(), this.pos);
            this.sameDocExtSpans.clear();
        }

        @Override
        public void handle(SpanResultImpl resultImpl, TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
            boolean isCode;
            if (resultImpl.getTokenizedDocument() != null && resultImpl.getTokenizedDocument() != tDoc) {
                assert (false);
                this.handleNewDoc(resultImpl.getTokenizedDocument());
            }
            if (isCode = SUPAUtils.isStructured(tDoc.getDocument())) {
                SummarizingResultsProcessor.this.formatter.appendPreStylePrefix(this.sBuf);
                this.handleCode(resultImpl, tDoc);
            } else {
                this.handleDocument(resultImpl, tDoc);
            }
        }

        private void handleDocument(SpanResultImpl resultImpl, TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
            SpanResult spanResult = resultImpl.getSpanResult();
            boolean sentenceFound = false;
            int tokenType = 1;
            this.tokensInsBuf.reset();
            if (this.tvi.iter == null || spanResult.start() < this.tvi.iter.getPosition() || this.tvi.lineNum == 1) {
                this.tvi.reset();
                this.sameDocExtSpans.clear();
            }
            this.sBuf.delete(0, this.sBuf.length());
            this.tvi.textLengthCoveredBySpan = 0;
            int bufStart = this.sBuf.length();
            this.leafSpans.clear();
            this.extractSpans(spanResult);
            ExtSpans leaf = this.leafSpans.poll();
            ExtSpans sameDocLeaf = this.sameDocExtSpans.poll();
            ExtSpans curr = this.getFirst(leaf, sameDocLeaf);
            boolean currIsPrimary = curr == leaf;
            int currStart = curr != null ? curr.start() : spanResult.start();
            int currEnd = curr != null ? curr.end() : spanResult.end();
            int firstLeafStart = leaf != null ? leaf.start() : spanResult.start();
            int lastLeafEnd = spanResult.end();
            int fragNum = -1;
            boolean spanOpened = false;
            boolean open = false;
            boolean lineDeleted = false;
            while (this.tvi.next()) {
                int position = this.tvi.iter.getPosition();
                if (this.tvi.iter.getType() == TToken.Type.SENTENCE) {
                    if (position <= firstLeafStart) {
                        lineDeleted = true;
                        this.sBuf.delete(bufStart, this.sBuf.length());
                        this.tokensInsBuf.reset();
                        sentenceFound = true;
                        continue;
                    }
                    if (position < lastLeafEnd || this.resetIfNeeded(spanResult, lineDeleted, bufStart)) continue;
                    break;
                }
                if (!open && position > currStart) {
                    Integer fragNumInteger;
                    if (this.resetIfNeeded(spanResult, lineDeleted, bufStart)) continue;
                    open = true;
                    if (!spanOpened && position > firstLeafStart) {
                        resultImpl.setStartLine(this.tvi.lineNum);
                        spanOpened = true;
                    }
                    fragNum = curr != null ? ((fragNumInteger = this.fragmentNums.get(this.fragmentLookup.get((Object)curr.query()))) == null ? 0 : fragNumInteger) : 0;
                    if (currIsPrimary) {
                        SummarizingResultsProcessor.this.formatter.appendHighlightGroupPrefix(this.sBuf);
                        SummarizingResultsProcessor.this.formatter.appendHighlightPrefix(this.sBuf, fragNum);
                        this.tokensInsBuf.reset();
                    } else {
                        SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightGroupPrefix(this.sBuf);
                        SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightPrefix(this.sBuf, fragNum);
                        this.tokensInsBuf.reset();
                    }
                }
                tokenType = this.tvi.iter.getType() == TToken.Type.BOTH || this.tvi.iter.getType() == TToken.Type.ORIGINAL ? 0 : 1;
                this.tokensInsBuf.insert(this.sBuf.length(), this.tvi.iter.length(), tokenType);
                SummarizingResultsProcessor.this.formatter.appendText(this.sBuf, this.tvi.iter);
                if (firstLeafStart < position && (position < lastLeafEnd || position == lastLeafEnd && open)) {
                    this.tvi.textLengthCoveredBySpan += this.tvi.iter.length();
                } else if (sentenceFound && this.tokensInsBuf.numberOfWordTokens() > 20) {
                    this.tokensInsBuf.deleteTokens(10, this.sBuf);
                }
                if (!open || position < currEnd) continue;
                open = false;
                if (currIsPrimary) {
                    SummarizingResultsProcessor.this.formatter.appendHighlightPostfix(this.sBuf, fragNum);
                    SummarizingResultsProcessor.this.formatter.appendHighlightGroupPostfix(this.sBuf);
                    this.tokensInsBuf.reset();
                } else {
                    SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightPostfix(this.sBuf, fragNum);
                    SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightGroupPostfix(this.sBuf);
                    this.tokensInsBuf.reset();
                }
                int lastEnd = lastLeafEnd;
                while (leaf != null && position >= leaf.end()) {
                    lastEnd = leaf.end();
                    leaf = this.leafSpans.poll();
                }
                if (leaf == null) {
                    lastLeafEnd = lastEnd;
                    resultImpl.setEndLine(this.tvi.lineNum);
                }
                while (sameDocLeaf != null && position >= sameDocLeaf.end()) {
                    sameDocLeaf = this.sameDocExtSpans.poll();
                }
                if (curr != null) {
                    curr = this.getFirst(leaf, sameDocLeaf);
                    currIsPrimary = curr == leaf;
                }
                currStart = curr != null ? curr.start() : Integer.MAX_VALUE;
                currEnd = curr != null ? curr.end() : Integer.MAX_VALUE;
            }
            resultImpl.setDescription(this.sBuf.toString());
            resultImpl.setTextLengthCoveredBySpan(this.tvi.textLengthCoveredBySpan);
            this.sBuf.delete(0, this.sBuf.length());
        }

        private void extractSpans(SpanResult spanResult) {
            boolean tagSpansOk = Boolean.parseBoolean(this.query.getProperty("displayTagSpans"));
            this.extractContainedLeaves(this.leafSpans, spanResult.getExtSpans(), true, spanResult, tagSpansOk, false);
            if (!tagSpansOk && this.leafSpans.isEmpty()) {
                this.extractContainedLeaves(this.leafSpans, spanResult.getExtSpans(), true, spanResult, true, false);
            }
            if (this.sameDocExtSpans.isEmpty()) {
                this.extractSameDocExtSpans(spanResult);
            }
        }

        private void handleCode(SpanResultImpl resultImpl, TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
            SpanResult spanResult = resultImpl.getSpanResult();
            if (this.tvi.iter == null || spanResult.start() < this.tvi.iter.getPosition() || this.tvi.lineNum == 1) {
                this.tvi.reset();
                this.sameDocExtSpans.clear();
            }
            this.sBuf.delete(0, this.sBuf.length());
            this.tvi.textLengthCoveredBySpan = 0;
            SummarizingResultsProcessor.this.formatter.appendPreStylePrefix(this.sBuf);
            int bufStart = this.sBuf.length();
            SummarizingResultsProcessor.this.formatter.appendLineStart(this.sBuf, this.tvi.lineNum);
            this.leafSpans.clear();
            this.extractSpans(spanResult);
            ExtSpans leaf = this.leafSpans.poll();
            ExtSpans sameDocLeaf = this.sameDocExtSpans.poll();
            ExtSpans curr = this.getFirst(leaf, sameDocLeaf);
            boolean currIsPrimary = curr == leaf;
            int currStart = curr != null ? curr.start() : spanResult.start();
            int currEnd = curr != null ? curr.end() : spanResult.end();
            int firstLeafStart = leaf != null ? leaf.start() : spanResult.start();
            int lastLeafEnd = spanResult.end();
            int fragNum = -1;
            boolean spanOpened = false;
            boolean open = false;
            boolean lineDeleted = false;
            while (this.tvi.next()) {
                int position = this.tvi.iter.getPosition();
                if (this.tvi.iter.getType() == TToken.Type.SENTENCE) {
                    if (position <= firstLeafStart) {
                        lineDeleted = true;
                        this.sBuf.delete(bufStart, this.sBuf.length());
                    } else {
                        SummarizingResultsProcessor.this.formatter.appendLineEnd(this.sBuf, this.tvi.lineNum - 1);
                        if (position >= lastLeafEnd && !this.resetIfNeeded(spanResult, lineDeleted, bufStart)) break;
                    }
                    SummarizingResultsProcessor.this.formatter.appendLineStart(this.sBuf, this.tvi.lineNum);
                    continue;
                }
                if (!open && position > currStart) {
                    Integer fragNumInteger;
                    if (this.resetIfNeeded(spanResult, lineDeleted, bufStart)) {
                        SummarizingResultsProcessor.this.formatter.appendLineStart(this.sBuf, this.tvi.lineNum);
                        continue;
                    }
                    open = true;
                    if (!spanOpened && position > firstLeafStart) {
                        resultImpl.setStartLine(this.tvi.lineNum);
                        spanOpened = true;
                    }
                    fragNum = curr != null ? ((fragNumInteger = this.fragmentNums.get(this.fragmentLookup.get((Object)curr.query()))) == null ? 0 : fragNumInteger) : 0;
                    if (currIsPrimary) {
                        SummarizingResultsProcessor.this.formatter.appendHighlightGroupPrefix(this.sBuf);
                        SummarizingResultsProcessor.this.formatter.appendHighlightPrefix(this.sBuf, fragNum);
                    } else {
                        SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightGroupPrefix(this.sBuf);
                        SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightPrefix(this.sBuf, fragNum);
                    }
                }
                SummarizingResultsProcessor.this.formatter.appendText(this.sBuf, this.tvi.iter);
                if (firstLeafStart < position && (position < lastLeafEnd || position == lastLeafEnd && open)) {
                    this.tvi.textLengthCoveredBySpan += this.tvi.iter.length();
                }
                if (!open || position < currEnd) continue;
                open = false;
                if (currIsPrimary) {
                    SummarizingResultsProcessor.this.formatter.appendHighlightPostfix(this.sBuf, fragNum);
                    SummarizingResultsProcessor.this.formatter.appendHighlightGroupPostfix(this.sBuf);
                } else {
                    SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightPostfix(this.sBuf, fragNum);
                    SummarizingResultsProcessor.this.formatter.appendSecondaryHighlightGroupPostfix(this.sBuf);
                }
                int lastEnd = lastLeafEnd;
                while (leaf != null && position >= leaf.end()) {
                    lastEnd = leaf.end();
                    leaf = this.leafSpans.poll();
                }
                if (leaf == null) {
                    lastLeafEnd = lastEnd;
                    resultImpl.setEndLine(this.tvi.lineNum);
                }
                while (sameDocLeaf != null && position >= sameDocLeaf.end()) {
                    sameDocLeaf = this.sameDocExtSpans.poll();
                }
                if (curr != null) {
                    curr = this.getFirst(leaf, sameDocLeaf);
                    currIsPrimary = curr == leaf;
                }
                currStart = curr != null ? curr.start() : Integer.MAX_VALUE;
                currEnd = curr != null ? curr.end() : Integer.MAX_VALUE;
            }
            SummarizingResultsProcessor.this.formatter.appendPreStylePostfix(this.sBuf);
            resultImpl.setDescription(this.sBuf.toString());
            resultImpl.setTextLengthCoveredBySpan(this.tvi.textLengthCoveredBySpan);
            this.sBuf.delete(0, this.sBuf.length());
        }
    }

    private static class TokensInSbuf {
        List<TokenInSbuf> tokensInsBuf = new LinkedList<TokenInSbuf>();
        boolean externalReset = false;

        private TokensInSbuf() {
        }

        void reset() {
            this.tokensInsBuf.clear();
            this.externalReset = true;
        }

        void insert(int index, int length, int type) {
            TokenInSbuf token = new TokenInSbuf();
            token.set(index, length, type);
            this.tokensInsBuf.add(token);
            if (this.externalReset && this.numberOfWordTokens() == 5) {
                this.tokensInsBuf.clear();
                this.externalReset = false;
            }
        }

        int numberOfWordTokens() {
            Iterator<TokenInSbuf> iter = this.tokensInsBuf.iterator();
            int nWords = 0;
            while (iter.hasNext()) {
                TokenInSbuf token = iter.next();
                if (token.tokenType != 0) continue;
                ++nWords;
            }
            return nWords;
        }

        void printContent() {
            for (TokenInSbuf token : this.tokensInsBuf) {
                System.out.println(" Index = " + token.sBufCHIndex + " Length = " + token.tokenLength + " Type = " + token.tokenType);
            }
        }

        void deleteTokens(int numTokens, StringBuilder sBuf) {
            TokenInSbuf token;
            ListIterator<TokenInSbuf> iter = this.tokensInsBuf.listIterator();
            int accumulatedLength = 0;
            int index = 0;
            int nTokens = 0;
            nTokens = numTokens;
            while (iter.hasNext() && nTokens > 0) {
                token = iter.next();
                index = token.sBufCHIndex - accumulatedLength;
                if (token.tokenLength != 0) {
                    sBuf.delete(index, index + token.tokenLength);
                    accumulatedLength += token.tokenLength;
                }
                if (token.tokenType == 0) {
                    --nTokens;
                }
                iter.remove();
            }
            token = new TokenInSbuf();
            token.set(index + accumulatedLength - CONNECTION_WORD_LENGTH, CONNECTION_WORD_LENGTH, 0);
            sBuf.insert(index, SummarizingResultsProcessor.CONNECTION_WORD);
            this.tokensInsBuf.add(0, token);
            iter = this.tokensInsBuf.listIterator();
            while (iter.hasNext()) {
                token = iter.next();
                token.sBufCHIndex += CONNECTION_WORD_LENGTH;
                token.sBufCHIndex -= accumulatedLength;
            }
        }
    }

    private static class TokenInSbuf {
        static final int TOKEN_WORD = 0;
        static final int TOKEN_OTHER = 1;
        int sBufCHIndex;
        int tokenLength;
        int tokenType;

        private TokenInSbuf() {
        }

        void set(int sBufCHIndexParm, int tokenLegthParm, int tokenTypeParm) {
            this.sBufCHIndex = sBufCHIndexParm;
            this.tokenLength = tokenLegthParm;
            this.tokenType = tokenTypeParm;
        }
    }

    private static class TVIter {
        TokenVector vector;
        TokenVectorIterator iter;
        int endPos;
        int lineNum;
        int textLengthCoveredBySpan;

        private TVIter() {
        }

        void reset() {
            this.iter = this.vector.iterator(TokenVectorIterator.Mode.SUMMARY);
            this.lineNum = 1;
            this.textLengthCoveredBySpan = 0;
        }

        boolean next() {
            boolean result;
            boolean bl = result = this.iter.next() && this.iter.getPosition() < this.endPos;
            if (result && this.iter.getType() == TToken.Type.SENTENCE) {
                ++this.lineNum;
            }
            return result;
        }
    }
}

