/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.resultsProcessors;

import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTieBreakProcessor
implements ResultsProcessor {
    private static final double DEFAULT_ETA = 1.0E-6;
    private double eta;
    private boolean tieBreakByDescLength;
    private Comparator<SpanResultImpl> comparator;

    public SimpleTieBreakProcessor(boolean tieBreakByDescLength) {
        this(tieBreakByDescLength, 1.0E-6);
    }

    public SimpleTieBreakProcessor(boolean tieBreakByDescLength, double eta) {
        this.eta = eta;
        this.tieBreakByDescLength = tieBreakByDescLength;
        this.comparator = this.createComparator();
    }

    private Comparator<SpanResultImpl> createComparator() {
        return new Comparator<SpanResultImpl>(){

            @Override
            public int compare(SpanResultImpl o1, SpanResultImpl o2) {
                double diff = o1.getScore() - o2.getScore();
                if (diff > SimpleTieBreakProcessor.this.eta) {
                    return -1;
                }
                if (diff < -SimpleTieBreakProcessor.this.eta) {
                    return 1;
                }
                return o1.getTextLengthCoveredBySpan() - o2.getTextLengthCoveredBySpan();
            }
        };
    }

    @Override
    public void process(SpanResultImpl[] resultImpls, SupaQuery query, Map<ExtSpanQuery, List<QueryFragment>> fragmentLookup) throws SiapiException {
        if (!this.tieBreakByDescLength) {
            return;
        }
        Arrays.sort(resultImpls, this.comparator);
    }
}

