/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.TextQueryExecutor;

public class WrappedTextQueryExecutor
extends TextQueryExecutor {
    private static final String SPAN_PATTERN = "\\$spanQuery";
    private static final String DOC_PATTERN = "\\$docQuery";
    private String spanQueryModel = "$spanQuery";
    private String docQueryModel = "$docQuery";
    private Integer maxLocalSlop = 20;

    public void setSpanQueryModel(String spanQueryModel) {
        this.spanQueryModel = spanQueryModel;
    }

    public void setDocQueryModel(String docQueryModel) {
        this.docQueryModel = docQueryModel;
    }

    public void setMaxLocalSlop(Integer maxLocalSlop) {
        this.maxLocalSlop = maxLocalSlop;
    }

    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        String inputSpanQuery = null;
        String inputDocQuery = null;
        TextQueryExecutor.TextQuery result = (TextQueryExecutor.TextQuery)this.subCreateQuery(collectionIds);
        int index = queryString.indexOf(DIVIDER);
        if (index < 0) {
            inputSpanQuery = queryString;
            inputDocQuery = "";
        } else {
            inputSpanQuery = queryString.substring(0, index);
            inputDocQuery = queryString.substring(index + DIVIDER.length());
        }
        String spanQuery = this.resolveQuery(this.spanQueryModel, inputSpanQuery, inputDocQuery);
        String docQuery = this.resolveQuery(this.docQueryModel, inputSpanQuery, inputDocQuery);
        result.setText(queryString);
        result.setSpanQueryString(spanQuery);
        result.setDocumentQueryString(docQuery);
        result.setMaxLocalSlop(this.maxLocalSlop);
        return result;
    }

    private String resolveQuery(String queryModel, String inputSpanQuery, String inputDocQuery) {
        return queryModel.replaceAll(SPAN_PATTERN, inputSpanQuery).replaceAll(DOC_PATTERN, inputDocQuery);
    }
}

