/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.AssetQueryExecutor;
import com.ibm.supa.search.queries.DocLevelQueryUtilities;
import com.ibm.supa.search.queries.InliningTextProcessor;
import com.ibm.supa.search.queries.SimpleTextProcessor;
import com.ibm.supa.search.queries.TextProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;

public class WorkAdvisorQueryExecutor3
extends AssetQueryExecutor {
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        try {
            return new Executor(query, processor, wrappers, this.categorizationFilter, this.annotations, this.addFieldGroupToQuery, this.fieldsBoost);
        }
        catch (TokenizerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Executor
    extends AssetQueryExecutor.Executor {
        static final int TERM_VECTOR_SIZE = 20;
        private TextProcessor textProcessor;
        private SupaQuery queryClone;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers, String categorizationFilter, List<String> annotations, boolean addFieldGroupToQuery, Map<String, Float> fieldsBoost) throws SiapiException, TokenizerException {
            super(query, processor, wrappers, categorizationFilter, annotations, addFieldGroupToQuery, fieldsBoost);
            InliningTextProcessor tProc = new InliningTextProcessor();
            tProc.setNext(new SimpleTextProcessor());
            this.textProcessor = tProc;
            this.queryClone = (SupaQuery)query.clone();
        }

        @Override
        protected ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws SiapiException, TokenizerException, ExtendedException, IOException {
            DocLevelQueryUtilities docLevel = new DocLevelQueryUtilities(wrapper);
            docLevel.parseQuery(this.queryClone.getDocumentQueryString(), "_plain");
            HashMap<String, String> fieldMap = docLevel.getFieldMap();
            StringBuilder sBuf = new StringBuilder();
            for (Map.Entry fieldEntry : fieldMap.entrySet()) {
                String value = ((String)fieldEntry.getValue()).trim();
                if (value.length() == 0) continue;
                sBuf.append('/').append((String)fieldEntry.getKey()).append(": ").append(this.textProcessor.process(value)).append(" / ");
            }
            super.updateDocumentQueryString(sBuf.toString());
            return super.buildRootQuery(wrapper);
        }
    }
}

