/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.queries.SearchSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkAdvisorQueryExecutor
extends BaseQueryExecutor {
    private static int MAX_LUCENE_RESULTS_PER_COLLECTION = 200;
    private String categorizationFilter = null;
    private List<String> annotations = new ArrayList<String>();

    public void setCategorizationFilter(String categorizationFilter) {
        this.categorizationFilter = categorizationFilter;
    }

    public void setIndexedAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers, this.categorizationFilter, this.annotations);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        AdvisorQuery result = (AdvisorQuery)this.subCreateQuery(collectionIds);
        result.setText(queryString);
        return result;
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new AdvisorQuery(collectionIds);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return AdvisorQuery.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Executor
    extends BaseQueryExecutor.BaseExecutor {
        private String categorizationFilter = null;
        private List<String> annotations = new ArrayList<String>();
        AdvisorQuery wQuery;
        SearchWrapper currentWrapper;
        static final int TERM_VECTOR_SIZE = 20;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers, String categorizationFilter, List<String> annotations) throws SiapiException {
            super(query, processor, wrappers);
            this.categorizationFilter = categorizationFilter;
            this.annotations = annotations;
            query = this.buildRootQuery(query);
            this.wQuery = (AdvisorQuery)AdvisorQuery.class.cast(query);
        }

        protected SupaQuery buildRootQuery(SupaQuery query) throws SiapiException {
            String queryString = query.getText();
            HashMap<String, String> queryParts = this.translateQueryStr(queryString);
            try {
                SearchSelector searchSelector = new SearchSelector(queryParts.values().toString(), this.wrappers, 20);
                ArrayList<String> mostImportantTokens = searchSelector.getSortedTokens();
                query.setText(this.extractTokens(mostImportantTokens));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return query;
        }

        String extractTokens(ArrayList<String> tokens) {
            String newQuery = tokens.toString();
            newQuery.replace("[", "");
            newQuery.replace("]", "");
            newQuery.replace(",", " ");
            newQuery = newQuery.trim();
            return newQuery;
        }

        private HashMap<String, String> translateQueryStr(String query) {
            String[] queryParts;
            HashMap<String, String> queryMap = new HashMap<String, String>();
            StringBuilder buff = new StringBuilder();
            for (String queryPart : queryParts = query.split("/")) {
                if (queryPart.indexOf("summary") >= 0) {
                    queryMap.put("summary", queryPart.substring(8).replace("/", ""));
                    continue;
                }
                if (queryPart.indexOf("description") >= 0) {
                    queryMap.put("description", queryPart.substring(12).replace("/", ""));
                    continue;
                }
                if (queryPart.indexOf("userAddition") >= 0) {
                    queryMap.put("userAddition", queryPart.substring(13).replace("/", ""));
                    continue;
                }
                if (queryPart.indexOf("userImportantAddition") >= 0) {
                    queryMap.put("userImportantAddition", queryPart.substring(22).replace("/", ""));
                    continue;
                }
                if (queryPart.trim().length() <= 0) continue;
                queryMap.put("userImportantAddition", queryPart.trim());
            }
            return queryMap;
        }

        @Override
        protected ResultSet subExecute() throws SiapiException {
            return null;
        }
    }

    public static class AdvisorQuery
    extends SupaQueryImpl {
        private static final long serialVersionUID = 6718490103018168662L;

        public AdvisorQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
        }
    }
}

