/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.CountSelectedFacets;
import com.ibm.es.nuvo.facet.FacetHitCollector;
import com.ibm.es.nuvo.facet.WorkingFacetCounter;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.search.FacetSearcher;
import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.es.nuvo.synonym.index.SynonymIndexSearcher;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.SpellCorrection;
import com.ibm.supa.common.SUPAConstants;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchUtils;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.filter.ACLResultFilter;
import com.ibm.supa.search.filter.ResultFilter;
import com.ibm.supa.search.queries.DocLevelQueryUtilities;
import com.ibm.supa.search.queries.QueryBuilder;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.SpanResultFetcher;
import com.ibm.supa.search.spans.SpanResultUtils;
import com.ibm.supa.search.spans.extended.AlignedDocExtSpanQuery;
import com.ibm.supa.search.spans.extended.DocExtSpanScorer;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.ExtSpanQueryScorer;
import com.ibm.supa.search.spans.extended.ExtSpanQuerySelector;
import com.ibm.supa.search.spans.extended.ExtSpanScorer;
import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import com.ibm.supa.search.spans.extended.ExtSpanVint8Query;
import com.ibm.supa.search.spans.extended.ExtSpanWildcardQuery;
import com.ibm.supa.search.spans.extended.ExtSpansRepeaterQuery;
import com.ibm.supa.search.spans.extended.MultiExtSpanScorer;
import com.ibm.supa.search.spans.extended.NumSubSpansScorer;
import com.ibm.supa.search.spans.extended.QueryOrderScorer;
import com.ibm.supa.search.spans.extended.RecursiveExtSpanScorer;
import com.ibm.supa.search.spans.extended.SimpleExtSpanScorer;
import com.ibm.supa.search.spans.extended.SlopExtSpanScorer;
import com.ibm.supa.search.spans.extended.SpanLengthExtSpanScorer;
import com.ibm.supa.search.spans.extended.SpanResultExtSpanScorer;
import com.ibm.supa.search.spans.extended.tags.DiffIDExtSpanQuery;
import com.ibm.supa.search.spans.extended.tags.ExtSpanTermTagQuery;
import com.ibm.supa.search.spans.extended.tags.SameIDExtSpanQuery;
import com.ibm.supa.search.spans.extended.tags.TagExtSpans;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.extended.ExtSpanDocBitSetQuery;
import org.apache.lucene.search.spans.extended.ExtSpanDocQuery;
import org.apache.lucene.search.spans.extended.ExtSpanFarQuery;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansDocHashFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextQueryExecutor
extends BaseQueryExecutor {
    private static int MAX_SEARCH_TIME = 15000;
    private static int MAX_RESULTS = 1000;
    private static int MAX_IN_MEMORY_RESULTS = 2 * MAX_RESULTS;
    public static String DIVIDER = "@@";

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        TextQuery result = (TextQuery)this.subCreateQuery(collectionIds);
        int index = queryString.indexOf(DIVIDER);
        result.setText(queryString);
        if (index < 0) {
            result.setSpanQueryString(queryString);
        } else {
            result.setSpanQueryString(queryString.substring(0, index));
            result.setDocumentQueryString(queryString.substring(index + DIVIDER.length()));
        }
        return result;
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new TextQuery(collectionIds);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return TextQuery.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Executor
    extends BaseQueryExecutor.BaseExecutor {
        TextQuery tQuery;
        ResultsProcessor processor;
        ExtSpanScorer synScorer;
        ExtSpanScorer lemmaScorer;
        QueryBuilder.WorkCollections topLevelCollections;
        QueryBuilder builder;
        RecursiveExtSpanScorer scorer;
        SearchWrapper currentWrapper;
        Map<ExtSpanQuery, List<QueryFragment>> fragmentLookup;
        int numInclusiveClauses;
        private ArrayList<SpanResult> spanResults;
        private int totalResults;
        long evalTimeout;
        private boolean resultsTruncated = false;
        boolean enableAutoDocLevelQuerying = true;
        boolean enableScoringAdjustments = true;
        boolean forceOptionals = false;
        boolean termsAreOptional = false;
        boolean partialsAllowed = false;
        boolean createConstrainingDocQuery = false;
        ExtSpansDocHashFilter docHashFilter;
        boolean saveSameDocExtSpans = true;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
            this.tQuery = (TextQuery)TextQuery.class.cast(query);
            this.processor = processor;
            this.synScorer = new SimpleExtSpanScorer(2.0, null);
            this.lemmaScorer = new SimpleExtSpanScorer(1.0, null);
            this.topLevelCollections = new QueryBuilder.WorkCollections();
        }

        void addScorer(ExtSpanQuery query, ExtSpanScorer scorer) {
            if (this.enableScoringAdjustments) {
                this.scorer.addScorer(query, scorer);
            }
        }

        void addWeighting(ExtSpanQuery query, double weight) {
            if (this.enableScoringAdjustments) {
                this.scorer.addWeighting(query, weight);
            }
        }

        @Override
        protected ResultSet subExecute() throws SiapiException {
            long startTime = System.currentTimeMillis();
            try {
                this.scorer = new RecursiveExtSpanScorer();
                ExtSpanQueryScorer resultBuilder = new ExtSpanQueryScorer(this.scorer);
                resultBuilder.setMaxResults(MAX_RESULTS);
                resultBuilder.setMaxInMemoryResults(MAX_IN_MEMORY_RESULTS);
                this.evalTimeout = this.getEvalTimeout(startTime);
                super.scheduleInterrupt((long)Math.ceil(1.5 * (double)(this.evalTimeout - startTime)));
                boolean evalTimeOk = true;
                for (int i = 0; i < this.wrappers.length && evalTimeOk; ++i) {
                    evalTimeOk = this.execute(this.wrappers[i], resultBuilder);
                }
                CountSelectedFacets[] countedFacets = new CountSelectedFacets[this.wrappers.length];
                this.extractResults(resultBuilder, countedFacets);
                long evalTime = System.currentTimeMillis() - startTime;
                SpellCorrection[] spellCorrections = null;
                String[] queriedFields = new String[]{};
                if (this.spanResults == null || this.spanResults.isEmpty()) {
                    return new ResultSetImpl(null, null, null, null, spellCorrections, evalTime, 0, this.totalResults, queriedFields, !evalTimeOk);
                }
                SpanResult.Type spanType = this.evaluateSpanResults();
                boolean loadTexts = this.tQuery.areDescriptionsLoaded();
                if (spanType == SpanResult.Type.COMPLETE_DOC) {
                    loadTexts = false;
                }
                Result[] results = SearchUtils.load(this.spanResults, this.tQuery, loadTexts, this.wrappers.length > 1, new SpanResultImpl.Visitor(){

                    public void visit(SpanResultImpl resultImpl) throws IOException, SiapiException {
                        SearchWrapper wrapper = resultImpl.getSpanResult().getSearchWrapper();
                        if (resultImpl.getSpanType() == SpanResult.Type.COMPLETE_DOC) {
                            resultImpl.setShowScore(true);
                            SearchSnapshot snapshot = Executor.this.tQuery.getSearchSnapshot();
                            String summary = null;
                            List<String> userQueries = null;
                            if (snapshot == null) {
                                userQueries = new ArrayList<String>();
                                userQueries.add(Executor.this.tQuery.getDocumentQueryString());
                            } else {
                                userQueries = snapshot.getPreviousAndCurrentUserQueries();
                            }
                            try {
                                DocLevelQueryUtilities docLevelQueryUtilities = new DocLevelQueryUtilities(wrapper);
                                summary = docLevelQueryUtilities.getSummary(userQueries, "_plain", resultImpl.getTokenizedDocument().getDocument(), resultImpl.getDocId());
                            }
                            catch (ExtendedException e) {
                                summary = "";
                            }
                            resultImpl.setDescription(summary);
                        } else if (resultImpl.getSpanType() == SpanResult.Type.PARTIAL_DOC) {
                            resultImpl.setShowScore(true);
                        }
                        wrapper.updateCachedProperty(resultImpl);
                    }
                });
                if (spanType == SpanResult.Type.PARTIAL_DOC) {
                    if (this.saveSameDocExtSpans) {
                        this.saveSameDocExtSpans(resultBuilder, (SpanResultImpl[])results);
                    }
                    if (this.processor != null) {
                        if (this.tQuery.getType() == SupaQuery.Type.DOC) {
                            this.fragmentLookup = Collections.emptyMap();
                        }
                        this.processor.process((SpanResultImpl[])results, this.tQuery, this.fragmentLookup);
                    }
                }
                for (SpanResultImpl spanResultImpl : results) {
                    spanResultImpl.clearNonExporables();
                }
                this.resultsTruncated |= !evalTimeOk;
                if (this.docHashFilter != null) {
                    this.resultsTruncated |= this.docHashFilter.dupsRemoved();
                }
                return new ResultSetImpl(results, null, countedFacets[0], null, spellCorrections, evalTime, resultBuilder.size(), resultBuilder.getTotalResults(), queriedFields, this.resultsTruncated);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ExtendedException e) {
                throw new RuntimeException(e);
            }
        }

        private SpanResult.Type evaluateSpanResults() throws ExtendedException {
            if (this.spanResults == null || this.spanResults.isEmpty()) {
                return null;
            }
            SpanResult.Type retType = this.spanResults.get(0).getType();
            for (SpanResult curResult : this.spanResults) {
                if (curResult.getType() != null && curResult.getType() == retType) continue;
                throw new ExtendedException("All span results must have the same type");
            }
            return retType;
        }

        private boolean execute(SearchWrapper wrapper, ExtSpanQueryScorer resultBuilder) throws SiapiException, IOException, ExtendedException {
            SearchSnapshot.Results currResults;
            if (!wrapper.canSearchCollection()) {
                return true;
            }
            ExtSpanQuery rootQuery = null;
            SearchSnapshot snapshot = this.tQuery.getSearchSnapshot();
            if (snapshot != null && (currResults = snapshot.getResults(wrapper.getCollectionId())) != null && currResults.isSameVersion(wrapper.getIndexVersion())) {
                rootQuery = this.buildQueryFromSnapshotResults(currResults);
            }
            if (rootQuery == null) {
                SearchSnapshot prevSnapshot = snapshot != null ? snapshot.getPreviousSnapshot() : null;
                ExtSpanQuery prevQuery = null;
                if (SearchUtils.needsPrevResults(snapshot)) {
                    long start = System.currentTimeMillis();
                    SearchSnapshot.Results prevResults = SearchUtils.getPrevResults(snapshot, wrapper);
                    this.evalTimeout += System.currentTimeMillis() - start;
                    if (prevResults == null) {
                        return true;
                    }
                    prevQuery = this.buildQueryFromSnapshotResults(prevResults);
                }
                rootQuery = this.buildRootQuery(wrapper);
                if (prevQuery != null) {
                    ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(-1, false, false, rootQuery, prevQuery);
                    ExtSpanQuery targetQuery = rootQuery;
                    switch (snapshot.getAssociationToPreviousQuery()) {
                        case NOT_RETURNED: {
                            targetQuery = prevQuery;
                        }
                    }
                    nQuery.setSubSpanQuerySortOrder(targetQuery);
                    if (this.enableScoringAdjustments) {
                        int historyLength = 1;
                        while (prevSnapshot != null) {
                            ++historyLength;
                            prevSnapshot = prevSnapshot.getPreviousSnapshot();
                        }
                        this.scorer.addWeighting(prevQuery, ((double)historyLength - 1.0) / ((double)(historyLength - 1) + snapshot.getDecayWeighting()));
                        this.scorer.addWeighting(rootQuery, snapshot.getDecayWeighting() * 1.0 / (double)historyLength);
                    }
                    rootQuery = new ExtSpanQuerySelector(nQuery, targetQuery);
                }
            }
            ExtSpans extSpans = rootQuery.getExtSpans(wrapper.getTextIndexReader());
            return resultBuilder.score(this.evalTimeout, extSpans, wrapper, snapshot, this.tQuery);
        }

        ExtSpanQuery buildQueryFromSnapshotResults(SearchSnapshot.Results results) {
            if (results == null) {
                return new ExtSpanOrQuery(new ExtSpanQuery[0]);
            }
            ExtSpans[] extSpans = new ExtSpans[results.getSpanResults().size()];
            int i = 0;
            for (SpanResult spanResult : results.getSpanResults()) {
                extSpans[i++] = spanResult.getExtSpans();
            }
            ExtSpansRepeaterQuery result = new ExtSpansRepeaterQuery(extSpans);
            if (this.enableScoringAdjustments) {
                this.scorer.addScorer(result, new SpanResultExtSpanScorer(results.getSpanResults(), true));
            }
            return result;
        }

        private void saveSameDocExtSpans(final ExtSpanQueryScorer resultBuilder, SpanResultImpl[] results) throws ExtendedException, IOException, SiapiException {
            TreeSet orderedImpls = SpanResultUtils.toTreeSet((SpanResultFetcher[])results);
            TokenizedDocument[][] tDocs = SpanResultImpl.toTokenizedDocuments(orderedImpls);
            SpanResultUtils.visit(orderedImpls, tDocs, new SpanResultUtils.VisitHandler<SpanResultImpl>(){
                List<ExtSpans> docSpans;

                @Override
                public void handleNewDoc(TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
                    this.docSpans = null;
                }

                @Override
                public void handle(SpanResultImpl spanResultFetcher, TokenizedDocument tDoc) throws ExtendedException, IOException, SiapiException {
                    if (this.docSpans == null) {
                        this.docSpans = new ArrayList<ExtSpans>();
                        resultBuilder.copySameDocExtSpans(this.docSpans, spanResultFetcher.getSpanResult());
                    }
                    spanResultFetcher.getSpanResult().setSameDocExtSpans(this.docSpans);
                }
            });
        }

        private void extractResults(ExtSpanQueryScorer resultBuilder, CountSelectedFacets[] countedFacets) throws SiapiException, TaxonomyIndexerException, IOException, ConfigurationManagerException, ExtendedException {
            if (!resultBuilder.isEmpty()) {
                for (int i = 0; i < this.wrappers.length; ++i) {
                    FacetSearcher taxiSearcher = (FacetSearcher)this.wrappers[i].getIndexSearcher(IndexDescriptor.IndexType.Facet);
                    if (taxiSearcher == null) continue;
                    WorkingFacetCounter[] workingFacetArray = new WorkingFacetCounter[1];
                    String category = "categorization";
                    int maxDepth = 2;
                    workingFacetArray[0] = new WorkingFacetCounter(taxiSearcher.getTaxiReader(), category);
                    countedFacets[i] = new CountSelectedFacets(taxiSearcher.getTaxiReader(), this.wrappers[i].getTextIndexReader(), workingFacetArray, maxDepth);
                    FacetHitCollector facetHitCollector = new FacetHitCollector(countedFacets[i]);
                    resultBuilder.collectHits(facetHitCollector, this.wrappers[i].getCollectionId());
                }
                ResultFilter[][] filters = new ResultFilter[this.wrappers.length][];
                for (int i = 0; i < this.wrappers.length; ++i) {
                    CollectionConfiguration collectionConfig = this.wrappers[i].getCollectionConfig();
                    if (!collectionConfig.isSecureSearch() || !collectionConfig.isSecureSearchPostFilter()) continue;
                    filters[i] = new ResultFilter[]{new ACLResultFilter(this.wrappers[i].getTextIndexReader(), this.wrappers[i].getCollectionId(), this.tQuery.getCredentials())};
                }
                this.spanResults = new ArrayList(this.tQuery.getNumRequestedResults());
                this.totalResults = resultBuilder.copyOut(this.spanResults, this.tQuery.getFirstRequestedResult(), this.tQuery.getNumRequestedResults(), this.tQuery.getCollectionIds(), filters);
            }
        }

        private long getEvalTimeout(long startTime) {
            long evalTimeout = -1L;
            String earlyTermination = this.tQuery.getProperty("earlyTerminationTimeout");
            if (earlyTermination != null) {
                try {
                    evalTimeout = Long.valueOf(earlyTermination);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (evalTimeout == -1L) {
                evalTimeout = 0L;
            }
            if (evalTimeout == 0L) {
                evalTimeout = MAX_SEARCH_TIME;
            }
            return startTime + evalTimeout;
        }

        ExtSpanQuery addDocLevelQuery(ExtSpanQuery finalQuery, SearchWrapper wrapper) throws ExtendedException, SiapiException {
            String userDocQueryString = this.tQuery.getDocumentQueryString();
            if (!(this.enableAutoDocLevelQuerying || userDocQueryString != null && userDocQueryString.length() != 0)) {
                return finalQuery;
            }
            String userSpanQueryString = this.tQuery.getSpanQueryString();
            DocLevelQueryUtilities docLevelQueryUtilities = new DocLevelQueryUtilities(this.currentWrapper);
            if (userDocQueryString == null) {
                userDocQueryString = "";
            }
            if (userSpanQueryString == null) {
                userSpanQueryString = "";
            }
            userDocQueryString = userDocQueryString.trim();
            userSpanQueryString = userSpanQueryString.trim();
            if (this.enableAutoDocLevelQuerying) {
                if (!userDocQueryString.equals("")) {
                    userDocQueryString = userDocQueryString + " " + docLevelQueryUtilities.buildAutoDocQueryAddition(userDocQueryString, DocLevelQueryUtilities.AutoDocQueryConfig.WITHOUT_PLAINTEXT, "title", "filename");
                }
                if (!userSpanQueryString.equals("")) {
                    userDocQueryString = userDocQueryString + " " + docLevelQueryUtilities.buildAutoDocQueryAddition(userSpanQueryString, DocLevelQueryUtilities.AutoDocQueryConfig.WITH_PLAINTEXT_ONLY_PHRASE_OPTIONAL, "title", "filename");
                }
            }
            if ((userDocQueryString = userDocQueryString.trim()).length() == 0) {
                return finalQuery;
            }
            Query docLevelQuery = docLevelQueryUtilities.parseQuery(userDocQueryString, "_plain");
            final ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
            class SetableFloat {
                private float val = 0.0f;

                public float getVal() {
                    return this.val;
                }

                public void setVal(float val) {
                    this.val = val;
                }
            }
            final SetableFloat highestScore = new SetableFloat();
            final BitSet bitSet = new BitSet();
            highestScore.setVal(Float.MIN_VALUE);
            try {
                IndexSearcher searcher = new IndexSearcher(this.currentWrapper.getTextIndexReader());
                searcher.search(docLevelQuery, new HitCollector(){
                    {
                    }

                    public void collect(int doc, float score) {
                        if (score < 0.0f) {
                            return;
                        }
                        scoreDocs.add(new ScoreDoc(doc, score));
                        bitSet.set(doc);
                        if (score >= highestScore.getVal()) {
                            highestScore.setVal(score);
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            ExtSpanDocBitSetQuery extSpanDocQuery = new ExtSpanDocBitSetQuery(bitSet, true);
            extSpanDocQuery.setField(finalQuery.getField());
            this.scorer.addScorer(extSpanDocQuery, new DocExtSpanScorer(null, scoreDocs, true, highestScore.getVal()));
            ExtSpanQuery result = new ExtSpanContainsQuery(extSpanDocQuery, finalQuery, false).optimize(false);
            this.docHashFilter = null;
            boolean filterDocs = Boolean.valueOf(this.tQuery.getProperty("filter"));
            if (filterDocs) {
                // empty if block
            }
            return result;
        }

        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            if (this.tQuery.getType() == SupaQuery.Type.SPAN) {
                return this.buildSpanRootQuery(wrapper);
            }
            if (this.tQuery.getType() == SupaQuery.Type.DOC) {
                return this.buildDocRootQuery(wrapper);
            }
            throw new ExtendedException("Unknown query type");
        }

        ExtSpanQuery buildDocRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            String userDocQueryString = this.tQuery.getDocumentQueryString();
            this.currentWrapper = wrapper;
            DocLevelQueryUtilities docLevelQueryUtilities = new DocLevelQueryUtilities(this.currentWrapper);
            userDocQueryString = userDocQueryString.trim();
            if (this.enableAutoDocLevelQuerying && !userDocQueryString.equals("")) {
                userDocQueryString = userDocQueryString + " " + docLevelQueryUtilities.buildAutoDocQueryAddition(userDocQueryString, DocLevelQueryUtilities.AutoDocQueryConfig.WITHOUT_PLAINTEXT, "title", "filename");
            }
            userDocQueryString = userDocQueryString.trim();
            Query docLevelQuery = docLevelQueryUtilities.parseQuery(userDocQueryString, "_plain");
            final ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
            class SetableFloat {
                private float val = 0.0f;

                public float getVal() {
                    return this.val;
                }

                public void setVal(float val) {
                    this.val = val;
                }
            }
            final SetableFloat highestScore = new SetableFloat();
            final BitSet bitSet = new BitSet();
            highestScore.setVal(Float.MIN_VALUE);
            try {
                IndexSearcher searcher = new IndexSearcher(this.currentWrapper.getTextIndexReader());
                searcher.search(docLevelQuery, new HitCollector(){
                    {
                    }

                    public void collect(int doc, float score) {
                        if (score < 0.0f) {
                            return;
                        }
                        scoreDocs.add(new ScoreDoc(doc, score));
                        bitSet.set(doc);
                        if (score >= highestScore.getVal()) {
                            highestScore.setVal(score);
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            ExtSpanDocBitSetQuery extSpanDocQuery = new ExtSpanDocBitSetQuery(bitSet, true);
            extSpanDocQuery.setField("_plain");
            this.scorer.addScorer(extSpanDocQuery, new DocExtSpanScorer(null, scoreDocs, true, highestScore.getVal()));
            return this.addSecurePreFilterQuery(extSpanDocQuery);
        }

        ExtSpanQuery buildSpanRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            this.currentWrapper = wrapper;
            this.builder = new QueryBuilder(this.currentWrapper, new QueryBuilder.QueryCreationHandler(){

                public void handleLemmaQueryCreated(ExtSpanQuery query) {
                    Executor.this.addScorer(query, Executor.this.lemmaScorer);
                }

                public void handleInternalMultiSynQueryCreated(ExtSpanQuery query, ExtSpanQuery[] clauses) {
                    Executor.this.addScorer(query, new MultiExtSpanScorer(new SlopExtSpanScorer(0.25), new QueryOrderScorer(clauses, 0.1, true)));
                }

                public void handleSubwordQueryCreated(ExtSpanQuery query, ExtSpanQuery[] clauses) {
                    Executor.this.addScorer(query, new MultiExtSpanScorer(new SpanLengthExtSpanScorer(5.0), new SimpleExtSpanScorer(0.25, null)));
                }

                public void handleSynQueryCreated(ExtSpanQuery query) {
                    Executor.this.addScorer(query, Executor.this.synScorer);
                }
            });
            LinkedList<ExtSpanQuery> queries = new LinkedList<ExtSpanQuery>();
            LinkedList<ExtSpanQuery> exclQueries = new LinkedList<ExtSpanQuery>();
            LinkedList<ExtSpanQuery> notQueries = new LinkedList<ExtSpanQuery>();
            this.fragmentLookup = new IdentityHashMap<ExtSpanQuery, List<QueryFragment>>();
            QueryFragment[] fragments = this.parseQueryFragments(queries, exclQueries, notQueries);
            ExtSpanQuery[] clauses = queries.toArray(new ExtSpanQuery[queries.size()]);
            this.numInclusiveClauses = clauses.length;
            ExtSpanQuery finalQuery = this.createInclusiveQuery("_plain", clauses, fragments, true, true);
            this.addScorer(finalQuery, new MultiExtSpanScorer(new SlopExtSpanScorer(10.0 / (double)Math.max(1, this.tQuery.getMaxLocalSlop())), new SpanLengthExtSpanScorer(0.001)));
            finalQuery = this.addFarQuery(finalQuery, notQueries, 0, 0);
            finalQuery = this.addFarQuery(finalQuery, exclQueries, 0, this.tQuery.getMinFarLocalSlop());
            ExtSpanVint8Query iQuery = new ExtSpanVint8Query("_plainendpos", "_plain", Integer.MAX_VALUE);
            finalQuery = new ExtSpanContainsQuery(iQuery, finalQuery, false).optimize(false);
            finalQuery = this.addSecurePreFilterQuery(this.addDocLevelQuery(finalQuery, wrapper));
            return finalQuery;
        }

        private ExtSpanQuery createInclusiveQuery(String field, ExtSpanQuery[] clauses, QueryFragment[] fragments, boolean addToFragmentLookup, boolean topLevel) throws SiapiException {
            return this.createInclusiveQuery(field, clauses, fragments, addToFragmentLookup, topLevel, this.tQuery.getMaxLocalSlop(), false);
        }

        private ExtSpanQuery createInclusiveQuery(String field, ExtSpanQuery[] clauses, QueryFragment[] fragments, boolean addToFragmentLookup, boolean topLevel, int maxSlop, boolean inOrder) throws SiapiException {
            this.topLevelCollections.clauseList.clear();
            int[] fragmentIndeces = new int[clauses.length];
            int i = 0;
            int index = 0;
            while (index < clauses.length) {
                if (!fragments[i].isExclusive()) {
                    fragmentIndeces[index] = i;
                    ++index;
                }
                ++i;
            }
            ExtSpanQuery[][] synQueries = this.getSynQueries(field, clauses, fragmentIndeces, fragments, addToFragmentLookup);
            boolean[][] optionals = new boolean[synQueries.length][];
            for (int i2 = 0; i2 < clauses.length; ++i2) {
                optionals[i2] = new boolean[synQueries[i2].length];
                optionals[i2][0] = fragments[fragmentIndeces[i2]].isOptional();
                for (int j = 1; j < optionals[i2].length; ++j) {
                    optionals[i2][j] = optionals[i2][j - 1] && fragments[fragmentIndeces[i2 + j]].isOptional();
                }
            }
            this.buildInclusiveQueries(synQueries, optionals, new LinkedList<ExtSpanQuery>(), new LinkedList<Boolean>(), new LinkedList<ExtSpanQuery>(), 0, topLevel, maxSlop, inOrder);
            return QueryBuilder.buildOrQuery(this.topLevelCollections.clauseList, true);
        }

        private void buildInclusiveQueries(ExtSpanQuery[][] synQueries, boolean[][] synOptionals, LinkedList<ExtSpanQuery> current, LinkedList<Boolean> currentOptionals, LinkedList<ExtSpanQuery> mandatories, int length, boolean topLevel, int maxSlop, boolean inOrder) throws SiapiException {
            int newLength;
            if (length == synQueries.length) {
                ExtSpanQuery[] clauses = current.toArray(new ExtSpanQuery[current.size()]);
                boolean[] optionals = new boolean[clauses.length];
                int i = 0;
                int numOptionals = 0;
                for (Boolean opt : currentOptionals) {
                    optionals[i++] = opt;
                    numOptionals += opt != false ? 1 : 0;
                }
                ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, maxSlop, inOrder);
                if (numOptionals != 0) {
                    nQuery.setAllowPartialResults(this.partialsAllowed);
                }
                ExtSpanQuery baseQuery = nQuery.optimize(false);
                this.addScorer(baseQuery, new QueryOrderScorer(clauses, 0.5, true));
                if (numOptionals != 0 && clauses.length > 1) {
                    this.addScorer(baseQuery, new NumSubSpansScorer(clauses.length, Math.min(10, 80 / numOptionals)));
                }
                if (this.createConstrainingDocQuery && topLevel && mandatories.size() > 1 && numOptionals != 0) {
                    clauses = mandatories.toArray(new ExtSpanQuery[mandatories.size()]);
                    ExtSpanQuery docQuery = new AlignedDocExtSpanQuery(clauses).optimize(false);
                    baseQuery = new ExtSpanContainsQuery(docQuery, baseQuery, false).optimize(false);
                }
                this.topLevelCollections.clauseList.add(baseQuery);
                return;
            }
            for (int i = 0; i < synQueries[length].length && (newLength = length + (i + 1)) <= synQueries.length; ++i) {
                if (synQueries[length][i] == null) continue;
                current.addLast(synQueries[length][i]);
                if (!synOptionals[length][i]) {
                    mandatories.addLast(synQueries[length][i]);
                }
                Boolean optional = topLevel && this.forceOptionals ? (this.termsAreOptional ? Boolean.TRUE : Boolean.FALSE) : Boolean.valueOf(synOptionals[length][i]);
                currentOptionals.addLast(optional);
                this.buildInclusiveQueries(synQueries, synOptionals, current, currentOptionals, mandatories, newLength, topLevel, maxSlop, inOrder);
                current.removeLast();
                if (!synOptionals[length][i]) {
                    mandatories.removeLast();
                }
                currentOptionals.removeLast();
            }
        }

        double[] getIdfFactors(ExtSpanQuery baseQuery, SearchWrapper wrapper) throws SiapiException {
            IndexReader reader = wrapper.getTextIndexReader();
            Similarity similarity = wrapper.getIndexSearcher(IndexDescriptor.IndexType.Text).getSimilarity();
            double[] factors = new double[baseQuery.numIncludedClauses()];
            HashSet terms = new HashSet();
            for (int i = 0; i < baseQuery.numIncludedClauses(); ++i) {
                ExtSpanQuery clause = baseQuery.includedClause(i);
                try {
                    clause.extractTerms(terms);
                }
                catch (UnsupportedOperationException e) {
                    continue;
                }
                int totalDocFreq = 0;
                for (Term term : terms) {
                    try {
                        totalDocFreq += reader.docFreq(term);
                    }
                    catch (IOException e) {}
                }
                factors[i] = Math.max(0.0f, similarity.idf(totalDocFreq, terms.size() * reader.maxDoc()));
                int n = i;
                factors[n] = factors[n] * factors[i];
                terms.clear();
            }
            return factors;
        }

        private ExtSpanQuery[][] getSynQueries(String field, ExtSpanQuery[] clauses, int[] fragmentIndeces, QueryFragment[] fragments, boolean addToFragmentLookup) throws SiapiException {
            ExtSpanQuery[][] result = new ExtSpanQuery[clauses.length][];
            SynonymIndexSearcher synSearcher = null;
            if (this.builder.initSynSearcher()) {
                synSearcher = this.builder.getSynSearcher();
            }
            for (int i = 0; i < clauses.length; ++i) {
                int j;
                int candLength;
                QueryFragment fragment = fragments[fragmentIndeces[i]];
                if (synSearcher == null || !fragment.areSynonymsAllowed()) {
                    candLength = 1;
                } else {
                    candLength = synSearcher.identifyCandidate(fragment.getBaseTermText());
                    if (candLength <= 1) {
                        candLength = 1;
                    } else {
                        int numConsecutive = 1;
                        for (j = i + 1; j < clauses.length && fragmentIndeces[j] == fragmentIndeces[j - 1] + 1 && fragments[fragmentIndeces[j]].areSynonymsAllowed(); ++j) {
                            ++numConsecutive;
                        }
                        candLength = Math.min(candLength, numConsecutive);
                    }
                }
                if (addToFragmentLookup) {
                    this.addFragmentLookup(clauses[i], fragment);
                }
                result[i] = new ExtSpanQuery[candLength];
                result[i][0] = clauses[i];
                StringBuilder sBuf = new StringBuilder();
                sBuf.append(fragment.getBaseTermText());
                for (j = 1; j < candLength; ++j) {
                    sBuf.append(' ');
                    sBuf.append(fragments[i + j].getBaseTermText());
                    String[] syns = synSearcher.getSynonyms(sBuf.toString());
                    if (syns == null || syns.length <= 0) continue;
                    result[i][j] = this.builder.buildSynQuery(field, syns, true, true, fragment.areSubwordsAllowed());
                    if (!addToFragmentLookup) continue;
                    this.addFragmentLookup(result[i][j], fragments, fragmentIndeces, i, j + 1);
                }
            }
            return result;
        }

        ExtSpanQuery addSecurePreFilterQuery(ExtSpanQuery finalQuery) throws ConfigurationManagerException {
            CollectionConfiguration collectionConfig = this.currentWrapper.getCollectionConfig();
            if (!collectionConfig.isSecureSearch() || !collectionConfig.isSecureSearchPreFilter()) {
                return finalQuery;
            }
            Query secQuery = com.ibm.es.nuvo.search.security.QueryBuilder.buildSecurity(this.tQuery.getCredentials());
            ExtSpanDocQuery extSpanSecQuery = new ExtSpanDocQuery(secQuery, true, finalQuery.getField());
            return new ExtSpanContainsQuery(extSpanSecQuery, finalQuery, false).optimize(false);
        }

        private QueryFragment[] parseQueryFragments(List<ExtSpanQuery> inclQueries, List<ExtSpanQuery> exclQueries, List<ExtSpanQuery> notQueries) throws ExtendedException, SiapiException {
            LinkedList<QueryFragment> fragments = new LinkedList<QueryFragment>();
            LinkedList<Group> openGroups = new LinkedList<Group>();
            Group openGroup = null;
            LinkedList<String> nextTokens = new LinkedList<String>();
            StringBuilder newTokenText = new StringBuilder();
            StringTokenizer sTok = new StringTokenizer(this.tQuery.getSpanQueryString());
            while (sTok.hasMoreTokens()) {
                nextTokens.addLast(sTok.nextToken());
            }
            try {
                while (!nextTokens.isEmpty()) {
                    String tokenText = ((String)nextTokens.removeFirst()).trim();
                    if (tokenText.length() == 0) continue;
                    tokenText = this.getFirstBaseToken(tokenText, nextTokens, newTokenText);
                    if (openGroup != null && !openGroup.closing) {
                        this.markGroupForClosing(openGroup, tokenText, nextTokens);
                        if (openGroup.closing) {
                            assert (openGroup.name != null);
                            openGroup = this.closeAndPopGroup(openGroup, openGroups, inclQueries, exclQueries, notQueries, fragments);
                            continue;
                        }
                    }
                    if (openGroup != null && openGroup.name == null) {
                        assert (openGroup.type != Group.Type.GROUPING && tokenText.length() > 0);
                        int index = tokenText.indexOf(58);
                        if (index < 0) {
                            openGroup.name = tokenText;
                            continue;
                        }
                        openGroup.name = tokenText.substring(0, index);
                        nextTokens.addFirst(tokenText.substring(index + 1));
                        continue;
                    }
                    QueryFragment fragment = new QueryFragment(fragments.size(), tokenText);
                    fragments.add(fragment);
                    ExtSpanQuery query = null;
                    List<ExtSpanQuery> queryList = inclQueries;
                    fragment.setExclusive(false);
                    if (openGroup != null && openGroup.type == Group.Type.PHRASE) {
                        fragment.setExact(true);
                        fragment.setBaseTermText(this.builder.normalize(tokenText));
                        queryList.add(this.builder.buildTermQuery(this.getValueField(openGroup), fragment.getBaseTermText()));
                        if (openGroup == null || !openGroup.closing) continue;
                        openGroup = this.closeAndPopGroup(openGroup, openGroups, inclQueries, exclQueries, notQueries, fragments);
                        continue;
                    }
                    if (this.charAt(tokenText, 0, '-') || this.charAt(tokenText, 0, '!')) {
                        queryList = this.charAt(tokenText, 0, '!') ? exclQueries : notQueries;
                        fragment.setExclusive(true);
                        tokenText = tokenText.substring(1);
                    }
                    if (this.charAt(tokenText, 0, '{') || this.charAt(tokenText, 0, '(') || this.charAt(tokenText, 0, '<') || this.charAt(tokenText, 0, '\"')) {
                        openGroup = new Group();
                        openGroup.queryList = queryList;
                        openGroup.exclQueryStart = exclQueries.size();
                        openGroup.inclQueryStart = inclQueries.size();
                        openGroup.fragmentStart = fragments.size();
                        openGroup.closing = false;
                        int subStart = 1;
                        if (this.charAt(tokenText, 0, '(')) {
                            openGroup.name = "():" + this.getValueField(openGroup);
                            openGroup.type = Group.Type.GROUPING;
                        } else if (this.charAt(tokenText, 0, '\"')) {
                            openGroup.name = "\"\":" + this.getValueField(openGroup);
                            openGroup.type = Group.Type.PHRASE;
                        } else {
                            Group.Type type = openGroup.type = this.charAt(tokenText, 0, '{') ? Group.Type.UIMA : Group.Type.XML;
                            if (tokenText.length() > 1 && this.charAt(tokenText, 1, '~')) {
                                subStart = 2;
                            }
                            if (tokenText.length() > subStart && this.charAt(tokenText, subStart, '@')) {
                                openGroup.attribute = true;
                                ListIterator<Group> it = openGroups.listIterator(openGroups.size());
                                while (it.hasPrevious()) {
                                    Group group = it.previous();
                                    if (group.type != openGroup.type) continue;
                                    if (openGroup.queryList == inclQueries) {
                                        if (group.inclAttributes == null) {
                                            group.inclAttributes = new LinkedList<ExtSpanQuery>();
                                        }
                                        openGroup.queryList = group.inclAttributes;
                                        break;
                                    }
                                    if (group.exclAttributes == null) {
                                        group.exclAttributes = new LinkedList<ExtSpanQuery>();
                                    }
                                    openGroup.queryList = group.exclAttributes;
                                    break;
                                }
                                ++subStart;
                            }
                        }
                        openGroups.addLast(openGroup);
                        nextTokens.addFirst(tokenText.substring(subStart));
                        continue;
                    }
                    if (tokenText.length() == 0) continue;
                    String field = this.getValueField(openGroup);
                    if (this.charAt(tokenText, 0, '-') || this.charAt(tokenText, 0, '!')) {
                        queryList = this.charAt(tokenText, 0, '!') ? exclQueries : notQueries;
                        fragment.setExclusive(true);
                        tokenText = tokenText.substring(1);
                    }
                    if (this.charAt(tokenText, -1, '?')) {
                        fragment.setOptional(true);
                        tokenText = tokenText.substring(0, tokenText.length() - 1);
                    }
                    if (ExtSpanWildcardQuery.containsWildcard(tokenText)) {
                        fragment.setWildcard(true);
                        tokenText = this.builder.normalize(tokenText, false);
                        fragment.setBaseTermText(tokenText);
                        if (!ExtSpanWildcardQuery.containsNonOptional(tokenText)) {
                            throw new IndexOutOfBoundsException("Wildcard search can't contain all optionals");
                        }
                        query = new ExtSpanWildcardQuery(field, tokenText, SUPAConstants.INDEXED_LEMMA_MARKER).optimize(false);
                    } else {
                        boolean subWords = true;
                        boolean syns = true;
                        if (this.charAt(tokenText, 0, '=')) {
                            syns = false;
                            tokenText = tokenText.substring(1);
                        }
                        if (this.charAt(tokenText, 0, '\'') && this.charAt(tokenText, -1, '\'')) {
                            subWords = false;
                            tokenText = tokenText.substring(1, tokenText.length() - 1);
                        }
                        fragment.setBaseTermText(this.builder.normalize(tokenText));
                        fragment.setSubwordsAllowed(subWords);
                        fragment.setSynonymsAllowed(syns);
                        query = this.builder.buildQuery(this.topLevelCollections, field, tokenText, true, true, true, subWords, syns);
                    }
                    queryList.add(query);
                    if (openGroup == null || !openGroup.closing) continue;
                    openGroup = this.closeAndPopGroup(openGroup, openGroups, inclQueries, exclQueries, notQueries, fragments);
                }
                while (openGroup != null) {
                    openGroup = this.closeAndPopGroup(openGroup, openGroups, inclQueries, exclQueries, notQueries, fragments);
                }
                return fragments.toArray(new QueryFragment[fragments.size()]);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
        }

        private String getFirstBaseToken(String tokenText, LinkedList<String> nextTokens, StringBuilder newTokenText) {
            String delims = "(){}<>~\"";
            if (delims.contains("" + tokenText.charAt(0))) {
                return tokenText;
            }
            if ((tokenText.charAt(0) == '-' || tokenText.charAt(0) == '!') && tokenText.length() > 1 && delims.contains("" + tokenText.charAt(1))) {
                return tokenText;
            }
            StringTokenizer tokenTok = new StringTokenizer(tokenText, delims, true);
            newTokenText.delete(0, newTokenText.length());
            boolean escapeEnabled = false;
            while (tokenTok.hasMoreTokens()) {
                String currToken = tokenTok.nextToken();
                if (!escapeEnabled && delims.contains(currToken)) {
                    if (newTokenText.length() != 0) {
                        nextTokens.addFirst(tokenText.substring(newTokenText.length()));
                        tokenText = newTokenText.toString();
                    }
                    newTokenText.delete(0, newTokenText.length());
                    break;
                }
                newTokenText.append(currToken);
                escapeEnabled = false;
                for (int i = newTokenText.length() - 1; i >= 0 && newTokenText.charAt(i) == '\\'; --i) {
                    escapeEnabled = !escapeEnabled;
                }
            }
            return tokenText;
        }

        private boolean charAt(String str, int index, char ch) {
            if (index == -1) {
                index += str.length();
            }
            return str.charAt(index) == ch && (index == 0 || str.charAt(index - 1) != '\\');
        }

        private void markGroupForClosing(Group openGroup, String tokenText, LinkedList<String> nextTokens) {
            char closeChar;
            char openChar;
            if (openGroup.type == Group.Type.GROUPING) {
                openChar = '(';
                closeChar = ')';
            } else if (openGroup.type == Group.Type.UIMA) {
                openChar = '{';
                closeChar = '}';
            } else if (openGroup.type == Group.Type.XML) {
                openChar = '<';
                closeChar = '>';
            } else {
                openChar = '\"';
                closeChar = '\"';
            }
            for (int i = 0; i < tokenText.length(); ++i) {
                if (this.charAt(tokenText, i, closeChar)) {
                    openGroup.closing = true;
                    int nextIndex = i + 1;
                    if (nextIndex < tokenText.length() && this.charAt(tokenText, nextIndex, '?')) {
                        openGroup.optional = true;
                        ++nextIndex;
                    }
                    if ((openGroup.type == Group.Type.UIMA || openGroup.type == Group.Type.XML) && i > 0 && this.charAt(tokenText, i - 1, '~')) {
                        openGroup.excludeContainer = true;
                    }
                    nextTokens.addFirst(tokenText.substring(nextIndex));
                    break;
                }
                if (this.charAt(tokenText, i, openChar)) break;
            }
        }

        private String getValueField(Group openGroup) {
            String field = "_plain";
            if (openGroup != null) {
                if (openGroup.attribute) {
                    field = openGroup.type == Group.Type.UIMA ? "_uimavals" : "_xmlvals";
                } else if (openGroup.type == Group.Type.GROUPING || openGroup.type == Group.Type.PHRASE) {
                    field = openGroup.name.substring(openGroup.name.indexOf(":") + 1);
                }
            }
            return field;
        }

        private Group closeAndPopGroup(Group openGroup, LinkedList<Group> openGroups, List<ExtSpanQuery> inclQueries, List<ExtSpanQuery> exclQueries, List<ExtSpanQuery> notQueries, LinkedList<QueryFragment> fragments) throws SiapiException {
            this.closeGroup(openGroup, openGroups, inclQueries, exclQueries, notQueries, fragments);
            openGroups.removeLast();
            openGroup = openGroups.isEmpty() ? null : openGroups.getLast();
            return openGroup;
        }

        private void closeGroup(Group openGroup, LinkedList<Group> openGroups, List<ExtSpanQuery> inclQueries, List<ExtSpanQuery> exclQueries, List<ExtSpanQuery> notQueries, LinkedList<QueryFragment> fragments) throws SiapiException {
            ExtSpanQuery inclQuery = null;
            ExtSpanQuery[] clauses = this.extract(inclQueries, openGroup.inclQueryStart, ExtSpanQuery.class);
            QueryFragment[] groupFragments = this.extract(fragments, openGroup.fragmentStart, QueryFragment.class);
            if (clauses.length != 0) {
                boolean inOrder = false;
                int slop = this.tQuery.getMaxLocalSlop();
                if (openGroup.type == Group.Type.PHRASE) {
                    inOrder = true;
                    slop = 5;
                }
                inclQuery = this.createInclusiveQuery(this.getValueField(openGroup), clauses, groupFragments, false, false, slop, inOrder);
            }
            inclQuery = this.addFarQuery(inclQuery, notQueries, openGroup.notQueryStart, 0);
            inclQuery = this.addFarQuery(inclQuery, exclQueries, openGroup.exclQueryStart, this.tQuery.getMinFarLocalSlop());
            if (openGroup.type == Group.Type.GROUPING || openGroup.type == Group.Type.PHRASE) {
                if (inclQuery == null) {
                    throw new IndexOutOfBoundsException("No inclusive queries in grouping / phrase");
                }
            } else {
                String name;
                String baseField;
                if (openGroup.type == Group.Type.UIMA) {
                    baseField = "_uimatags";
                    name = openGroup.name.toLowerCase();
                } else {
                    baseField = "_xmltags";
                    name = openGroup.name;
                }
                String field = !openGroup.attribute ? baseField : (openGroup.type == Group.Type.UIMA ? "_uimaatts" : "_xmlatts");
                ExtSpanQuery tagQuery = new ExtSpanTermTagQuery(new Term(field, name));
                if (!openGroup.attribute) {
                    if (openGroup.inclAttributes != null) {
                        ExtSpanQuery[] attrClauses = openGroup.inclAttributes.toArray(new ExtSpanQuery[openGroup.inclAttributes.size()]);
                        tagQuery = new SameIDExtSpanQuery(tagQuery, attrClauses);
                    }
                    if (openGroup.exclAttributes != null) {
                        ExtSpanQuery exclAttr = QueryBuilder.buildOrQuery(openGroup.exclAttributes);
                        tagQuery = new DiffIDExtSpanQuery(tagQuery, exclAttr);
                    }
                }
                String containingField = !openGroup.attribute ? this.getValueField(openGroup) : (openGroup.type == Group.Type.UIMA ? "_uimavals" : "_xmlvals");
                tagQuery = new ExtSpanQueryFieldChanger(tagQuery, containingField);
                tagQuery = this.addIdSupport(tagQuery);
                if (inclQuery == null) {
                    inclQuery = tagQuery;
                } else {
                    ExtSpanContainsQuery cQuery = new ExtSpanContainsQuery(tagQuery, inclQuery);
                    if (openGroup.attribute) {
                        cQuery.setAllSpans(false);
                    } else {
                        cQuery.setIncludeContainer(!openGroup.excludeContainer);
                    }
                    tagQuery = cQuery.optimize(false);
                    if (cQuery.isIncludeContainer()) {
                        tagQuery = this.addIdSupport(tagQuery);
                    }
                }
                inclQuery = tagQuery;
            }
            this.trimToSize(inclQueries, openGroup.inclQueryStart);
            this.trimToSize(fragments, openGroup.fragmentStart);
            this.trimToSize(exclQueries, openGroup.exclQueryStart);
            QueryFragment fragment = fragments.getLast();
            fragment.setExclusive(openGroup.queryList != inclQueries);
            fragment.setOptional(openGroup.optional);
            fragment.setInGroup(true);
            if (groupFragments.length != 0) {
                fragment.setChildren(groupFragments);
            }
            openGroup.queryList.add(inclQuery);
        }

        private ExtSpanUtils.ExtSpanQueryAdapter addIdSupport(ExtSpanQuery tagQuery) {
            return new ExtSpanUtils.ExtSpanQueryAdapter(tagQuery, TagExtSpans.class);
        }

        private ExtSpanQuery addFarQuery(ExtSpanQuery inclQuery, List<ExtSpanQuery> exclQueries, int start, int slopLength) {
            if (exclQueries.size() != start) {
                if (inclQuery == null) {
                    throw new IndexOutOfBoundsException("Can't have all exclusive queries");
                }
                ExtSpanQuery[] clauses = this.extract(exclQueries, start, ExtSpanQuery.class);
                ExtSpanQuery exclQuery = new ExtSpanOrQuery(clauses).optimize(false);
                int slop = clauses.length == 0 ? 0 : slopLength;
                inclQuery = new ExtSpanFarQuery(inclQuery, exclQuery, slop).optimize(false);
            }
            return inclQuery;
        }

        private <E> E[] extract(List<E> list, int start, Class<? extends E> clazz) {
            Object[] result = (Object[])Array.newInstance(clazz, list.size() - start);
            for (int i = 0; i < result.length; ++i) {
                result[i] = list.get(start + i);
            }
            return result;
        }

        private void trimToSize(List<?> list, int size) {
            while (list.size() > size) {
                list.remove(list.size() - 1);
            }
        }

        private void addFragmentLookup(ExtSpanQuery query, QueryFragment fragment) {
            this.getFragmentList(query).add(fragment);
            for (int i = 0; i < query.numIncludedClauses(); ++i) {
                this.addFragmentLookup(query.includedClause(i), fragment);
            }
        }

        private void addFragmentLookup(ExtSpanQuery query, QueryFragment[] fragments, int[] fragmentIndeces, int off, int len) {
            int i;
            List<QueryFragment> fragmentList = this.getFragmentList(query);
            for (i = off; i < off + len; ++i) {
                fragmentList.add(fragments[fragmentIndeces[i]]);
            }
            for (i = 0; i < query.numIncludedClauses(); ++i) {
                this.addFragmentLookup(query.includedClause(i), fragments, fragmentIndeces, off, len);
            }
        }

        private List<QueryFragment> getFragmentList(ExtSpanQuery query) {
            List<QueryFragment> fragmentList = this.fragmentLookup.get((Object)query);
            if (fragmentList == null) {
                fragmentList = new LinkedList<QueryFragment>();
                this.fragmentLookup.put(query, fragmentList);
            }
            return fragmentList;
        }

        static class Group {
            String name;
            List<ExtSpanQuery> queryList;
            List<ExtSpanQuery> inclAttributes;
            List<ExtSpanQuery> exclAttributes;
            int notQueryStart;
            int exclQueryStart;
            int inclQueryStart;
            int fragmentStart;
            boolean excludeContainer;
            boolean closing;
            boolean optional;
            boolean attribute;
            Type type;

            Group() {
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Type {
                UIMA,
                GROUPING,
                XML,
                PHRASE;

            }
        }
    }

    public static class TextQuery
    extends SupaQueryImpl {
        private static final long serialVersionUID = -8644914099079989114L;
        private int maxLocalSlop = 20;
        private int minFarLocalSlop = 5;
        private boolean descriptionsLoaded = false;

        public TextQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
        }

        public int getMaxLocalSlop() {
            return this.maxLocalSlop;
        }

        public void setMaxLocalSlop(int maxLocalSlop) {
            this.maxLocalSlop = maxLocalSlop;
        }

        public int getMinFarLocalSlop() {
            return this.minFarLocalSlop;
        }

        public void setMinFarLocalSlop(int minFarLocalSlop) {
            this.minFarLocalSlop = minFarLocalSlop;
        }

        public boolean areDescriptionsLoaded() {
            return this.descriptionsLoaded;
        }

        public void setDescriptionsLoaded(boolean loadDescriptions) {
            this.descriptionsLoaded = loadDescriptions;
        }
    }
}

