/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.synonym.index.SynonymIndexSearcher;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.text.TextUtils;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.tokenizers.RuntimeDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import com.ibm.supa.tokenizers.TokenizationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpanTermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder {
    SearchWrapper wrapper;
    QueryCreationHandler handler;
    NormalizedStringBufferType2 normalizer;
    RuntimeDelegateTokenizer tokenizer;
    TokenizationParams tokParams;
    SynonymIndexSearcher synSearcher;
    WorkCollections synCollections;

    public QueryBuilder(SearchWrapper wrapper, QueryCreationHandler handler) {
        this.wrapper = wrapper;
        this.handler = handler;
        this.normalizer = new NormalizedStringBufferType2();
        String collectionId = wrapper.getCollectionId();
        AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig(collectionId);
        this.tokenizer = config.getTokenizer();
        this.tokParams = new TokenizationParams(false, collectionId, null, null, null, null);
        this.synCollections = new WorkCollections();
    }

    public ExtSpanQuery buildQuery(WorkCollections workCollections, String field, String tokenText, boolean tokenize, boolean regular, boolean lemma, boolean subWords, boolean syns) throws SiapiException {
        WorkCollections wc = workCollections;
        wc.regularTokens.clear();
        wc.lemmaTokens.clear();
        wc.subTokens.clear();
        tokenText = ((Object)TextUtils.slashUnescape(tokenText)).toString();
        if (tokenize) {
            List<TToken> tokens = this.tokenize(tokenText);
            for (TToken token : tokens) {
                String text = this.normalize(token);
                if (TokenizationUtils.isSubwordForm(text)) {
                    wc.subTokens.add(TokenizationUtils.makeNonSubWordForm(text));
                    continue;
                }
                if (TokenizationUtils.isLemma(text)) {
                    wc.lemmaTokens.add(text);
                    continue;
                }
                wc.regularTokens.add(text);
            }
        } else {
            wc.regularTokens.add(tokenText);
        }
        ArrayList<ExtSpanQuery> clauses = new ArrayList<ExtSpanQuery>(3);
        if ((regular || subWords) && !wc.regularTokens.isEmpty()) {
            ArrayList<ExtSpanQuery> regClauses = new ArrayList<ExtSpanQuery>(wc.regularTokens.size());
            for (String text : wc.regularTokens) {
                regClauses.add(this.buildTokenQuery(wc.clauseList, field, text, regular, subWords, syns));
            }
            ExtSpanQuery regQuery = QueryBuilder.buildOrQuery(regClauses);
            this.handler.handleRegularQueryCreated(regQuery);
            clauses.add(regQuery);
        }
        if ((lemma || subWords) && !wc.lemmaTokens.isEmpty()) {
            ArrayList<ExtSpanQuery> lemClauses = new ArrayList<ExtSpanQuery>(wc.lemmaTokens.size());
            for (String text : wc.lemmaTokens) {
                String nonLemma = TokenizationUtils.makeNonLemma(text);
                if (wc.regularTokens.contains(nonLemma)) continue;
                lemClauses.add(this.buildTokenQuery(wc.clauseList, field, text, lemma, subWords, syns));
            }
            ExtSpanQuery lemQuery = QueryBuilder.buildOrQuery(lemClauses);
            this.handler.handleLemmaQueryCreated(lemQuery);
            clauses.add(lemQuery);
        }
        if (subWords && !wc.subTokens.isEmpty()) {
            ExtSpanQuery[] subQueries = new ExtSpanQuery[wc.subTokens.size()];
            int i = 0;
            for (String text : wc.subTokens) {
                List<TToken> tokens = this.tokenize(text);
                for (TToken token : tokens) {
                    text = this.normalize(token);
                    String regText = TokenizationUtils.makeRegularForm(text);
                    if (!wc.subsubTokens.add(regText)) continue;
                    wc.subClauses.add(this.buildTokenQuery(wc.clauseList, field, text, false, true, syns));
                }
                wc.subsubTokens.clear();
                subQueries[i] = QueryBuilder.buildOrQuery(wc.subClauses, true);
                ++i;
            }
            ExtSpanQuery subQuery = new ExtSpanAllNearQuery(subQueries, 0, false).optimize(false);
            this.handler.handleSubwordQueryCreated(subQuery, subQueries);
            clauses.add(subQuery);
        }
        return QueryBuilder.buildOrQuery(clauses);
    }

    public List<TToken> tokenize(String tokenText) {
        TToken tok = TTokenUtils.newToken((CharSequence)tokenText, TToken.Type.ORIGINAL);
        return this.tokenizer.tokenize(this.tokParams, tok);
    }

    public String normalize(CharSequence text) {
        return this.normalize(text, true);
    }

    public String normalize(CharSequence text, boolean slashUnescape) {
        String result = this.normalizer.append(text).toString();
        this.normalizer.reset();
        if (slashUnescape) {
            result = ((Object)TextUtils.slashUnescape(result)).toString();
        }
        return result;
    }

    public static ExtSpanQuery buildOrQuery(List<ExtSpanQuery> clauses) {
        return QueryBuilder.buildOrQuery(clauses, false);
    }

    public static ExtSpanQuery buildOrQuery(List<ExtSpanQuery> clauses, boolean clearClauses) {
        ExtSpanQuery[] clausesArray = clauses.toArray(new ExtSpanQuery[clauses.size()]);
        if (clearClauses) {
            clauses.clear();
        }
        return new ExtSpanOrQuery(clausesArray).optimize(false);
    }

    public boolean initSynSearcher() throws SiapiException {
        IndexSearcher searcher;
        if (this.synSearcher == null && (searcher = this.wrapper.getIndexSearcher(IndexDescriptor.IndexType.Synonym)) != null) {
            this.synSearcher = new SynonymIndexSearcher(searcher);
            return true;
        }
        return this.synSearcher != null;
    }

    public ExtSpanQuery buildTokenQuery(List<ExtSpanQuery> clauseList, String field, String text, boolean normalForms, boolean subWords, boolean syns) throws SiapiException {
        String[] synonyms;
        clauseList.clear();
        assert (normalForms || subWords);
        String regularText = TokenizationUtils.makeRegularForm(text);
        if (normalForms) {
            if (!TokenizationUtils.isLemma(text)) {
                clauseList.add(this.buildTermQuery(field, regularText));
            }
            clauseList.add(this.handleLemmaQuery(this.buildTermQuery(field, TokenizationUtils.makeIndexedLemma(regularText))));
        }
        if (subWords) {
            clauseList.add(this.buildSubQuery(field, regularText));
        }
        if (syns && this.initSynSearcher() && (synonyms = this.synSearcher.getSynonyms(regularText)) != null && synonyms.length > 0) {
            clauseList.add(this.buildSynQuery(field, synonyms, normalForms, normalForms, subWords));
        }
        return QueryBuilder.buildOrQuery(clauseList, true);
    }

    public ExtSpanQuery buildSynQuery(String field, String[] synonyms, boolean regular, boolean lemma, boolean subWords) throws SiapiException {
        LinkedList<ExtSpanQuery> clauses = new LinkedList<ExtSpanQuery>();
        LinkedList<ExtSpanQuery> subClauses = new LinkedList<ExtSpanQuery>();
        for (String syn : synonyms) {
            StringTokenizer sTok = new StringTokenizer(syn);
            while (sTok.hasMoreTokens()) {
                String token = this.normalize(sTok.nextToken());
                subClauses.add(this.buildQuery(this.synCollections, field, token, true, regular, lemma, subWords, false));
            }
            ExtSpanQuery[] nearClauses = subClauses.toArray(new ExtSpanQuery[subClauses.size()]);
            subClauses.clear();
            ExtSpanQuery nearQuery = new ExtSpanAllNearQuery(nearClauses, 1, false).optimize(false);
            this.handler.handleInternalMultiSynQueryCreated(nearQuery, nearClauses);
            clauses.add(nearQuery);
        }
        ExtSpanQuery synQuery = QueryBuilder.buildOrQuery(clauses);
        this.handler.handleSynQueryCreated(synQuery);
        return synQuery;
    }

    public ExtSpanQuery buildSubQuery(String field, String text) {
        return new ExtSpanOrQuery(new ExtSpanQuery[]{this.buildTermQuery(field, TokenizationUtils.makeIndexedSubWord(text)), this.handleLemmaQuery(this.buildTermQuery(field, TokenizationUtils.makeIndexedSubWordLemma(text)))}).optimize(false);
    }

    public ExtSpanQuery buildTermQuery(String field, String text) {
        return new ExtSpanTermQuery(new Term(field, text));
    }

    private ExtSpanQuery handleLemmaQuery(ExtSpanQuery query) {
        this.handler.handleLemmaQueryCreated(query);
        return query;
    }

    public SynonymIndexSearcher getSynSearcher() {
        return this.synSearcher;
    }

    public static class WorkCollections {
        List<ExtSpanQuery> clauseList = new ArrayList<ExtSpanQuery>();
        HashSet<String> regularTokens = new HashSet();
        HashSet<String> lemmaTokens = new HashSet();
        HashSet<String> subTokens = new HashSet();
        List<ExtSpanQuery> subClauses = new LinkedList<ExtSpanQuery>();
        HashSet<String> subsubTokens = new HashSet();
    }

    public static class QueryCreationHandler {
        public void handleRegularQueryCreated(ExtSpanQuery query) {
        }

        public void handleLemmaQueryCreated(ExtSpanQuery query) {
        }

        public void handleSubwordQueryCreated(ExtSpanQuery query, ExtSpanQuery[] clauses) {
        }

        public void handleInternalMultiSynQueryCreated(ExtSpanQuery query, ExtSpanQuery[] clauses) {
        }

        public void handleSynQueryCreated(ExtSpanQuery query) {
        }
    }
}

