/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.search.AssociatedQueryState;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchSnapshotImpl;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.queries.QueryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipedQueryExecutor2
extends BaseQueryExecutor {
    private QueryExecutor docLevelExecutor;
    private QueryExecutor resultExecutor;
    private int maxDocLevelResults = -1;
    private volatile SearchSnapshot lastResultSnapshot;
    private volatile SearchSnapshot lastDocSnapshot;
    private volatile String lastResultQueryText;
    private volatile String lastDocQueryText;

    public QueryExecutor getDocLevelExecutor() {
        return this.docLevelExecutor;
    }

    public void setDocLevelExecutor(QueryExecutor docLevelExecutor) {
        this.docLevelExecutor = docLevelExecutor;
    }

    public QueryExecutor getResultExecutor() {
        return this.resultExecutor;
    }

    public void setResultExecutor(QueryExecutor resultExecutor) {
        this.resultExecutor = resultExecutor;
    }

    public int getMaxDocLevelResults() {
        return this.maxDocLevelResults;
    }

    public void setMaxDocLevelResults(int maxDocLevelResults) {
        this.maxDocLevelResults = maxDocLevelResults;
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new SupaQueryImpl(collectionIds);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        SupaQuery result = this.subCreateQuery(collectionIds);
        result.setText(queryString);
        return result;
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return SupaQueryImpl.class;
    }

    private class Executor
    extends BaseQueryExecutor.BaseExecutor {
        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ResultSet subExecute() throws SiapiException {
            SearchSnapshotImpl snapshot;
            String prevDocQueryText;
            String prevResultQueryText;
            SearchSnapshot prevDocSnapshot;
            SearchSnapshot prevResultSnapshot;
            PipedQueryExecutor2 pipedQueryExecutor2 = PipedQueryExecutor2.this;
            synchronized (pipedQueryExecutor2) {
                prevResultSnapshot = PipedQueryExecutor2.this.lastResultSnapshot;
                prevDocSnapshot = PipedQueryExecutor2.this.lastDocSnapshot;
                prevResultQueryText = PipedQueryExecutor2.this.lastResultQueryText;
                prevDocQueryText = PipedQueryExecutor2.this.lastDocQueryText;
            }
            String[] queriedFields = new String[]{};
            if (prevDocSnapshot == null || this.query.getText() == null || !this.query.getText().equals(prevDocQueryText)) {
                SupaQuery subQuery = QueryUtils.copy(this.query, PipedQueryExecutor2.this.docLevelExecutor);
                subQuery.setRequestedResultRange(1, 1);
                if (subQuery.getSearchSnapshot() == null) {
                    snapshot = new SearchSnapshotImpl(subQuery, PipedQueryExecutor2.this.docLevelExecutor, AssociatedQueryState.NONE, null);
                    snapshot.setMaxResultsPerCollection(PipedQueryExecutor2.this.maxDocLevelResults);
                    subQuery.setSearchSnapshot(snapshot);
                } else {
                    subQuery.getSearchSnapshot().setMaxResultsPerCollection(PipedQueryExecutor2.this.maxDocLevelResults);
                }
                ResultSet docResults = PipedQueryExecutor2.this.docLevelExecutor.execute(subQuery, null, this.wrappers);
                prevDocSnapshot = subQuery.getSearchSnapshot();
                PipedQueryExecutor2 pipedQueryExecutor22 = PipedQueryExecutor2.this;
                synchronized (pipedQueryExecutor22) {
                    PipedQueryExecutor2.this.lastDocSnapshot = prevDocSnapshot;
                    PipedQueryExecutor2.this.lastDocQueryText = this.query.getText();
                }
                if (docResults.getEstimatedNumberOfResults() <= 0) {
                    return new ResultSetImpl(null, null, null, null, null, docResults.getQueryEvaluationTime(), 0, 0, queriedFields, docResults.isEvaluationTruncated());
                }
            }
            SupaQuery resQuery = QueryUtils.copy(this.query, PipedQueryExecutor2.this.resultExecutor);
            if (prevResultSnapshot == null || this.query.getText() == null || !this.query.getText().equals(prevResultQueryText)) {
                snapshot = new SearchSnapshotImpl(resQuery, PipedQueryExecutor2.this.resultExecutor, AssociatedQueryState.RETURNED, prevDocSnapshot);
                snapshot.setDecayWeighting(0.2);
                resQuery.setSearchSnapshot(snapshot);
            } else {
                resQuery.setSearchSnapshot(prevResultSnapshot);
            }
            ResultSet result = PipedQueryExecutor2.this.resultExecutor.execute(resQuery, this.processor, this.wrappers);
            long evalTime = result.getQueryEvaluationTime();
            boolean truncated = result.isEvaluationTruncated();
            PipedQueryExecutor2 pipedQueryExecutor23 = PipedQueryExecutor2.this;
            synchronized (pipedQueryExecutor23) {
                PipedQueryExecutor2.this.lastResultSnapshot = resQuery.getSearchSnapshot();
                PipedQueryExecutor2.this.lastResultQueryText = this.query.getText();
            }
            if (result instanceof ResultSetImpl) {
                ResultSetImpl resultImpl = (ResultSetImpl)result;
                return new ResultSetImpl(result.getResults(), result.getPredefinedResults(), resultImpl.getFacets(), result.getSynonymExpansions(), result.getSpellCorrections(), evalTime, result.getAvailableNumberOfResults(), result.getEstimatedNumberOfResults(), resultImpl.getQueriedFields(), truncated);
            }
            return new ResultSetImpl(result.getResults(), result.getPredefinedResults(), null, result.getSynonymExpansions(), result.getSpellCorrections(), evalTime, result.getAvailableNumberOfResults(), result.getEstimatedNumberOfResults(), queriedFields, truncated);
        }
    }
}

