/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.search.AssociatedQueryState;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchSnapshotImpl;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.queries.QueryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipedQueryExecutor
extends BaseQueryExecutor {
    private QueryExecutor preExecutor;
    private QueryExecutor resultExecutor;
    private int maxResultsPerCollection = -1;
    private volatile SearchSnapshot lastSnapshot;
    private volatile String lastQueryText;

    public QueryExecutor getPreExecutor() {
        return this.preExecutor;
    }

    public void setPreExecutor(QueryExecutor preExecutor) {
        this.preExecutor = preExecutor;
    }

    public QueryExecutor getResultExecutor() {
        return this.resultExecutor;
    }

    public void setResultExecutor(QueryExecutor resultExecutor) {
        this.resultExecutor = resultExecutor;
    }

    public int getMaxResultsPerCollection() {
        return this.maxResultsPerCollection;
    }

    public void setMaxResultsPerCollection(int maxResultsPerCollection) {
        this.maxResultsPerCollection = maxResultsPerCollection;
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new SupaQueryImpl(collectionIds);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        SupaQuery result = this.subCreateQuery(collectionIds);
        result.setText(queryString);
        return result;
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return SupaQueryImpl.class;
    }

    private class Executor
    extends BaseQueryExecutor.BaseExecutor {
        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ResultSet subExecute() throws SiapiException {
            SearchSnapshotImpl snapshot;
            String prevQueryText;
            SearchSnapshot prevSnapshot;
            PipedQueryExecutor pipedQueryExecutor = PipedQueryExecutor.this;
            synchronized (pipedQueryExecutor) {
                prevSnapshot = PipedQueryExecutor.this.lastSnapshot;
                prevQueryText = PipedQueryExecutor.this.lastQueryText;
            }
            String[] queriedFields = new String[]{};
            if (prevSnapshot == null || this.query.getText() == null || !this.query.getText().equals(prevQueryText)) {
                SupaQuery subQuery = QueryUtils.copy(this.query, PipedQueryExecutor.this.preExecutor);
                subQuery.setRequestedResultRange(1, 1);
                if (subQuery.getSearchSnapshot() == null) {
                    snapshot = new SearchSnapshotImpl(subQuery, PipedQueryExecutor.this.preExecutor, AssociatedQueryState.NONE, null);
                    snapshot.setMaxResultsPerCollection(PipedQueryExecutor.this.maxResultsPerCollection);
                    subQuery.setSearchSnapshot(snapshot);
                } else {
                    subQuery.getSearchSnapshot().setMaxResultsPerCollection(PipedQueryExecutor.this.maxResultsPerCollection);
                }
                ResultSet docResults = PipedQueryExecutor.this.preExecutor.execute(subQuery, null, this.wrappers);
                prevSnapshot = subQuery.getSearchSnapshot();
                PipedQueryExecutor pipedQueryExecutor2 = PipedQueryExecutor.this;
                synchronized (pipedQueryExecutor2) {
                    PipedQueryExecutor.this.lastSnapshot = prevSnapshot;
                    PipedQueryExecutor.this.lastQueryText = this.query.getText();
                }
                if (docResults.getEstimatedNumberOfResults() <= 0) {
                    return new ResultSetImpl(null, null, null, null, null, docResults.getQueryEvaluationTime(), 0, 0, queriedFields, docResults.isEvaluationTruncated());
                }
            }
            SupaQuery resQuery = QueryUtils.copy(this.query, PipedQueryExecutor.this.resultExecutor);
            snapshot = new SearchSnapshotImpl(resQuery, PipedQueryExecutor.this.resultExecutor, AssociatedQueryState.RETURNED, prevSnapshot);
            snapshot.setDecayWeighting(0.2);
            resQuery.setSearchSnapshot(snapshot);
            ResultSet result = PipedQueryExecutor.this.resultExecutor.execute(resQuery, this.processor, this.wrappers);
            long evalTime = result.getQueryEvaluationTime();
            boolean truncated = result.isEvaluationTruncated();
            SearchSnapshot searchSnapshot = this.query.getSearchSnapshot();
            if (searchSnapshot != null) {
                for (SearchWrapper wrapper : this.wrappers) {
                    SearchSnapshot.Results resResults = snapshot.getResults(wrapper.getCollectionId());
                    if (resResults == null) continue;
                    searchSnapshot.setResults(wrapper.getCollectionId(), resResults.getSpanResults(), wrapper.getIndexVersion());
                }
            }
            if (result instanceof ResultSetImpl) {
                ResultSetImpl resultImpl = (ResultSetImpl)result;
                return new ResultSetImpl(result.getResults(), result.getPredefinedResults(), resultImpl.getFacets(), result.getSynonymExpansions(), result.getSpellCorrections(), evalTime, result.getAvailableNumberOfResults(), result.getEstimatedNumberOfResults(), resultImpl.getQueriedFields(), truncated);
            }
            return new ResultSetImpl(result.getResults(), result.getPredefinedResults(), null, result.getSynonymExpansions(), result.getSpellCorrections(), evalTime, result.getAvailableNumberOfResults(), result.getEstimatedNumberOfResults(), queriedFields, truncated);
        }
    }
}

