/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.TextQueryExecutor;
import com.ibm.supa.search.spans.extended.AlignedDocExtSpanQuery;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFilter;
import com.ibm.supa.search.spans.extended.ExtSpanWildcardQuery;
import com.ibm.supa.search.spans.extended.MissingClauseExtSpanScorer;
import com.ibm.supa.search.spans.extended.MultiExtSpanScorer;
import com.ibm.supa.search.spans.extended.QueryOrderScorer;
import com.ibm.supa.search.spans.extended.SlopExtSpanScorer;
import com.ibm.supa.search.spans.extended.SpanLengthExtSpanScorer;
import com.ibm.supa.search.spans.extended.tags.ExtSpanTermTagQuery;
import java.io.IOException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.ExtSpanFarQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionQueryExecutor
extends TextQueryExecutor {
    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new FunctionQuery(collectionIds);
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return FunctionQuery.class;
    }

    static class Executor
    extends TextQueryExecutor.Executor {
        static final String FUNCTION_ANNOT = "function";
        static final String FUNCTION_CONVENTION_ANNOT = "functionconvention";
        static final String COMMENT_ANNOT = "comment";
        final FunctionQuery fQuery;
        final ResultsProcessor processor;
        final Map<ExtSpanQuery, Set<Integer>> combinedPositionsLookup;
        final Set<Integer> requiredQueryPositions;
        QueryFragment[] fragments;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
            this.fQuery = (FunctionQuery)FunctionQuery.class.cast(query);
            this.processor = processor;
            this.combinedPositionsLookup = new IdentityHashMap<ExtSpanQuery, Set<Integer>>();
            this.requiredQueryPositions = new HashSet<Integer>();
        }

        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            this.saveSameDocExtSpans = false;
            this.createConstrainingDocQuery = true;
            this.forceOptionals = true;
            this.termsAreOptional = true;
            this.partialsAllowed = false;
            this.enableAutoDocLevelQuerying = false;
            this.fQuery.setMaxLocalSlop(2);
            ExtSpanQuery narrowBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.partialsAllowed = true;
            this.fQuery.setMaxLocalSlop(15);
            ExtSpanQuery wideBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.forceOptionals = false;
            this.partialsAllowed = true;
            super.buildRootQuery(wrapper);
            this.extractRequiredQueryPositions();
            ExtSpanQuery funcQuery = this.buildFunctionQuery(narrowBaseQuery);
            ExtSpanQuery fcQuery = this.buildFunctionConventionQuery(wideBaseQuery);
            ExtSpanQuery noFcCommentQuery = this.buildNoFcCommentQuery(wideBaseQuery);
            int numClauses = Math.max(1, this.numInclusiveClauses);
            this.enableScoringAdjustments = true;
            super.addWeighting(funcQuery, 1.0 / (double)numClauses);
            super.addWeighting(fcQuery, 0.4 / (double)numClauses);
            super.addWeighting(noFcCommentQuery, 0.2 / (double)numClauses);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{funcQuery, fcQuery, noFcCommentQuery};
            boolean[] optionals = new boolean[]{true, true, true};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, -1, 0, true);
            nQuery.setAllowPartialResults(true);
            super.addScorer(nQuery, new MissingClauseExtSpanScorer(nQuery, false, 15.0, 7.0, 3.0));
            return new ExtSpanQueryFilter(nQuery, new ExtSpansFilter.StatelessFilter(){
                HashSet<Integer> positionsLeft = new HashSet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean accept(ExtSpans extSpans) {
                    try {
                        this.positionsLeft.addAll(Executor.this.requiredQueryPositions);
                        boolean bl = this.subTreeContainsRequiredPositions(extSpans, extSpans.query());
                        return bl;
                    }
                    finally {
                        this.positionsLeft.clear();
                    }
                }

                private boolean subTreeContainsRequiredPositions(ExtSpans extSpans, ExtSpanQuery ancestorQuery) {
                    if (extSpans.query() instanceof AlignedDocExtSpanQuery) {
                        return false;
                    }
                    int numSubExtSpans = extSpans.numSubExtSpans();
                    if (numSubExtSpans == 0) {
                        Set<Integer> positions;
                        ExtSpanQuery lookupQuery = extSpans.query();
                        if (ancestorQuery instanceof ExtSpanWildcardQuery) {
                            lookupQuery = ancestorQuery;
                        }
                        if ((positions = Executor.this.combinedPositionsLookup.get((Object)lookupQuery)) != null) {
                            this.positionsLeft.removeAll(positions);
                        }
                        return this.positionsLeft.isEmpty();
                    }
                    for (int i = 0; i < numSubExtSpans; ++i) {
                        ExtSpanQuery passQuery = extSpans.query();
                        if (ancestorQuery instanceof ExtSpanWildcardQuery) {
                            passQuery = ancestorQuery;
                        }
                        if (!this.subTreeContainsRequiredPositions(extSpans.subExtSpan(i), passQuery)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }

        private void extractQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                Set<Integer> positions = this.combinedPositionsLookup.get((Object)entry.getKey());
                if (positions == null) {
                    positions = new HashSet<Integer>();
                    this.combinedPositionsLookup.put(entry.getKey(), positions);
                }
                for (QueryFragment fragment : entry.getValue()) {
                    positions.add(fragment.getQueryPosition());
                }
            }
        }

        private void extractRequiredQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                for (QueryFragment fragment : entry.getValue()) {
                    if (fragment.isOptional()) continue;
                    this.requiredQueryPositions.add(fragment.getQueryPosition());
                }
            }
        }

        private ExtSpanQuery buildAnnotQuery(String annotName) {
            return this.buildAnnotQuery(annotName, null, false, false);
        }

        private ExtSpanQuery buildAnnotQuery(String annotName, ExtSpanQuery query, boolean queryIsContainer, boolean includeContainer) {
            String field = "_uimatags";
            ExtSpanQuery tagQuery = new ExtSpanTermTagQuery(new Term(field, annotName));
            tagQuery = new ExtSpanQueryFieldChanger(tagQuery, "_plain");
            if (query == null) {
                return tagQuery;
            }
            ExtSpanContainsQuery cQuery = queryIsContainer ? new ExtSpanContainsQuery(query, tagQuery) : new ExtSpanContainsQuery(tagQuery, query);
            cQuery.setIncludeContainer(includeContainer);
            cQuery.setForceAllSpans(true);
            tagQuery = cQuery.optimize(false);
            return tagQuery;
        }

        private ExtSpanQuery buildFunctionQuery(ExtSpanQuery query) {
            return this.buildAnnotQuery(FUNCTION_ANNOT, query, false, true);
        }

        private ExtSpanQuery buildFunctionConventionQuery(ExtSpanQuery query) {
            return this.makeCommentQuery(this.buildAnnotQuery(FUNCTION_CONVENTION_ANNOT, query, false, true));
        }

        private ExtSpanQuery buildNoFcCommentQuery(ExtSpanQuery query) {
            return this.makeCommentQuery(new ExtSpanFarQuery(query, this.buildAnnotQuery(FUNCTION_CONVENTION_ANNOT), 0).optimize(false));
        }

        private ExtSpanQuery makeCommentQuery(ExtSpanQuery query) {
            return this.makeCommentQuery(query, false, false);
        }

        private ExtSpanQuery makeCommentQuery(ExtSpanQuery query, boolean isOptionalComment, boolean includesContainer) {
            query = query == null ? this.buildAnnotQuery(COMMENT_ANNOT) : this.buildAnnotQuery(COMMENT_ANNOT, query, false, true);
            this.scorer.addScorer(query, new SpanLengthExtSpanScorer(0.001));
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{this.buildAnnotQuery(FUNCTION_ANNOT), query};
            boolean[] optionals = new boolean[]{false, isOptionalComment};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, this.fQuery.getAnnotationSlop(), false);
            nQuery.setAllowPartialResults(false);
            this.scorer.addScorer(nQuery, new MultiExtSpanScorer(new QueryOrderScorer(clauses, 3.0), new SlopExtSpanScorer(0.2)));
            return this.buildAnnotQuery(FUNCTION_ANNOT, nQuery, true, includesContainer);
        }
    }

    public static class FunctionQuery
    extends TextQueryExecutor.TextQuery {
        private static final long serialVersionUID = 2137229155242054525L;
        private int annotationSlop = 50;

        public FunctionQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
            super.setMaxLocalSlop(15);
        }

        public int getAnnotationSlop() {
            return this.annotationSlop;
        }

        public void setAnnotationSlop(int annotationSlop) {
            this.annotationSlop = annotationSlop;
        }
    }
}

