/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.search.summarizer.Summarizer;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.synonym.index.SynonymIndexSearcher;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAConstants;
import com.ibm.supa.common.text.TextUtils;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.docInfo.DocumentCache;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaWildcardQueryBuilder;
import com.ibm.supa.search.queries.QueryBuilder;
import com.ibm.supa.tokenizers.TokenizationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLevelQueryUtilities {
    private String[] simpleFields = new String[]{"dirname", "uri"};
    private HashMap<String, String> fieldMap;
    private SearchWrapper searchWrapper;
    private SynonymIndexSearcher synSearcher;
    private QueryBuilder builder;
    private final float termOriginalBoost = 10.0f;
    private final float termLemmaBoost = 7.0f;
    private final float termSubWordBoost = 4.0f;
    private final float termSubWordLemmaBoost = 2.0f;
    private final int slopForPhrase = 10;

    public DocLevelQueryUtilities(SearchWrapper searchWrapper) throws SiapiException {
        BooleanQuery.setMaxClauseCount((int)100000);
        this.builder = new QueryBuilder(searchWrapper, null);
        this.searchWrapper = searchWrapper;
        this.fieldMap = new HashMap();
        this.initSynSearcher(searchWrapper);
    }

    public boolean initSynSearcher(SearchWrapper wrapper) throws SiapiException {
        IndexSearcher searcher;
        if (this.synSearcher == null && (searcher = wrapper.getIndexSearcher(IndexDescriptor.IndexType.Synonym)) != null) {
            this.synSearcher = new SynonymIndexSearcher(searcher);
            return true;
        }
        return this.synSearcher != null;
    }

    public Query parseQuery(String userDocQueryString, String field) throws ExtendedException, SiapiException {
        return this.parseQuery(userDocQueryString, field, false, null);
    }

    public Query parseQuery(String userDocQueryString, String field, boolean isWithFieldGroupQuery, Map<String, Float> fieldsBoost) throws ExtendedException, SiapiException {
        this.fieldMap.clear();
        return this.parse(userDocQueryString, field, isWithFieldGroupQuery, fieldsBoost);
    }

    private Query parse(String userDocQueryString, String field, boolean addFieldGroupToQuery, Map<String, Float> fieldsBoost) throws ExtendedException, SiapiException {
        userDocQueryString = userDocQueryString.trim();
        ElementType curElement = null;
        char[] userQueryCharArr = userDocQueryString.toCharArray();
        BooleanQuery finalQuery = new BooleanQuery();
        boolean validQuery = this.checkParenthesisValidity(userQueryCharArr);
        if (!validQuery) {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        int elementFirstCharIndex = 0;
        int elementLastCharIndex = 0;
        ArrayList<QTermElement> synTermsSeq = new ArrayList<QTermElement>();
        int dependentSynSeqMaxPossibleLength = 1;
        boolean inSynSequence = false;
        while (elementFirstCharIndex < userDocQueryString.length() && (curElement = this.checkElementType(userQueryCharArr, elementFirstCharIndex)) != null) {
            String unStripedElementStr;
            if (curElement.equals((Object)ElementType.TERM)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.TERM, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                QTermElement te = new QTermElement(unStripedElementStr, field, 0);
                if (this.synSearcher != null) {
                    int candLength = this.synSearcher.identifyCandidate(this.builder.normalize(te.getBaseStr()));
                    if (candLength < 1) {
                        candLength = 1;
                    }
                    if (dependentSynSeqMaxPossibleLength == 1 && candLength == 1) {
                        inSynSequence = false;
                    }
                    if (dependentSynSeqMaxPossibleLength == 2 && candLength == 1) {
                        inSynSequence = true;
                    }
                    if ((dependentSynSeqMaxPossibleLength = Math.max(dependentSynSeqMaxPossibleLength - 1, candLength)) > 1) {
                        inSynSequence = true;
                    }
                }
                if (inSynSequence && !this.isASimpleField(field) && this.synSearcher != null && !te.isExcluded() && !te.isWildCard() && (te.termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS) || te.termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS))) {
                    if (dependentSynSeqMaxPossibleLength == 1) {
                        synTermsSeq.add(te);
                        this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                        dependentSynSeqMaxPossibleLength = 1;
                        inSynSequence = false;
                    } else {
                        synTermsSeq.add(te);
                    }
                } else {
                    this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                    dependentSynSeqMaxPossibleLength = 1;
                    inSynSequence = false;
                    Query termQuery = null;
                    termQuery = this.isASimpleField(field) ? this.makeASimpleTermsQuery(te.getBaseStr(), field, te.isWildCard()) : this.makeAnExtendedTermsQuery(te.getBaseStr(), field, te.termType, te.isWildCard(), false);
                    finalQuery.add(termQuery, te.getOccur());
                }
            } else if (curElement.equals((Object)ElementType.PHRASE)) {
                this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                dependentSynSeqMaxPossibleLength = 1;
                inSynSequence = false;
                elementLastCharIndex = this.findElementEndPos(ElementType.PHRASE, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                QPhraseElement pe = new QPhraseElement(unStripedElementStr, field, 0);
                Object phraseQuery = null;
                phraseQuery = this.isASimpleField(field) ? this.makeASimpleTermsQuery(pe.getBaseStr(), field, pe.isWildCard()) : this.buildPhraseQuery(pe.getBaseStr(), field);
                finalQuery.add((Query)phraseQuery, pe.getOccur());
            } else if (curElement.equals((Object)ElementType.GROUP)) {
                Float boost;
                String groupField;
                this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                dependentSynSeqMaxPossibleLength = 1;
                inSynSequence = false;
                elementLastCharIndex = this.findElementEndPos(ElementType.GROUP, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                char excludeSign = unStripedElementStr.trim().charAt(0);
                char optionSign = unStripedElementStr.charAt(unStripedElementStr.length() - 1);
                BooleanClause.Occur occur = BooleanClause.Occur.MUST;
                if (optionSign == '?') {
                    occur = BooleanClause.Occur.SHOULD;
                }
                if (excludeSign == '-' || excludeSign == '!') {
                    occur = BooleanClause.Occur.MUST_NOT;
                }
                String subUserQuery = this.stripGroup(unStripedElementStr);
                String origGroupField = groupField = this.getFieldInGroup(unStripedElementStr);
                if (groupField == null) {
                    groupField = field;
                }
                Query groupQuery = this.parse(subUserQuery, groupField, false, null);
                if (fieldsBoost != null && origGroupField != null && (boost = fieldsBoost.get('/' + groupField)) != null) {
                    groupQuery.setBoost(boost.floatValue());
                }
                finalQuery.add(groupQuery, occur);
            } else if (curElement.equals((Object)ElementType.SEMANIC_GORUP)) {
                this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                dependentSynSeqMaxPossibleLength = 1;
                inSynSequence = false;
                elementLastCharIndex = this.findElementEndPos(ElementType.SEMANIC_GORUP, userQueryCharArr, elementFirstCharIndex);
            } else if (curElement.equals((Object)ElementType.XML_GROUP)) {
                this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                dependentSynSeqMaxPossibleLength = 1;
                inSynSequence = false;
                elementLastCharIndex = this.findElementEndPos(ElementType.XML_GROUP, userQueryCharArr, elementFirstCharIndex);
            } else if (curElement.equals((Object)ElementType.FIELD_GROUP)) {
                this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
                dependentSynSeqMaxPossibleLength = 1;
                inSynSequence = false;
                elementLastCharIndex = this.findElementEndPos(ElementType.FIELD_GROUP, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                FieldQueryMap fieldQueryMap = this.addFieldMap(unStripedElementStr);
                if (addFieldGroupToQuery && fieldsBoost != null && fieldQueryMap != null) {
                    Query groupQuery = this.parse(fieldQueryMap.getQuery(), field, false, null);
                    Float boost = fieldsBoost.get(fieldQueryMap.getField());
                    if (boost != null) {
                        groupQuery.setBoost(boost.floatValue());
                    }
                    finalQuery.add(groupQuery, BooleanClause.Occur.SHOULD);
                }
            }
            elementFirstCharIndex = elementLastCharIndex + 1;
        }
        this.dependentSynSequenceTerminated(synTermsSeq, finalQuery, field);
        return finalQuery;
    }

    private void dependentSynSequenceTerminated(List<QTermElement> synTermsSeq, BooleanQuery finalQuery, String field) throws SiapiException, ExtendedException {
        if (synTermsSeq.size() == 1) {
            Query termQuery = null;
            termQuery = this.isASimpleField(field) ? this.makeASimpleTermsQuery(synTermsSeq.get(0).getBaseStr(), field, synTermsSeq.get(0).isWildCard()) : this.makeAnExtendedTermsQuery(synTermsSeq.get(0).getBaseStr(), field, synTermsSeq.get(0).termType, synTermsSeq.get(0).isWildCard(), false);
            finalQuery.add(termQuery, synTermsSeq.get(0).getOccur());
        } else if (this.synSearcher != null && synTermsSeq.size() > 1) {
            QTermElement[] synTermsSeqArr = synTermsSeq.toArray(new QTermElement[0]);
            boolean allOptionals = true;
            for (QTermElement curTermElement : synTermsSeqArr) {
                if (curTermElement.isOptional()) continue;
                allOptionals = false;
            }
            if (allOptionals) {
                finalQuery.add(this.handleDependentMultipleSynonyms(synTermsSeqArr, field), BooleanClause.Occur.SHOULD);
            } else {
                finalQuery.add(this.handleDependentMultipleSynonyms(synTermsSeqArr, field), BooleanClause.Occur.MUST);
            }
            synTermsSeq.clear();
        }
    }

    private Query handleDependentMultipleSynonyms(QTermElement[] synTermsSeqArr, String field) throws SiapiException, ExtendedException {
        BooleanQuery finalQ = new BooleanQuery();
        StringBuilder sBuf = new StringBuilder();
        sBuf.append(synTermsSeqArr[0].getBaseStr());
        int candLength = this.synSearcher.identifyCandidate(this.builder.normalize(synTermsSeqArr[0].getBaseStr()));
        if (candLength < 1) {
            candLength = 1;
        }
        candLength = Math.min(candLength, synTermsSeqArr.length);
        BooleanQuery[] boolQs = new BooleanQuery[candLength];
        for (int i = 0; i < candLength; ++i) {
            String[] syns = this.synSearcher.getSynonyms(this.builder.normalize(sBuf.toString()));
            boolQs[i] = new BooleanQuery();
            if (synTermsSeqArr[i].termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS)) {
                this.handleSynonyms(syns, boolQs[i], field, QueryElement.Type.TERM_FILTER_SYNONYMS);
            } else if (synTermsSeqArr[i].termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS)) {
                this.handleSynonyms(syns, boolQs[i], field, QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS);
            }
            BooleanQuery termQuery = new BooleanQuery();
            for (int j = 0; j <= i; ++j) {
                termQuery.add(this.makeAnExtendedTermsQuery(synTermsSeqArr[j].getBaseStr(), field, synTermsSeqArr[j].termType, false, false), synTermsSeqArr[j].getOccur());
            }
            boolQs[i].add((Query)termQuery, BooleanClause.Occur.SHOULD);
            if (synTermsSeqArr.length - i > 1) {
                BooleanQuery tempQ = new BooleanQuery();
                QTermElement[] synTermsSeqSubArr = new QTermElement[synTermsSeqArr.length - i - 1];
                System.arraycopy(synTermsSeqArr, i + 1, synTermsSeqSubArr, 0, synTermsSeqArr.length - i - 1);
                BooleanClause.Occur curOccur = BooleanClause.Occur.MUST;
                if (this.doesQueryContainsAllShould((Query)boolQs[i])) {
                    curOccur = BooleanClause.Occur.SHOULD;
                }
                tempQ.add((Query)boolQs[i], curOccur);
                BooleanQuery restQuery = (BooleanQuery)this.handleDependentMultipleSynonyms(synTermsSeqSubArr, field);
                curOccur = BooleanClause.Occur.MUST;
                if (this.doesQueryContainsAllShould((Query)restQuery)) {
                    curOccur = BooleanClause.Occur.SHOULD;
                }
                tempQ.add((Query)restQuery, curOccur);
                finalQ.add((Query)tempQ, BooleanClause.Occur.SHOULD);
            } else {
                finalQ.add((Query)boolQs[i], BooleanClause.Occur.SHOULD);
            }
            if (synTermsSeqArr.length <= i + 1) continue;
            sBuf.append(' ');
            sBuf.append(synTermsSeqArr[i + 1].getBaseStr());
        }
        return finalQ;
    }

    private boolean doesQueryContainsAllShould(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanClause[] allClauses;
            for (BooleanClause curClause : allClauses = ((BooleanQuery)query).getClauses()) {
                boolean ans = this.doesQueryContainsAllShould(curClause.getQuery());
                if (!ans) {
                    return false;
                }
                if (curClause.getOccur().equals(BooleanClause.Occur.SHOULD)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean isASimpleField(String field) {
        for (String curField : this.simpleFields) {
            if (!curField.equals(field)) continue;
            return true;
        }
        return false;
    }

    public String buildAutoDocQueryAddition(String query, AutoDocQueryConfig autoDocQueryConfig, String ... additionalFields) throws SiapiException, ExtendedException {
        String allOriginal = "";
        String allOptional = "";
        String allPhraseOptional = "";
        List<QueryElement> docLQE = this.inclusiveElements(query, "_plain");
        boolean addSeparator = false;
        int queryPosition = 0;
        for (QueryElement curElement : docLQE) {
            addSeparator = curElement.getQueryPosition() - queryPosition > 1;
            queryPosition = curElement.getQueryPosition();
            String orgStr = curElement.getOrgStr();
            orgStr = orgStr.trim();
            if (curElement.getType() == QueryElement.Type.PHRASE) {
                String[] splitPharse;
                for (String curTerm : splitPharse = curElement.getBaseStr().split(" ")) {
                    if (curTerm.equals("")) continue;
                    allOptional = allOptional + " " + curTerm + "?";
                    allPhraseOptional = allPhraseOptional + " " + curTerm + "?";
                }
                allOriginal = allOriginal + " " + orgStr;
                if (!curElement.isOptional()) {
                    allOptional = allOptional + " " + orgStr + "?";
                    allPhraseOptional = allPhraseOptional + " " + orgStr + "?";
                    continue;
                }
                allOptional = allOptional + " " + orgStr;
                allPhraseOptional = allPhraseOptional + " " + orgStr;
                continue;
            }
            if (addSeparator) {
                orgStr = "<> " + orgStr;
            }
            allOriginal = allOriginal + " " + orgStr;
            allPhraseOptional = allPhraseOptional + " " + orgStr;
            if (!curElement.isOptional()) {
                allOptional = allOptional + " " + orgStr + "?";
                continue;
            }
            allOptional = allOptional + " " + orgStr;
        }
        allOriginal = allOriginal.trim();
        allOptional = allOptional.trim();
        allPhraseOptional = allPhraseOptional.trim();
        String autoDocLevelQuery = "";
        if (!allOptional.equals("")) {
            for (String curField : additionalFields) {
                autoDocLevelQuery = autoDocLevelQuery + " (" + curField + ": " + allOptional + ")?";
            }
        }
        if (autoDocQueryConfig == AutoDocQueryConfig.WITH_PLAINTEXT_ONLY_PHRASE_OPTIONAL && !allPhraseOptional.equals("")) {
            autoDocLevelQuery = autoDocLevelQuery + " " + allPhraseOptional;
        }
        if (autoDocQueryConfig == AutoDocQueryConfig.WITH_PLAINTEXT_ALL_OPTIONAL && !allOptional.equals("")) {
            autoDocLevelQuery = autoDocLevelQuery + " " + allOptional;
        }
        if (autoDocQueryConfig == AutoDocQueryConfig.WITH_PLAINTEXT_ORIGINAL && !allOptional.equals("")) {
            autoDocLevelQuery = autoDocLevelQuery + " " + allOriginal;
        }
        autoDocLevelQuery = autoDocLevelQuery.trim();
        return autoDocLevelQuery;
    }

    public List<QueryElement> inclusiveElements(String userDocQueryString, String fieldFilter) throws ExtendedException {
        userDocQueryString = userDocQueryString.trim();
        return this.inclusiveElements(userDocQueryString, "_plain", false, fieldFilter, 0);
    }

    private List<QueryElement> inclusiveElements(String userDocQueryString, String field, boolean ancestorIsWithExcludingMark, String fieldFilter, int queryPosition) throws ExtendedException {
        ElementType curElement = null;
        char[] userQueryCharArr = userDocQueryString.toCharArray();
        ArrayList<QueryElement> inclusiveQueryTerms = new ArrayList<QueryElement>();
        boolean validQuery = this.checkParenthesisValidity(userQueryCharArr);
        if (!validQuery) {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        int elementFirstCharIndex = 0;
        int elementLastCharIndex = 0;
        while (elementFirstCharIndex < userDocQueryString.length() && (curElement = this.checkElementType(userQueryCharArr, elementFirstCharIndex)) != null) {
            FieldQueryMap fieldQueryMap;
            String unStripedElementStr;
            if (curElement.equals((Object)ElementType.TERM)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.TERM, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                QTermElement te = new QTermElement(unStripedElementStr, field, ++queryPosition);
                if (te.getAssociatedField().equals(fieldFilter) && !te.exclude && !ancestorIsWithExcludingMark) {
                    inclusiveQueryTerms.add(te);
                }
            } else if (curElement.equals((Object)ElementType.PHRASE)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.PHRASE, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                QPhraseElement pe = new QPhraseElement(unStripedElementStr, field, ++queryPosition);
                if (pe.getAssociatedField().equals(fieldFilter) && !pe.exclude && !ancestorIsWithExcludingMark) {
                    inclusiveQueryTerms.add(pe);
                }
            } else if (curElement.equals((Object)ElementType.GROUP)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.GROUP, userQueryCharArr, elementFirstCharIndex);
                unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, elementLastCharIndex + 1);
                char excludeSign = unStripedElementStr.trim().charAt(0);
                char optionSign = unStripedElementStr.charAt(unStripedElementStr.length() - 1);
                BooleanClause.Occur occur = BooleanClause.Occur.MUST;
                if (optionSign == '?') {
                    occur = BooleanClause.Occur.SHOULD;
                }
                if (excludeSign == '-' || excludeSign == '!') {
                    occur = BooleanClause.Occur.MUST_NOT;
                }
                String subUserQuery = this.stripGroup(unStripedElementStr);
                String groupField = this.getFieldInGroup(unStripedElementStr);
                if (groupField == null) {
                    groupField = field;
                }
                if (occur != BooleanClause.Occur.MUST_NOT && !ancestorIsWithExcludingMark) {
                    List<QueryElement> tempInclusiveQueryTerms = this.inclusiveElements(subUserQuery, groupField, false, fieldFilter, queryPosition);
                    for (QueryElement curQueryElement : tempInclusiveQueryTerms) {
                        if (!curQueryElement.getAssociatedField().equals(fieldFilter)) continue;
                        inclusiveQueryTerms.add(curQueryElement);
                    }
                }
            } else if (curElement.equals((Object)ElementType.SEMANIC_GORUP)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.SEMANIC_GORUP, userQueryCharArr, elementFirstCharIndex);
            } else if (curElement.equals((Object)ElementType.XML_GROUP)) {
                elementLastCharIndex = this.findElementEndPos(ElementType.XML_GROUP, userQueryCharArr, elementFirstCharIndex);
            } else if (curElement.equals((Object)ElementType.FIELD_GROUP) && (fieldQueryMap = this.parseToFieldMap(unStripedElementStr = userDocQueryString.substring(elementFirstCharIndex, (elementLastCharIndex = this.findElementEndPos(ElementType.FIELD_GROUP, userQueryCharArr, elementFirstCharIndex)) + 1))) != null) {
                List<QueryElement> tempInclusiveQueryTerms = this.inclusiveElements(fieldQueryMap.getQuery(), field, false, fieldFilter, queryPosition);
                for (QueryElement curQueryElement : tempInclusiveQueryTerms) {
                    if (!curQueryElement.getAssociatedField().equals(fieldFilter)) continue;
                    inclusiveQueryTerms.add(curQueryElement);
                }
            }
            elementFirstCharIndex = elementLastCharIndex + 1;
        }
        return inclusiveQueryTerms;
    }

    public HashMap<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public String getFieldValue(String field) {
        return this.fieldMap.get(field);
    }

    private boolean checkParenthesisValidity(char[] userQueryCharArr) {
        int groupParenthesisCounter = 0;
        int xmlParenthesisCounter = 0;
        int fieldParenthesisCounter = 0;
        int uimaParenthesisCounter = 0;
        int phraseParenthesisCounter = 0;
        for (int i = 0; i < userQueryCharArr.length; ++i) {
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '(') {
                ++groupParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == ')') {
                --groupParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '{') {
                ++uimaParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '}') {
                --uimaParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '<') {
                ++xmlParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '>') {
                --xmlParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '\"') {
                ++phraseParenthesisCounter;
            }
            if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '/') {
                ++fieldParenthesisCounter;
            }
            if (groupParenthesisCounter >= 0 && xmlParenthesisCounter >= 0 && uimaParenthesisCounter >= 0) continue;
            return false;
        }
        if (groupParenthesisCounter != 0 || xmlParenthesisCounter != 0 || uimaParenthesisCounter != 0) {
            return false;
        }
        if (phraseParenthesisCounter % 2 != 0) {
            return false;
        }
        return fieldParenthesisCounter % 2 == 0;
    }

    private ElementType checkElementType(char[] userQueryCharArr, int elementFirstCharIndex) throws ExtendedException {
        char[] spacedChars = new char[]{' ', '\t', '\r', '\n'};
        char[] notAStartingElementChars = new char[]{'?', '}', ')', ']', '>'};
        char[] groupStartElementChar = new char[]{'('};
        char[] semanticGroupStartElementChar = new char[]{'{'};
        char[] fieldGroupStartElementChar = new char[]{'/'};
        char[] xmlGroupStartElementChar = new char[]{'<'};
        char[] skipingChars = new char[]{' ', '\t', '\r', '\n', '!', '-'};
        char[] unCertainlyStartingElementChars = new char[]{'\"'};
        char elementFirstChar = userQueryCharArr[elementFirstCharIndex];
        while (this.isInArr(skipingChars, elementFirstChar)) {
            if (userQueryCharArr.length <= ++elementFirstCharIndex) {
                return null;
            }
            elementFirstChar = userQueryCharArr[elementFirstCharIndex];
        }
        if (this.isInArr(notAStartingElementChars, elementFirstChar)) {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        if (this.isInArr(groupStartElementChar, elementFirstChar)) {
            return ElementType.GROUP;
        }
        if (this.isInArr(semanticGroupStartElementChar, elementFirstChar)) {
            return ElementType.SEMANIC_GORUP;
        }
        if (this.isInArr(xmlGroupStartElementChar, elementFirstChar)) {
            return ElementType.XML_GROUP;
        }
        if (this.isInArr(fieldGroupStartElementChar, elementFirstChar)) {
            return ElementType.FIELD_GROUP;
        }
        if (this.isInArr(unCertainlyStartingElementChars, elementFirstChar)) {
            int elementLastCharIndex = this.findElementEndPos(ElementType.PHRASE, userQueryCharArr, elementFirstCharIndex);
            for (int i = elementFirstCharIndex; i < elementLastCharIndex; ++i) {
                if (!this.isInArr(spacedChars, userQueryCharArr[i])) continue;
                return ElementType.PHRASE;
            }
            return ElementType.TERM;
        }
        return ElementType.TERM;
    }

    private int findElementEndPos(ElementType et, char[] userQueryCharArr, int elementFirstCharIndex) throws ExtendedException {
        char[] spacedChars = new char[]{' ', '\t', '\r', '\n'};
        char[] skipingChars = new char[]{' ', '\t', '\r', '\n', '!', '-'};
        char[] groupStart = new char[]{'('};
        char[] groupEnd = new char[]{')'};
        char elementFirstChar = userQueryCharArr[elementFirstCharIndex];
        while (this.isInArr(skipingChars, elementFirstChar)) {
            elementFirstChar = userQueryCharArr[++elementFirstCharIndex];
        }
        if (et.equals((Object)ElementType.TERM)) {
            for (int i = elementFirstCharIndex + 1; i < userQueryCharArr.length; ++i) {
                if (this.isEscaped(userQueryCharArr, i)) continue;
                if (this.isInArr(spacedChars, userQueryCharArr[i]) || this.isInArr(groupEnd, userQueryCharArr[i]) || this.isInArr(groupStart, userQueryCharArr[i])) {
                    return i - 1;
                }
                if (userQueryCharArr[i] != '?') continue;
                return i;
            }
        } else {
            if (et.equals((Object)ElementType.PHRASE)) {
                for (int i = elementFirstCharIndex + 1; i < userQueryCharArr.length; ++i) {
                    if (this.isEscaped(userQueryCharArr, i) || userQueryCharArr[i] != '\"') continue;
                    if (i < userQueryCharArr.length - 1 && userQueryCharArr[i + 1] == '?') {
                        return i + 1;
                    }
                    return i;
                }
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
            if (et.equals((Object)ElementType.GROUP)) {
                int level = 0;
                for (int i = elementFirstCharIndex + 1; i < userQueryCharArr.length; ++i) {
                    if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == '(') {
                        ++level;
                    }
                    if (this.isEscaped(userQueryCharArr, i) || userQueryCharArr[i] != ')' || --level != -1) continue;
                    if (userQueryCharArr.length > i + 1 && userQueryCharArr[i + 1] == '?') {
                        return i + 1;
                    }
                    return i;
                }
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
            if (et.equals((Object)ElementType.FIELD_GROUP)) {
                for (int i = elementFirstCharIndex + 1; i < userQueryCharArr.length; ++i) {
                    if (this.isEscaped(userQueryCharArr, i) || userQueryCharArr[i] != '/') continue;
                    if (userQueryCharArr.length > i + 1 && userQueryCharArr[i + 1] == '?') {
                        return i + 1;
                    }
                    return i;
                }
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
            if (et.equals((Object)ElementType.SEMANIC_GORUP) || et.equals((Object)ElementType.XML_GROUP)) {
                char groupOpeningChar = userQueryCharArr[elementFirstCharIndex];
                char groupClosingChar = '}';
                if (groupOpeningChar == '<') {
                    groupClosingChar = '>';
                }
                int level = 0;
                for (int i = elementFirstCharIndex + 1; i < userQueryCharArr.length; ++i) {
                    if (!this.isEscaped(userQueryCharArr, i) && userQueryCharArr[i] == groupOpeningChar) {
                        ++level;
                    }
                    if (this.isEscaped(userQueryCharArr, i) || userQueryCharArr[i] != groupClosingChar || --level != -1) continue;
                    if (userQueryCharArr.length > i + 1 && userQueryCharArr[i + 1] == '?') {
                        return i + 1;
                    }
                    return i;
                }
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
        }
        return userQueryCharArr.length - 1;
    }

    public boolean isEscaped(String token) {
        char[] tokenCharArr = token.toCharArray();
        for (int i = 0; i < tokenCharArr.length; ++i) {
            if (!this.isEscaped(tokenCharArr, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isEscaped(char[] userQueryCharArr, int curCharIndex) {
        if (curCharIndex == 0) {
            return false;
        }
        int escapeCharCounter = 0;
        for (int i = curCharIndex - 1; i >= 0; --i) {
            if (userQueryCharArr[i] == '\\') {
                ++escapeCharCounter;
                continue;
            }
            return escapeCharCounter % 2 != 0;
        }
        return escapeCharCounter % 2 != 0;
    }

    private boolean isInArr(char[] arr, char c) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != c) continue;
            return true;
        }
        return false;
    }

    private FieldQueryMap addFieldMap(String unStripedFieldGroup) throws ExtendedException {
        FieldQueryMap fieldQueryMap = this.parseToFieldMap(unStripedFieldGroup);
        if (fieldQueryMap != null) {
            this.fieldMap.put(fieldQueryMap.getField(), fieldQueryMap.getQuery());
            return fieldQueryMap;
        }
        return null;
    }

    private FieldQueryMap parseToFieldMap(String unStripedFieldGroup) throws ExtendedException {
        String field = null;
        String queryPart = null;
        if ((unStripedFieldGroup = unStripedFieldGroup.trim()).charAt(0) == '-' || unStripedFieldGroup.charAt(0) == '!') {
            unStripedFieldGroup = unStripedFieldGroup.substring(1);
        }
        if ((unStripedFieldGroup = unStripedFieldGroup.trim()).charAt(unStripedFieldGroup.length() - 1) == '?') {
            unStripedFieldGroup = unStripedFieldGroup.substring(0, unStripedFieldGroup.length() - 1);
        }
        if ((unStripedFieldGroup = unStripedFieldGroup.trim()).charAt(0) != '/' || unStripedFieldGroup.charAt(unStripedFieldGroup.length() - 1) != '/') {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        String stripedGroup = unStripedFieldGroup.substring(1, unStripedFieldGroup.length() - 1);
        Pattern p = Pattern.compile("[^\\\\]:");
        Matcher m = p.matcher(stripedGroup);
        if (m.find(0)) {
            queryPart = stripedGroup.substring(m.end());
            field = stripedGroup.substring(0, m.start() + 1).trim();
            if (queryPart != null && field != null && !queryPart.equals("") && !field.equals("")) {
                field = field.trim();
                queryPart = queryPart.trim();
                queryPart = ((Object)TextUtils.slashUnescape(queryPart)).toString();
                return new FieldQueryMap(field, queryPart);
            }
        }
        return null;
    }

    private String getFieldInGroup(String unStripedGroup) throws ExtendedException {
        char[] notAStartingFieldChars = new char[]{'?', '}', ')', ']', '>', '{', '(', '<', '-', '!'};
        if ((unStripedGroup = unStripedGroup.trim()).charAt(0) == '-' || unStripedGroup.charAt(0) == '!') {
            unStripedGroup = unStripedGroup.substring(1);
        }
        if ((unStripedGroup = unStripedGroup.trim()).charAt(unStripedGroup.length() - 1) == '?') {
            unStripedGroup = unStripedGroup.substring(0, unStripedGroup.length() - 1);
        }
        if ((unStripedGroup = unStripedGroup.trim()).charAt(0) != '(' || unStripedGroup.charAt(unStripedGroup.length() - 1) != ')') {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        String stripedGroup = unStripedGroup.substring(1, unStripedGroup.length() - 1);
        if (this.isInArr(notAStartingFieldChars, stripedGroup.trim().charAt(0))) {
            return null;
        }
        Pattern fieldPattern = Pattern.compile("\\A[^:]*?[^\\\\]:");
        Matcher m = fieldPattern.matcher(stripedGroup);
        if (m.find(0)) {
            return stripedGroup.substring(0, m.end() - 1).trim();
        }
        return null;
    }

    private String stripGroup(String unStripedGroup) throws ExtendedException {
        char[] notAStartingFieldChars = new char[]{'?', '}', ')', ']', '>', '{', '(', '<', '-', '!'};
        if ((unStripedGroup = unStripedGroup.trim()).charAt(0) == '-' || unStripedGroup.charAt(0) == '!') {
            unStripedGroup = unStripedGroup.substring(1);
        }
        if ((unStripedGroup = unStripedGroup.trim()).charAt(unStripedGroup.length() - 1) == '?') {
            unStripedGroup = unStripedGroup.substring(0, unStripedGroup.length() - 1);
        }
        if ((unStripedGroup = unStripedGroup.trim()).charAt(0) != '(' || unStripedGroup.charAt(unStripedGroup.length() - 1) != ')') {
            throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
        }
        String stripedGroup = unStripedGroup.substring(1, unStripedGroup.length() - 1);
        if (this.isInArr(notAStartingFieldChars, stripedGroup.trim().charAt(0))) {
            return stripedGroup;
        }
        Pattern fieldPattern = Pattern.compile("\\A[^:]*?[^\\\\]:");
        Matcher m = fieldPattern.matcher(stripedGroup);
        if (m.find(0)) {
            stripedGroup = stripedGroup.substring(m.end()).trim();
        }
        return stripedGroup;
    }

    private Query makeASimpleTermsQuery(String token, String field, boolean isWildCard) throws SiapiException, ExtendedException {
        token = token.trim();
        BooleanQuery boolQ = new BooleanQuery();
        if (isWildCard) {
            SupaWildcardQueryBuilder swq = new SupaWildcardQueryBuilder(field, token, SUPAConstants.INDEXED_LEMMA_MARKER);
            try {
                Query allWCTermsQuery = swq.makeExtendedTermQuery(this.searchWrapper.getTextIndexReader(), 7.0f);
                return allWCTermsQuery;
            }
            catch (IOException e) {
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
        }
        String unSlashedToken = ((Object)TextUtils.slashUnescape(token)).toString();
        boolQ.add(this.buildTermQuery(field, unSlashedToken, 10.0f), BooleanClause.Occur.SHOULD);
        return boolQ;
    }

    private Query makeAnExtendedTermsQuery(String token, String field, QueryElement.Type termType, boolean isWildCard, boolean isAsynonym) throws SiapiException, ExtendedException {
        BooleanQuery boolQ = new BooleanQuery();
        if (!termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL)) {
            List<String> allTokens = this.getAllRegularTokens(token);
            if (allTokens.size() != 1) {
                for (String curToken : allTokens) {
                    boolQ.add(this.makeAnExtendedTermQuery(curToken, field, termType, isWildCard, isAsynonym), BooleanClause.Occur.SHOULD);
                }
            } else {
                boolQ.add(this.makeAnExtendedTermQuery(token, field, termType, isWildCard, isAsynonym), BooleanClause.Occur.SHOULD);
            }
        } else {
            return this.makeAnExtendedTermQuery(token, field, termType, isWildCard, isAsynonym);
        }
        return boolQ;
    }

    private Query makeAnExtendedTermQuery(String token, String field, QueryElement.Type termType, boolean isWildCard, boolean isAsynonym) throws SiapiException, ExtendedException {
        List<String> allPartToken;
        float boostDivider = 1.0f;
        if (isAsynonym) {
            boostDivider = 2.0f;
        }
        BooleanQuery boolQ = new BooleanQuery();
        if (isWildCard && !termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL)) {
            SupaWildcardQueryBuilder swq = new SupaWildcardQueryBuilder(field, this.toLowerCase(token), SUPAConstants.INDEXED_LEMMA_MARKER);
            try {
                Query allWCTermsQuery = swq.makeExtendedTermQuery(this.searchWrapper.getTextIndexReader(), 7.0f);
                return allWCTermsQuery;
            }
            catch (IOException e) {
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
        }
        if (!termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL) && !this.isEscaped(token) && (allPartToken = this.stripAllSubWords(token)).size() > 0) {
            boolQ.add(this.buildExtendedPhraseQueryForAllTokens(field, allPartToken, termType, 10), BooleanClause.Occur.SHOULD);
        }
        String regText = this.normAndMakeRegularForm(token);
        String[] synonyms = new String[]{};
        if (this.synSearcher != null) {
            synonyms = this.synSearcher.getSynonyms(regText);
        }
        boolQ.add(this.buildTermQuery(field, regText, 10.0f / boostDivider), BooleanClause.Occur.SHOULD);
        if (termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS)) {
            boolQ.add(this.buildTermQuery(field, TokenizationUtils.makeIndexedLemma(regText), 7.0f / boostDivider), BooleanClause.Occur.SHOULD);
            boolQ.add(this.buildSubQuery(field, regText, isAsynonym), BooleanClause.Occur.SHOULD);
            this.handleSynonyms(synonyms, boolQ, field, QueryElement.Type.TERM_FILTER_SYNONYMS);
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS)) {
            boolQ.add(this.buildTermQuery(field, TokenizationUtils.makeIndexedLemma(regText), 7.0f / boostDivider), BooleanClause.Occur.SHOULD);
            this.handleSynonyms(synonyms, boolQ, field, QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS);
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYMS)) {
            boolQ.add(this.buildTermQuery(field, TokenizationUtils.makeIndexedLemma(regText), 7.0f / boostDivider), BooleanClause.Occur.SHOULD);
            boolQ.add(this.buildSubQuery(field, regText, isAsynonym), BooleanClause.Occur.SHOULD);
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS)) {
            boolQ.add(this.buildTermQuery(field, TokenizationUtils.makeIndexedLemma(regText), 7.0f / boostDivider), BooleanClause.Occur.SHOULD);
        }
        return boolQ;
    }

    private void handleSynonyms(String[] synonyms, BooleanQuery boolQ, String field, QueryElement.Type termType) throws SiapiException, ExtendedException {
        for (String curSynonym : synonyms) {
            if (curSynonym.contains(" ")) {
                String[] allPhraseTerms = curSynonym.split(" ");
                ArrayList<String> tokens = new ArrayList<String>();
                for (String curTerm : allPhraseTerms) {
                    tokens.add(this.normAndMakeRegularForm(curTerm));
                }
                boolQ.add(this.buildExtendedPhraseQueryForAllTokens(field, tokens, termType, 10), BooleanClause.Occur.SHOULD);
                continue;
            }
            boolQ.add(this.makeAnExtendedTermQuery(curSynonym, field, termType, false, true), BooleanClause.Occur.SHOULD);
        }
    }

    private Query buildSubQuery(String field, String text, boolean isAsynonym) {
        Query[] clausesArray;
        float boostDivider = 1.0f;
        if (isAsynonym) {
            boostDivider = 2.0f;
        }
        BooleanQuery boolQ = new BooleanQuery();
        for (Query curQuery : clausesArray = new Query[]{this.buildTermQuery(field, TokenizationUtils.makeIndexedSubWord(text), 4.0f / boostDivider), this.buildTermQuery(field, TokenizationUtils.makeIndexedSubWordLemma(text), 2.0f / boostDivider)}) {
            boolQ.add(curQuery, BooleanClause.Occur.SHOULD);
        }
        return boolQ;
    }

    private Query buildTermQuery(String field, String text, float boost) {
        Term term = new Term(field, text);
        TermQuery termQuery = new TermQuery(term);
        termQuery.setBoost(boost);
        return termQuery;
    }

    private PhraseQuery buildPhraseQuery(String phrase, String field) {
        String[] allPhraseTerms;
        PhraseQuery phraseQuery = new PhraseQuery();
        for (String curTerm : allPhraseTerms = phrase.split(" ")) {
            phraseQuery.add(new Term(field, this.normAndMakeRegularForm(curTerm)));
        }
        phraseQuery.setSlop(10);
        return phraseQuery;
    }

    private List<String> getAllRegularTokens(String token) {
        List<TToken> tokens = this.builder.tokenize(token);
        HashSet<String> allRTokens = new HashSet<String>();
        for (TToken curToken : tokens) {
            String text = this.builder.normalize(curToken);
            if (TokenizationUtils.isSubwordForm(text) || TokenizationUtils.isLemma(text)) continue;
            allRTokens.add(text);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String curToken : allRTokens) {
            ret.add(curToken);
        }
        return ret;
    }

    private Query buildExtendedPhraseQueryForAllTokens(String field, List<String> tokens, QueryElement.Type termType, int phraseSlop) {
        BooleanQuery boolQ = new BooleanQuery();
        if (!termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL)) {
            ArrayList<List<String>> allCombinations = new ArrayList<List<String>>();
            int amOfCombinations = 1;
            int[] amountForEach = new int[tokens.size()];
            for (int index = 0; index < tokens.size(); ++index) {
                String token = tokens.get(index);
                List<String> allTokens = this.getAllRegularTokens(token);
                amOfCombinations *= allTokens.size();
                allCombinations.add(allTokens);
                amountForEach[index] = allTokens.size();
            }
            int[] clockCounter = new int[tokens.size()];
            int curPlace = clockCounter.length - 1;
            if (amOfCombinations >= 1) {
                ArrayList<String> curTokenSet = new ArrayList<String>();
                for (int j = 0; j < tokens.size(); ++j) {
                    curTokenSet.add((String)((List)allCombinations.get(j)).get(clockCounter[j]));
                }
                boolQ.add(this.buildExtendedPhraseQuery(field, curTokenSet, termType, phraseSlop), BooleanClause.Occur.SHOULD);
                for (int i = 0; i < amOfCombinations - 1; ++i) {
                    curTokenSet.clear();
                    curPlace = clockCounter.length - 1;
                    while (true) {
                        if (clockCounter[curPlace] < amountForEach[curPlace] - 1) break;
                        clockCounter[curPlace] = 0;
                        --curPlace;
                    }
                    int n = curPlace;
                    clockCounter[n] = clockCounter[n] + 1;
                    for (int j = 0; j < tokens.size(); ++j) {
                        curTokenSet.add((String)((List)allCombinations.get(j)).get(clockCounter[j]));
                    }
                    boolQ.add(this.buildExtendedPhraseQuery(field, curTokenSet, termType, phraseSlop), BooleanClause.Occur.SHOULD);
                }
                return boolQ;
            }
            return this.buildExtendedPhraseQuery(field, tokens, termType, phraseSlop);
        }
        return this.buildExtendedPhraseQuery(field, tokens, termType, phraseSlop);
    }

    private Query buildExtendedPhraseQuery(String field, List<String> tokens, QueryElement.Type termType, int phraseSlop) {
        BooleanQuery boolQ = new BooleanQuery();
        int amountofPossiblePhrases = (int)Math.pow(4.0, tokens.size());
        if (termType.equals((Object)QueryElement.Type.PHRASE)) {
            termType = QueryElement.Type.TERM_ONLY_ORIGINAL;
        }
        if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYMS)) {
            termType = QueryElement.Type.TERM_ALL_FORMS;
        }
        if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS)) {
            termType = QueryElement.Type.TERM_FILTER_SUB_WORDS;
        }
        for (int i = 0; i < amountofPossiblePhrases; ++i) {
            PhraseQuery phraseQuery = new PhraseQuery();
            int curTermIndex = 0;
            float phraseBoost = 0.0f;
            for (String curTerm : tokens) {
                int temp0 = tokens.size() - curTermIndex - 1;
                double temp1 = (double)i % Math.pow(4.0, temp0);
                double temp2 = ((double)i - temp1) / Math.pow(4.0, temp0);
                int curTermForm = (int)(temp2 % 4.0);
                if (curTermForm == 0 && (termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS) || termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS) || termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL))) {
                    phraseBoost += 10.0f;
                    phraseQuery.add(new Term(field, curTerm));
                }
                if (curTermForm == 1 && termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS)) {
                    phraseBoost += 4.0f;
                    phraseQuery.add(new Term(field, TokenizationUtils.makeIndexedSubWord(curTerm)));
                }
                if (curTermForm == 2 && termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS)) {
                    phraseBoost += 2.0f;
                    phraseQuery.add(new Term(field, TokenizationUtils.makeIndexedSubWordLemma(curTerm)));
                }
                if (curTermForm == 3 && (termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS) || termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS))) {
                    phraseBoost += 7.0f;
                    phraseQuery.add(new Term(field, TokenizationUtils.makeIndexedLemma(curTerm)));
                }
                ++curTermIndex;
            }
            phraseQuery.setBoost(phraseBoost /= (float)tokens.size());
            phraseQuery.setSlop(phraseSlop);
            boolQ.add((Query)phraseQuery, BooleanClause.Occur.SHOULD);
        }
        return boolQ;
    }

    public List<String> stripAllSubWords(String token) {
        List<TToken> tokens = this.builder.tokenize(token);
        ArrayList<String> allPartToken = new ArrayList<String>();
        for (TToken curToken : tokens) {
            String text = this.builder.normalize(curToken);
            if (!TokenizationUtils.isSubword(text)) continue;
            allPartToken.add(TokenizationUtils.makeRegularForm(text));
        }
        return allPartToken;
    }

    public String normAndMakeRegularForm(String curTerm) {
        String normText = this.builder.normalize(curTerm);
        String regText = TokenizationUtils.makeRegularForm(normText);
        return regText;
    }

    private String toLowerCase(String regx) {
        return regx.toLowerCase();
    }

    public List<String> getAllExtendedTerms(QueryElement qe, String field) throws SiapiException, ExtendedException {
        return this.getAllExtendedTerms(qe.getBaseStr(), field, qe.getType(), qe.isWildCard(), false);
    }

    public List<List<String>> getExtendedPhrases(List<String> tokens) {
        ArrayList<List<String>> allPhrases = new ArrayList<List<String>>();
        int amountofPossiblePhrases = (int)Math.pow(4.0, tokens.size());
        for (int i = 0; i < amountofPossiblePhrases; ++i) {
            ArrayList<String> onePhrase = new ArrayList<String>();
            int curTermIndex = 0;
            for (String curTerm : tokens) {
                int temp0 = tokens.size() - curTermIndex - 1;
                double temp1 = (double)i % Math.pow(4.0, temp0);
                double temp2 = ((double)i - temp1) / Math.pow(4.0, temp0);
                int curTermForm = (int)(temp2 % 4.0);
                if (curTermForm == 0) {
                    onePhrase.add(curTerm);
                }
                if (curTermForm == 1) {
                    onePhrase.add(TokenizationUtils.makeIndexedSubWord(curTerm));
                }
                if (curTermForm == 2) {
                    onePhrase.add(TokenizationUtils.makeIndexedSubWordLemma(curTerm));
                }
                if (curTermForm == 3) {
                    onePhrase.add(TokenizationUtils.makeIndexedLemma(curTerm));
                }
                ++curTermIndex;
            }
            allPhrases.add(onePhrase);
        }
        return allPhrases;
    }

    private List<String> getAllExtendedTerms(String token, String field, QueryElement.Type termType, boolean isWildCard, boolean isAsynonym) throws SiapiException, ExtendedException {
        ArrayList<String> allExtTerms = new ArrayList<String>();
        if (!termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL)) {
            List<TToken> tokens = this.builder.tokenize(token);
            HashSet<String> allRTokens = new HashSet<String>();
            for (TToken tToken : tokens) {
                String text = this.builder.normalize(tToken);
                if (TokenizationUtils.isSubwordForm(text) || TokenizationUtils.isLemma(text)) continue;
                allRTokens.add(text);
            }
            if (allRTokens.size() != 1) {
                for (String string : allRTokens) {
                    allExtTerms.addAll(this.getAllExtendedTerm(string, field, termType, isWildCard, isAsynonym));
                }
            } else {
                allExtTerms.addAll(this.getAllExtendedTerm(token, field, termType, isWildCard, isAsynonym));
            }
        } else {
            return this.getAllExtendedTerm(token, field, termType, isWildCard, isAsynonym);
        }
        return allExtTerms;
    }

    private List<String> getAllExtendedTerm(String token, String field, QueryElement.Type termType, boolean isWildCard, boolean isSynonym) throws SiapiException, ExtendedException {
        ArrayList<String> allExtTerms = new ArrayList<String>();
        if (isWildCard && !termType.equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL)) {
            SupaWildcardQueryBuilder swq = new SupaWildcardQueryBuilder(field, this.toLowerCase(token), SUPAConstants.INDEXED_LEMMA_MARKER);
            try {
                allExtTerms.addAll(swq.getAllWildCardTerms(this.searchWrapper.getTextIndexReader()));
                return allExtTerms;
            }
            catch (IOException e) {
                throw new ExtendedException(new Message("S0032E.QUERY_BAD_SYNTAX"));
            }
        }
        String normText = this.builder.normalize(token);
        String regText = TokenizationUtils.makeRegularForm(normText);
        String[] synonyms = new String[]{};
        if (this.synSearcher != null) {
            synonyms = this.synSearcher.getSynonyms(regText);
        }
        allExtTerms.add(regText);
        if (termType.equals((Object)QueryElement.Type.TERM_ALL_FORMS)) {
            allExtTerms.add(TokenizationUtils.makeIndexedLemma(regText));
            allExtTerms.addAll(this.getExtendedSubTerms(field, regText));
            for (String curSynonym : synonyms) {
                allExtTerms.addAll(this.getAllExtendedTerms(curSynonym, field, QueryElement.Type.TERM_FILTER_SYNONYMS, false, true));
            }
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SUB_WORDS)) {
            allExtTerms.add(TokenizationUtils.makeIndexedLemma(regText));
            for (String curSynonym : synonyms) {
                allExtTerms.addAll(this.getAllExtendedTerms(curSynonym, field, QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS, false, true));
            }
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYMS)) {
            allExtTerms.add(TokenizationUtils.makeIndexedLemma(regText));
            allExtTerms.addAll(this.getExtendedSubTerms(field, regText));
        } else if (termType.equals((Object)QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS)) {
            allExtTerms.add(TokenizationUtils.makeIndexedLemma(regText));
        }
        return allExtTerms;
    }

    private List<String> getExtendedSubTerms(String field, String text) {
        ArrayList<String> allExtTerms = new ArrayList<String>();
        allExtTerms.add(TokenizationUtils.makeIndexedSubWord(text));
        allExtTerms.add(TokenizationUtils.makeIndexedSubWordLemma(text));
        return allExtTerms;
    }

    public String getSummary(List<String> userQueries, String field, Document document, int docId) throws SiapiException, ExtendedException, IOException {
        if (userQueries == null) {
            userQueries = Collections.emptyList();
        }
        DocumentCache docCache = ConfigurationLoader.getGlobalConfig().getDocumentCache();
        ScoreDoc[] allScoreDocs = new ScoreDoc[1];
        Document[] allDocs = new Document[1];
        TokenizedDocument[] tokDocs = new TokenizedDocument[1];
        ArrayList<QueryElement> inclusiveQueriesElements = new ArrayList<QueryElement>();
        for (String curUserQuery : userQueries) {
            if (curUserQuery == null) continue;
            try {
                List<QueryElement> inclusiveQueryElements = this.inclusiveElements(curUserQuery, field);
                inclusiveQueriesElements.addAll(inclusiveQueryElements);
            }
            catch (Exception e) {}
        }
        Summarizer summarizer = new Summarizer(this.searchWrapper.getTextIndexReader());
        allScoreDocs[0] = new ScoreDoc(docId, 0.0f);
        allDocs[0] = document;
        HighlightQueryTerms allTerm = new HighlightQueryTerms();
        for (QueryElement curElement : inclusiveQueriesElements) {
            if (curElement.getType() != QueryElement.Type.PHRASE) {
                List<String> allSubWords;
                List<String> allExtTerms = this.getAllExtendedTerms(curElement, field);
                for (String curExtTerm : allExtTerms) {
                    HighlightTerm ht = new HighlightTerm(new Term(field, curExtTerm), null, false);
                    allTerm.addSingleTerm(ht);
                }
                if (this.isEscaped(curElement.getBaseStr()) || curElement.getType().equals((Object)QueryElement.Type.TERM_ONLY_ORIGINAL) || curElement.isWildCard() || (allSubWords = this.stripAllSubWords(curElement.getBaseStr())).size() <= 0) continue;
                List<List<String>> extendedPhrases = this.getExtendedPhrases(allSubWords);
                for (List<String> curPhrase : extendedPhrases) {
                    ArrayList<HighlightTerm> allPhraseHTerms = new ArrayList<HighlightTerm>();
                    for (String curTerm : curPhrase) {
                        allPhraseHTerms.add(new HighlightTerm(new Term(field, curTerm), null, false));
                    }
                    allTerm.addPhrase(allPhraseHTerms);
                }
                continue;
            }
            String curPhrase = curElement.getBaseStr();
            String[] allPhraseTerms = curPhrase.split(" ");
            ArrayList<HighlightTerm> allPhraseHTerms = new ArrayList<HighlightTerm>();
            for (String curTerm : allPhraseTerms) {
                allPhraseHTerms.add(new HighlightTerm(new Term(field, this.normAndMakeRegularForm(curTerm)), null, false));
            }
            allTerm.addPhrase(allPhraseHTerms);
        }
        tokDocs[0] = docCache.fetchDocument(this.searchWrapper, docId);
        Summarizer.Summary[] sum = summarizer.getSummaries(allScoreDocs, allDocs, tokDocs, allTerm, field);
        return sum[0].toString();
    }

    static class QPhraseElement
    implements QueryElement {
        private String orgStr;
        private String baseStr;
        private boolean exclude;
        private boolean optional;
        private String associatedField;
        private int queryPosition;

        public QPhraseElement(String unStripedPhraseElementStr, String associatedField, int queryPosition) {
            String strippedElementStr;
            this.queryPosition = queryPosition;
            this.orgStr = unStripedPhraseElementStr;
            this.associatedField = associatedField;
            unStripedPhraseElementStr = unStripedPhraseElementStr.trim();
            this.exclude = false;
            this.optional = false;
            if (unStripedPhraseElementStr.charAt(0) == '-' || unStripedPhraseElementStr.charAt(0) == '!') {
                this.exclude = true;
                unStripedPhraseElementStr = unStripedPhraseElementStr.substring(1);
            }
            if (unStripedPhraseElementStr.charAt(unStripedPhraseElementStr.length() - 1) == '?') {
                this.optional = true;
                unStripedPhraseElementStr = unStripedPhraseElementStr.substring(0, unStripedPhraseElementStr.length() - 1);
            }
            unStripedPhraseElementStr = unStripedPhraseElementStr.trim();
            this.baseStr = strippedElementStr = unStripedPhraseElementStr.substring(1, unStripedPhraseElementStr.length() - 1);
        }

        public boolean isExcluded() {
            return this.exclude;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getBaseStr() {
            return this.baseStr;
        }

        public BooleanClause.Occur getOccur() {
            BooleanClause.Occur occur = BooleanClause.Occur.MUST;
            if (!this.exclude) {
                occur = BooleanClause.Occur.MUST;
            }
            if (this.exclude) {
                occur = BooleanClause.Occur.MUST_NOT;
            }
            if (this.optional && !this.exclude) {
                occur = BooleanClause.Occur.SHOULD;
            }
            return occur;
        }

        public boolean isWildCard() {
            return false;
        }

        public QueryElement.Type getType() {
            return QueryElement.Type.PHRASE;
        }

        public String getAssociatedField() {
            return this.associatedField;
        }

        public String getOrgStr() {
            return this.orgStr;
        }

        public int getQueryPosition() {
            return this.queryPosition;
        }
    }

    static class QTermElement
    implements QueryElement {
        private String orgStr;
        private String baseStr;
        private boolean exclude;
        private boolean optional;
        private boolean wildCard;
        private QueryElement.Type termType;
        private String associatedField;
        private int queryPosition;

        public QTermElement(String unStripedTermElementStr, String associatedField, int queryPosition) {
            this.queryPosition = queryPosition;
            this.orgStr = unStripedTermElementStr;
            this.termType = QueryElement.Type.TERM_ALL_FORMS;
            this.exclude = false;
            this.optional = false;
            this.wildCard = false;
            this.associatedField = associatedField;
            unStripedTermElementStr = unStripedTermElementStr.trim();
            if (unStripedTermElementStr.charAt(0) == '-' || unStripedTermElementStr.charAt(0) == '!') {
                this.exclude = true;
                unStripedTermElementStr = unStripedTermElementStr.substring(1);
            }
            if (unStripedTermElementStr.charAt(unStripedTermElementStr.length() - 1) == '?') {
                this.optional = true;
                unStripedTermElementStr = unStripedTermElementStr.substring(0, unStripedTermElementStr.length() - 1);
            }
            if ((unStripedTermElementStr = unStripedTermElementStr.trim()).charAt(0) == '\"' && unStripedTermElementStr.charAt(unStripedTermElementStr.length() - 1) == '\"') {
                unStripedTermElementStr = unStripedTermElementStr.substring(1, unStripedTermElementStr.length() - 1);
                this.termType = QueryElement.Type.TERM_ONLY_ORIGINAL;
            } else if (unStripedTermElementStr.charAt(0) == '=') {
                if ((unStripedTermElementStr = unStripedTermElementStr.substring(1)).charAt(0) == '\'' && unStripedTermElementStr.charAt(unStripedTermElementStr.length() - 1) == '\'') {
                    unStripedTermElementStr = unStripedTermElementStr.substring(1, unStripedTermElementStr.length() - 1);
                    this.termType = QueryElement.Type.TERM_FILTER_SYNONYM_SUB_WORDS;
                } else {
                    this.termType = QueryElement.Type.TERM_FILTER_SYNONYMS;
                }
            } else if (unStripedTermElementStr.charAt(0) == '\'' && unStripedTermElementStr.charAt(unStripedTermElementStr.length() - 1) == '\'') {
                unStripedTermElementStr = unStripedTermElementStr.substring(1, unStripedTermElementStr.length() - 1);
                this.termType = QueryElement.Type.TERM_FILTER_SUB_WORDS;
            }
            String strippedElementStr = unStripedTermElementStr;
            if (!SupaWildcardQueryBuilder.containsNonOptional(strippedElementStr)) {
                throw new IndexOutOfBoundsException("Wildcard search can't contain all optionals");
            }
            if (SupaWildcardQueryBuilder.containsWildcard(strippedElementStr)) {
                this.wildCard = true;
            }
            this.baseStr = strippedElementStr;
        }

        public boolean isWildCard() {
            return this.wildCard;
        }

        public boolean isExcluded() {
            return this.exclude;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getBaseStr() {
            return this.baseStr;
        }

        public BooleanClause.Occur getOccur() {
            BooleanClause.Occur occur = BooleanClause.Occur.MUST;
            if (!this.exclude) {
                occur = BooleanClause.Occur.MUST;
            }
            if (this.exclude) {
                occur = BooleanClause.Occur.MUST_NOT;
            }
            if (this.optional && !this.exclude) {
                occur = BooleanClause.Occur.SHOULD;
            }
            return occur;
        }

        public QueryElement.Type getType() {
            return this.termType;
        }

        public String getAssociatedField() {
            return this.associatedField;
        }

        public String getOrgStr() {
            return this.orgStr;
        }

        public int getQueryPosition() {
            return this.queryPosition;
        }
    }

    public static interface QueryElement {
        public int getQueryPosition();

        public boolean isExcluded();

        public boolean isOptional();

        public BooleanClause.Occur getOccur();

        public String getOrgStr();

        public String getBaseStr();

        public Type getType();

        public boolean isWildCard();

        public String getAssociatedField();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            PHRASE,
            TERM_ONLY_ORIGINAL,
            TERM_ALL_FORMS,
            TERM_FILTER_SUB_WORDS,
            TERM_FILTER_SYNONYMS,
            TERM_FILTER_SYNONYM_SUB_WORDS;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ElementType {
        TERM,
        PHRASE,
        GROUP,
        SEMANIC_GORUP,
        XML_GROUP,
        FIELD_GROUP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutoDocQueryConfig {
        WITH_PLAINTEXT_ORIGINAL,
        WITH_PLAINTEXT_ALL_OPTIONAL,
        WITH_PLAINTEXT_ONLY_PHRASE_OPTIONAL,
        WITHOUT_PLAINTEXT;

    }

    private class FieldQueryMap {
        private final String field;
        private final String query;

        public FieldQueryMap(String field, String query) {
            this.field = field;
            this.query = query;
        }

        public String getField() {
            return this.field;
        }

        public String getQuery() {
            return this.query;
        }
    }
}

