/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.CICSQueryExecuter;
import com.ibm.supa.search.queries.TextQueryExecutor;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFilter;
import com.ibm.supa.search.spans.extended.ExtSpansPositionsFilter;
import com.ibm.supa.search.spans.extended.MissingClauseExtSpanScorer;
import com.ibm.supa.search.spans.extended.MultiExtSpanScorer;
import com.ibm.supa.search.spans.extended.QueryOrderScorer;
import com.ibm.supa.search.spans.extended.SlopExtSpanScorer;
import com.ibm.supa.search.spans.extended.SpanLengthExtSpanScorer;
import com.ibm.supa.search.spans.extended.tags.ExtSpanTermTagQuery;
import java.io.IOException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyBookQueryExecuter
extends TextQueryExecutor {
    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new CopyBookQuery(collectionIds);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return CICSQueryExecuter.CICSQuery.class;
    }

    static class Executor
    extends TextQueryExecutor.Executor {
        static final int CB_K = 5;
        static final String COMMENT_ANNOT = "comment";
        static final String VARIABLE_ANNOT = "variabledeclaration";
        static final String COPY_BOOK_CATEGORY = "copy_book";
        final CopyBookQuery fQuery;
        final ResultsProcessor processor;
        final Map<ExtSpanQuery, Set<Integer>> combinedPositionsLookup;
        final Set<Integer> requiredQueryPositions;
        QueryFragment[] fragments;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
            this.fQuery = (CopyBookQuery)CopyBookQuery.class.cast(query);
            this.processor = processor;
            this.combinedPositionsLookup = new IdentityHashMap<ExtSpanQuery, Set<Integer>>();
            this.requiredQueryPositions = new HashSet<Integer>();
        }

        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            this.saveSameDocExtSpans = false;
            this.createConstrainingDocQuery = false;
            this.forceOptionals = true;
            this.termsAreOptional = true;
            this.partialsAllowed = false;
            this.enableAutoDocLevelQuerying = true;
            this.fQuery.setMaxLocalSlop(2);
            ExtSpanQuery narrowBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.partialsAllowed = true;
            this.fQuery.setMaxLocalSlop(15);
            ExtSpanQuery wideBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.forceOptionals = false;
            this.partialsAllowed = true;
            super.buildRootQuery(wrapper);
            this.extractRequiredQueryPositions();
            ExtSpanQuery commentQuery = this.buildCommentQuery(wideBaseQuery);
            ExtSpanQuery variableQuery = this.buildVariableQuery(narrowBaseQuery);
            int numClauses = Math.max(1, this.numInclusiveClauses);
            this.enableScoringAdjustments = true;
            super.addWeighting(commentQuery, 1.0 / (double)numClauses);
            super.addWeighting(variableQuery, 1.0 / (double)numClauses);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{variableQuery, commentQuery};
            boolean[] optionals = new boolean[]{true, true};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, -1, 0, true);
            nQuery.setAllowPartialResults(true);
            super.addScorer(nQuery, new MissingClauseExtSpanScorer(nQuery, false, 15.0, 7.0));
            return new ExtSpanQueryFilter(nQuery, new ExtSpansPositionsFilter(this.combinedPositionsLookup, this.requiredQueryPositions));
        }

        private void extractQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                Set<Integer> positions = this.combinedPositionsLookup.get((Object)entry.getKey());
                if (positions == null) {
                    positions = new HashSet<Integer>();
                    this.combinedPositionsLookup.put(entry.getKey(), positions);
                }
                for (QueryFragment fragment : entry.getValue()) {
                    positions.add(fragment.getQueryPosition());
                }
            }
        }

        private void extractRequiredQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                for (QueryFragment fragment : entry.getValue()) {
                    if (fragment.isOptional()) continue;
                    this.requiredQueryPositions.add(fragment.getQueryPosition());
                }
            }
        }

        private ExtSpanQuery buildAnnotQuery(String annotName) {
            return this.buildAnnotQuery(annotName, null, false, false);
        }

        private ExtSpanQuery buildAnnotQuery(String annotName, ExtSpanQuery query, boolean queryIsContainer, boolean includeContainer) {
            String field = "_uimatags";
            ExtSpanQuery tagQuery = new ExtSpanTermTagQuery(new Term(field, annotName));
            tagQuery = new ExtSpanQueryFieldChanger(tagQuery, "_plain");
            if (query == null) {
                return tagQuery;
            }
            ExtSpanContainsQuery cQuery = queryIsContainer ? new ExtSpanContainsQuery(query, tagQuery) : new ExtSpanContainsQuery(tagQuery, query);
            cQuery.setIncludeContainer(includeContainer);
            cQuery.setForceAllSpans(true);
            tagQuery = cQuery.optimize(false);
            return tagQuery;
        }

        private ExtSpanQuery buildVariableQuery(ExtSpanQuery query) {
            return this.buildAnnotQuery(VARIABLE_ANNOT, query, false, true);
        }

        private ExtSpanQuery buildCommentQuery(ExtSpanQuery query) {
            return this.makeCommentQuery(this.buildAnnotQuery(COMMENT_ANNOT, query, false, true));
        }

        private ExtSpanQuery makeCommentQuery(ExtSpanQuery query) {
            return this.makeCommentQuery(query, false, false);
        }

        private ExtSpanQuery makeCommentQuery(ExtSpanQuery query, boolean isOptionalComment, boolean includesContainer) {
            this.scorer.addScorer(query, new SpanLengthExtSpanScorer(0.001));
            ExtSpanQuery varQuery = this.buildAnnotQuery(VARIABLE_ANNOT);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{query, varQuery};
            boolean[] optionals = new boolean[]{false, isOptionalComment};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, this.fQuery.getAnnotationSlop(), true);
            nQuery.setAllowPartialResults(false);
            this.scorer.addScorer(nQuery, new MultiExtSpanScorer(new QueryOrderScorer(clauses, 3.0), new SlopExtSpanScorer(0.2)));
            return this.buildAnnotQuery(VARIABLE_ANNOT, nQuery, true, includesContainer);
        }
    }

    public static class CopyBookQuery
    extends TextQueryExecutor.TextQuery {
        private static final long serialVersionUID = 2137229155242054525L;
        private int annotationSlop = 50;

        public CopyBookQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
            super.setMaxLocalSlop(15);
            super.setDescriptionsLoaded(true);
        }

        public int getAnnotationSlop() {
            return this.annotationSlop;
        }

        public void setAnnotationSlop(int annotationSlop) {
            this.annotationSlop = annotationSlop;
        }
    }
}

