/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchSnapshotImpl;
import com.ibm.supa.search.SearchUtils;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.QueryUtils;
import com.ibm.supa.search.queries.TextQueryExecutor;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedQueryExecutor2
extends TextQueryExecutor {
    private Map<QueryExecutor, Double> subExecutors;

    public Map<QueryExecutor, Double> getSubExecutors() {
        return this.subExecutors;
    }

    public void setSubExecutors(Map subExecutors) {
        this.ensureValueTypes(subExecutors);
        this.subExecutors = subExecutors;
    }

    private void ensureValueTypes(Map<Object, Object> subExecutors) {
        for (Map.Entry<Object, Object> entry : subExecutors.entrySet()) {
            if (Double.class.equals(entry.getValue().getClass())) continue;
            entry.setValue(Double.parseDouble(entry.getValue().toString()));
        }
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers, this.subExecutors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Executor
    extends TextQueryExecutor.Executor {
        private final Map<QueryExecutor, Double> delegates;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers, Map<QueryExecutor, Double> delegates) throws SiapiException {
            super(query, processor, wrappers);
            this.delegates = delegates;
        }

        @Override
        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            ExtSpanQuery[] clauses = new ExtSpanQuery[this.delegates.size()];
            int i = 0;
            for (Map.Entry<QueryExecutor, Double> entry : this.delegates.entrySet()) {
                QueryExecutor queryExec = entry.getKey();
                SupaQuery queryCopy = QueryUtils.copy(this.query, queryExec);
                SearchSnapshot snapshot = queryCopy.getSearchSnapshot();
                SearchSnapshotImpl nextSnapshot = snapshot == null ? new SearchSnapshotImpl(queryCopy, queryExec) : new SearchSnapshotImpl(queryCopy, queryExec, snapshot.getAssociationToPreviousQuery(), snapshot.getPreviousSnapshot());
                queryCopy.setSearchSnapshot(nextSnapshot);
                ExtSpanQuery query = super.buildQueryFromSnapshotResults(SearchUtils.getResults(wrapper, nextSnapshot));
                super.addWeighting(query, entry.getValue());
                clauses[i++] = query;
            }
            return new ExtSpanOrQuery(clauses);
        }
    }
}

