/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.SpellCorrection;
import com.ibm.siapi.search.SynonymExpansion;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchUtils;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.queries.QueryUtils;
import com.ibm.supa.search.spans.SpanResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedQueryExecutor
extends BaseQueryExecutor {
    private Map<QueryExecutor, Double> subExecutors;

    public Map<QueryExecutor, Double> getSubExecutors() {
        return this.subExecutors;
    }

    public void setSubExecutors(Map subExecutors) {
        this.ensureValueTypes(subExecutors);
        this.subExecutors = subExecutors;
    }

    private void ensureValueTypes(Map<Object, Object> subExecutors) {
        for (Map.Entry<Object, Object> entry : subExecutors.entrySet()) {
            if (Double.class.equals(entry.getValue().getClass())) continue;
            entry.setValue(Double.parseDouble(entry.getValue().toString()));
        }
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers, this.subExecutors);
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new CombinedQuery(collectionIds);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        SupaQuery result = this.subCreateQuery(collectionIds);
        result.setText(queryString);
        return result;
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return CombinedQuery.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Executor
    extends BaseQueryExecutor.BaseExecutor {
        private static final Comparator<Result> SCORE_COMPARATOR = new Comparator<Result>(){

            @Override
            public int compare(Result o1, Result o2) {
                return Double.compare(o2.getScore(), o1.getScore());
            }
        };
        private final CombinedQuery cQuery;
        private final Map<QueryExecutor, Double> delegates;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers, Map<QueryExecutor, Double> delegates) throws SiapiException {
            super(query, processor, wrappers);
            this.cQuery = (CombinedQuery)CombinedQuery.class.cast(query);
            this.delegates = delegates;
        }

        @Override
        protected ResultSet subExecute() throws SiapiException {
            HashMap subResults = new HashMap();
            HashMap<FutureTask<ResultSet>, Double> tasks = new HashMap<FutureTask<ResultSet>, Double>();
            for (final QueryExecutor queryExec : this.delegates.keySet()) {
                FutureTask<ResultSet> task = new FutureTask<ResultSet>(new Callable<ResultSet>(){

                    @Override
                    public ResultSet call() throws Exception {
                        SupaQuery subQuery = QueryUtils.copy(Executor.this.query, queryExec);
                        Executor.this.cQuery.subQueries.put(queryExec, subQuery);
                        return queryExec.execute(subQuery, Executor.this.processor, Executor.this.wrappers);
                    }
                });
                SearchUtils.SEARCH_EXECUTOR.submit(task);
                tasks.put(task, this.delegates.get(queryExec));
            }
            int numResults = 0;
            int numPredef = 0;
            int numSpell = 0;
            int numSyns = 0;
            int numAvail = 0;
            int totalResults = 0;
            boolean truncated = false;
            long startTime = System.currentTimeMillis();
            for (Map.Entry taskEntry : tasks.entrySet()) {
                try {
                    ResultSet resultSet = (ResultSet)SUPAUtils.completeTask((FutureTask)taskEntry.getKey());
                    if (resultSet == null) continue;
                    numResults += this.length(resultSet.getResults());
                    numPredef += this.length(resultSet.getPredefinedResults());
                    numSpell += this.length(resultSet.getSpellCorrections());
                    numSyns += this.length(resultSet.getSynonymExpansions());
                    numAvail += resultSet.getAvailableNumberOfResults();
                    totalResults += resultSet.getEstimatedNumberOfResults();
                    truncated |= resultSet.isEvaluationTruncated();
                    subResults.put(resultSet, taskEntry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            long evalTime = System.currentTimeMillis() - startTime;
            Result[] results = numResults > 0 ? new ResultImpl[numResults] : null;
            Result[] predefs = numPredef > 0 ? new ResultImpl[numPredef] : null;
            SpellCorrection[] spell = numSpell > 0 ? new SpellCorrection[numSpell] : null;
            SynonymExpansion[] syns = numSyns > 0 ? new SynonymExpansion[numSyns] : null;
            HashSet<String> queriedFieldSet = new HashSet<String>();
            for (Map.Entry entry : subResults.entrySet()) {
                ResultSetImpl resSet;
                ResultSet resultSet = (ResultSet)entry.getKey();
                numResults = this.copyToEnd(resultSet.getResults(), results, numResults);
                numPredef = this.copyToEnd(resultSet.getPredefinedResults(), predefs, numPredef);
                this.rescore(results, numResults, this.length(resultSet.getResults()), (Double)entry.getValue());
                this.rescore(predefs, numPredef, this.length(resultSet.getPredefinedResults()), (Double)entry.getValue());
                numSpell = this.copyToEnd(resultSet.getSpellCorrections(), spell, numSpell);
                numSyns = this.copyToEnd(resultSet.getSynonymExpansions(), syns, numSyns);
                if (!(resultSet instanceof ResultSetImpl) || (resSet = (ResultSetImpl)resultSet).getQueriedFields() == null) continue;
                for (String field : resSet.getQueriedFields()) {
                    queriedFieldSet.add(field);
                }
            }
            if (results != null) {
                Arrays.sort(results, SCORE_COMPARATOR);
            }
            String[] queriedFields = queriedFieldSet.toArray(new String[queriedFieldSet.size()]);
            SearchSnapshot searchSnapshot = this.query.getSearchSnapshot();
            if (searchSnapshot != null) {
                for (SearchWrapper wrapper : this.wrappers) {
                    ArrayList<SpanResult> spanResults = new ArrayList<SpanResult>();
                    for (QueryExecutor queryExec : this.delegates.keySet()) {
                        SearchSnapshot snapshot = ((SupaQuery)this.cQuery.subQueries.get(queryExec)).getSearchSnapshot();
                        SearchSnapshot.Results subResult = snapshot.getResults(wrapper.getCollectionId());
                        if (subResult.getSpanResults() == null) continue;
                        spanResults.addAll(subResult.getSpanResults());
                    }
                    Collections.sort(spanResults, SpanResult.POSITION_COMPARATOR);
                    searchSnapshot.setResults(wrapper.getCollectionId(), spanResults, wrapper.getIndexVersion());
                }
            }
            return new ResultSetImpl(results, predefs, null, syns, spell, evalTime, numAvail, totalResults, queriedFields, truncated);
        }

        private <T> int length(T[] array) {
            return array == null ? 0 : array.length;
        }

        private <T> int copyToEnd(T[] src, T[] dest, int end) {
            if (src != null) {
                System.arraycopy(src, 0, dest, end - src.length, src.length);
                end -= src.length;
            }
            return end;
        }

        private void rescore(Result[] results, int off, int length, double factor) {
            for (int i = off; i < off + length; ++i) {
                if (results[i] instanceof ResultImpl) {
                    ((ResultImpl)results[i]).setScore(factor * results[i].getScore());
                }
                if (!(results[i] instanceof SpanResultImpl)) continue;
                SpanResultImpl spanResult = (SpanResultImpl)results[i];
                spanResult.setSpanScore(factor * spanResult.getSpanScore());
            }
        }
    }

    private class CombinedQuery
    extends SupaQueryImpl {
        private Map<QueryExecutor, SupaQuery> subQueries;

        public CombinedQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
            this.subQueries = new ConcurrentHashMap<QueryExecutor, SupaQuery>();
        }
    }
}

