/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.search.prefs.SearchPreferences;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.cics.CicsCommandPriority;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.QueryFragment;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.TermLocator;
import com.ibm.supa.search.queries.CopyBookQueryExecuter;
import com.ibm.supa.search.queries.TextQueryExecutor;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFilter;
import com.ibm.supa.search.spans.extended.ExtSpansPositionsFilter;
import com.ibm.supa.search.spans.extended.MissingClauseExtSpanScorer;
import com.ibm.supa.search.spans.extended.MultiExtSpanScorer;
import com.ibm.supa.search.spans.extended.QueryOrderScorer;
import com.ibm.supa.search.spans.extended.SimpleExtSpanScorer;
import com.ibm.supa.search.spans.extended.SlopExtSpanScorer;
import com.ibm.supa.search.spans.extended.SpanLengthExtSpanScorer;
import com.ibm.supa.search.spans.extended.tags.ExtSpanTermTagQuery;
import java.io.IOException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpanTermQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CICSFuncQueryExecuter
extends TextQueryExecutor {
    private CicsCommandPriority cicsCommandPriority;

    public void setCicsCommandPriority(CicsCommandPriority cicsCommandPriority) {
        this.cicsCommandPriority = cicsCommandPriority;
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new CICSQuery(collectionIds);
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return CICSQuery.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Executor
    extends TextQueryExecutor.Executor {
        static final String FUNCSCOPE_ANNOT = "funcscope";
        static final String FUNCTION_ANNOT = "function";
        static final String CICS_FUNC_SCOPE_ANNOT = "cicsfuncscope";
        static final String CICS_FUNC_ANNOT = "cicsfunction";
        static final String COMMENT_ANNOT = "comment";
        static final String CICS_ARGUMENTS_ANNOT = "execcicsargs";
        static final String CICS_CALL_ANNOT = "execcics";
        static final String CICS_COMMANDS_ANNOT = "execcicscommands";
        static final int CB_K = 5;
        static final int COMMAND_MAX_PENALTY = 10;
        static final int COMMAND_MID_PENALTY = 5;
        static final int COMMAND_MIN_PENALTY = 1;
        final CICSQuery fQuery;
        final ResultsProcessor processor;
        final Map<ExtSpanQuery, Set<Integer>> combinedPositionsLookup;
        final Set<Integer> requiredQueryPositions;
        QueryFragment[] fragments;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
            this.fQuery = (CICSQuery)CICSQuery.class.cast(query);
            this.processor = processor;
            this.combinedPositionsLookup = new IdentityHashMap<ExtSpanQuery, Set<Integer>>();
            this.requiredQueryPositions = new HashSet<Integer>();
            this.fQuery.setProperty("displayTagSpans", "true");
        }

        @Override
        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            this.saveSameDocExtSpans = false;
            this.createConstrainingDocQuery = false;
            this.forceOptionals = true;
            this.termsAreOptional = true;
            this.partialsAllowed = false;
            this.enableAutoDocLevelQuerying = true;
            this.fQuery.setMaxLocalSlop(2);
            ExtSpanQuery narrowBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.partialsAllowed = true;
            this.fQuery.setMaxLocalSlop(15);
            ExtSpanQuery wideBaseQuery = super.buildRootQuery(wrapper);
            this.extractQueryPositions();
            this.forceOptionals = false;
            this.partialsAllowed = true;
            ExtSpanQuery copyBookQuery = this.buildCopyBookQuery(wideBaseQuery);
            ExtSpanQuery[] copyQueryClauses = copyBookQuery != null ? new ExtSpanQuery[]{wideBaseQuery, copyBookQuery} : new ExtSpanQuery[]{wideBaseQuery};
            ExtSpanOrQuery wideBaseCopyQuery = new ExtSpanOrQuery(copyQueryClauses);
            super.buildRootQuery(wrapper);
            this.extractRequiredQueryPositions();
            ExtSpanQuery combinedFuncQuery = this.combineFuncQueries(wideBaseCopyQuery, narrowBaseQuery);
            ExtSpanQuery cicsQuery = this.combineCicsCallQueries(narrowBaseQuery);
            int numClauses = Math.max(1, this.numInclusiveClauses);
            this.enableScoringAdjustments = true;
            super.addWeighting(combinedFuncQuery, 0.4 / (double)numClauses);
            super.addWeighting(cicsQuery, 1.0 / (double)numClauses);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{combinedFuncQuery, cicsQuery};
            boolean[] optionals = new boolean[]{true, true};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, -1, 0, true);
            nQuery.setAllowPartialResults(true);
            nQuery.setMinNumOptionalInResult(1);
            super.addScorer(nQuery, new MissingClauseExtSpanScorer(nQuery, false, 15.0, 8.0));
            return new ExtSpanQueryFilter(nQuery, new ExtSpansPositionsFilter(this.combinedPositionsLookup, this.requiredQueryPositions));
        }

        private void extractQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                Set<Integer> positions = this.combinedPositionsLookup.get((Object)entry.getKey());
                if (positions == null) {
                    positions = new HashSet<Integer>();
                    this.combinedPositionsLookup.put(entry.getKey(), positions);
                }
                for (QueryFragment fragment : entry.getValue()) {
                    positions.add(fragment.getQueryPosition());
                }
            }
        }

        private void extractRequiredQueryPositions() {
            for (Map.Entry<ExtSpanQuery, List<QueryFragment>> entry : this.fragmentLookup.entrySet()) {
                for (QueryFragment fragment : entry.getValue()) {
                    if (fragment.isOptional()) continue;
                    this.requiredQueryPositions.add(fragment.getQueryPosition());
                }
            }
        }

        private ExtSpanQuery buildAnnotQuery(String annotName) {
            return this.buildAnnotQuery(annotName, null, false, false);
        }

        private ExtSpanQuery buildAnnotQuery(String annotName, ExtSpanQuery query, boolean queryIsContainer, boolean includeContainer) {
            String field = "_uimatags";
            ExtSpanQuery tagQuery = new ExtSpanTermTagQuery(new Term(field, annotName));
            tagQuery = new ExtSpanQueryFieldChanger(tagQuery, "_plain");
            if (query == null) {
                return tagQuery;
            }
            ExtSpanContainsQuery cQuery = queryIsContainer ? new ExtSpanContainsQuery(query, tagQuery) : new ExtSpanContainsQuery(tagQuery, query);
            cQuery.setIncludeContainer(includeContainer);
            cQuery.setForceAllSpans(true);
            tagQuery = cQuery.optimize(false);
            return tagQuery;
        }

        private ExtSpanQuery buildCicsArgumentsQuery(ExtSpanQuery query) {
            ExtSpanQuery argQuery = this.buildAnnotQuery(CICS_ARGUMENTS_ANNOT, query, false, true);
            return argQuery;
        }

        public Set<Map.Entry<String, Integer>> getCicsCommandsPriorities() {
            Set<Map.Entry<String, Integer>> commandPriorities = CICSFuncQueryExecuter.this.cicsCommandPriority.getCicsCommandsPrioritiesSet();
            return commandPriorities;
        }

        private ExtSpanQuery combineCicsCallQueries(ExtSpanQuery query) {
            Set<Map.Entry<String, Integer>> commandList = CICSFuncQueryExecuter.this.cicsCommandPriority.getCicsCommandsPrioritiesSet();
            ExtSpanQuery commandQuery = this.buildAnnotQuery(CICS_COMMANDS_ANNOT, this.buildCicsCommandPriorityQuery(commandList, true), false, false);
            ExtSpanQuery argQuery = this.buildCicsArgumentsQuery(query);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{this.buildAnnotQuery(CICS_CALL_ANNOT), commandQuery, argQuery};
            boolean[] optionals = new boolean[]{false, true, true};
            ExtSpanAllNearQuery result = new ExtSpanAllNearQuery(clauses, optionals, -1, false);
            this.scorer.addScorer(result, new MissingClauseExtSpanScorer(result, false, 0.0, 20.0, 30.0));
            this.scorer.addWeighting(result, 0.5);
            ExtSpanQuery funQuery = this.buildAnnotQuery(CICS_FUNC_SCOPE_ANNOT, result, false, true);
            return new ExtSpanQueryFilter(this.buildAnnotQuery(CICS_FUNC_ANNOT, funQuery, true, false), new ExtSpansFilter.StatelessFilter(){

                public boolean accept(ExtSpans extSpans) {
                    if (extSpans.numSubExtSpans() != 2) {
                        return false;
                    }
                    return Math.abs(extSpans.subExtSpan(0).start() - extSpans.subExtSpan(1).start()) < 8;
                }
            });
        }

        private ExtSpanQuery makeCommentQuery(ExtSpanQuery query) {
            this.scorer.addScorer(query, new SpanLengthExtSpanScorer(0.001));
            ExtSpanQuery funQuery = this.buildAnnotQuery(CICS_FUNC_ANNOT);
            ExtSpanQuery[] clauses = new ExtSpanQuery[]{query, funQuery};
            boolean[] optionals = new boolean[]{false, false};
            ExtSpanAllNearQuery nQuery = new ExtSpanAllNearQuery(clauses, optionals, this.fQuery.getAnnotationSlop(), true);
            nQuery.setAllowPartialResults(false);
            this.scorer.addScorer(nQuery, new MultiExtSpanScorer(new QueryOrderScorer(clauses, 3.0), new SlopExtSpanScorer(0.2)));
            return nQuery;
        }

        private ExtSpanQuery buildFunctionNameQuery(ExtSpanQuery query) {
            ExtSpanQuery funcNameQuery = this.buildAnnotQuery(CICS_FUNC_ANNOT, query, false, true);
            return funcNameQuery;
        }

        private ExtSpanQuery combineFuncQueries(ExtSpanQuery wideBasequery, ExtSpanQuery narrowBaseQuery) {
            ExtSpanQuery funcName = this.buildFunctionNameQuery(narrowBaseQuery);
            ExtSpanQuery comment = this.makeCommentQuery(this.buildAnnotQuery(COMMENT_ANNOT, wideBasequery, false, true));
            ExtSpanAllNearQuery fQuery = new ExtSpanAllNearQuery(-1, false, true, funcName, comment);
            this.scorer.addScorer(fQuery, new MissingClauseExtSpanScorer(fQuery, false, 10.0, 8.0));
            ExtSpanQuery name = this.buildAnnotQuery(CICS_FUNC_ANNOT, fQuery, true, false);
            return name;
        }

        private ExtSpanQuery buildCopyBookQuery(ExtSpanQuery query) {
            return this.buildCBQuery(query, false);
        }

        private ExtSpanQuery buildCBQuery(ExtSpanQuery query, boolean includeContainer) {
            try {
                int startOff = 0;
                int pageSize = 5;
                long queryTimeout = 3000L;
                boolean filter = true;
                UserSecurityContext usc = null;
                SearchPreferences prefs = new SearchPreferences();
                prefs.setQL(this.fQuery.getQueryLanguage());
                prefs.setFO("0");
                TermLocator termLocator = ConfigurationLoader.getGlobalConfig().getTermLocator();
                CopyBookQueryExecuter executor = new CopyBookQueryExecuter();
                SupaQuery cbQuery = executor.createQuery(this.fQuery.getCollectionIds(), this.fQuery.getSpanQueryString() + " @@ (categorization: \"cobol_copybook\")");
                termLocator.updateQuery(cbQuery, prefs, startOff, pageSize, filter, usc, queryTimeout);
                ResultSet resultSet = executor.execute(cbQuery, null, this.wrappers);
                if (resultSet == null || resultSet.getAvailableNumberOfResults() == 0) {
                    return null;
                }
                Result[] results = resultSet.getResults();
                if (results == null || results.length == 0) {
                    return null;
                }
                int k = 0;
                ExtSpanQuery[] clauses = new ExtSpanQuery[Math.min(5, results.length)];
                for (Result result : results) {
                    clauses[k] = this.buildSimpleQuery("_plain", result.getDescription());
                    super.addScorer(clauses[k], new SimpleExtSpanScorer((100.0 - result.getScore()) / 10.0, null));
                    if (++k >= 5) break;
                }
                ExtSpanOrQuery nQuery = new ExtSpanOrQuery(clauses);
                return nQuery;
            }
            catch (Exception e) {
                return null;
            }
        }

        private ExtSpanQuery buildCicsCommandPriorityQuery(Set<Map.Entry<String, Integer>> commandList, boolean includeContainer) {
            int command_num = commandList.size();
            ExtSpanQuery[] clauses = new ExtSpanQuery[command_num];
            Iterator<Map.Entry<String, Integer>> it = commandList.iterator();
            int k = 0;
            while (it.hasNext()) {
                Map.Entry<String, Integer> entry = it.next();
                clauses[k] = this.cicsCommandPriorityQuery(entry.getKey(), entry.getValue().intValue());
                ++k;
            }
            return new ExtSpanOrQuery(clauses);
        }

        private ExtSpanQuery cicsCommandPriorityQuery(String command, float val) {
            ExtSpanQuery query = this.buildSimpleQuery("_plain", command);
            super.addScorer(query, new SimpleExtSpanScorer(val, null));
            return query;
        }

        private ExtSpanQuery buildSimpleQuery(String field, String word) {
            ExtSpanQuery query;
            String[] terms = word.split("\\s|-");
            if (terms.length == 1) {
                query = new ExtSpanTermQuery(new Term(field, word.toLowerCase()));
            } else {
                ExtSpanQuery[] clauses = new ExtSpanQuery[terms.length];
                for (int i = 0; i < terms.length; ++i) {
                    clauses[i] = new ExtSpanTermQuery(new Term(field, terms[i].toLowerCase()));
                }
                query = new ExtSpanAllNearQuery(clauses, 0, true);
            }
            return query;
        }
    }

    public static class CICSQuery
    extends TextQueryExecutor.TextQuery {
        private static final long serialVersionUID = 2137229155242054525L;
        private int annotationSlop = 50;

        public CICSQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
            super.setMaxLocalSlop(15);
        }

        public int getAnnotationSlop() {
            return this.annotationSlop;
        }

        public void setAnnotationSlop(int annotationSlop) {
            this.annotationSlop = annotationSlop;
        }
    }
}

