/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.Span;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.queries.DocLevelQueryUtilities;
import com.ibm.supa.search.queries.QueryBuilder;
import com.ibm.supa.search.queries.TextQueryExecutor;
import com.ibm.supa.search.spans.extended.DocExtSpanScorer;
import com.ibm.supa.search.spans.extended.ExtSpanAllNearQuery;
import com.ibm.supa.search.spans.extended.ExtSpanContainsQuery;
import com.ibm.supa.search.spans.extended.ExtSpanQueryFieldChanger;
import com.ibm.supa.search.spans.extended.ExtSpanVint8Query;
import com.ibm.supa.search.spans.extended.tags.ExtSpanTermTagQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.extended.ExtSpanDocBitSetQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpanTermQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetQueryExecutor
extends TextQueryExecutor {
    String categorizationFilter = null;
    List<String> annotations = new ArrayList<String>();
    boolean addFieldGroupToQuery = false;
    Map<String, Float> fieldsBoost = null;

    public void setCategorizationFilter(String categorizationFilter) {
        this.categorizationFilter = categorizationFilter;
    }

    public void setIndexedAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    public void setAddFieldGroupToQuery(boolean addFieldGroupToQuery) {
        this.addFieldGroupToQuery = addFieldGroupToQuery;
    }

    public void setFieldsBoost(Map fieldsBoost) {
        this.ensureValueTypes(fieldsBoost);
        this.fieldsBoost = fieldsBoost;
    }

    private void ensureValueTypes(Map<Object, Object> fieldsBoost) {
        for (Map.Entry<Object, Object> entry : fieldsBoost.entrySet()) {
            if (Float.class.equals(entry.getValue().getClass())) continue;
            entry.setValue(Float.valueOf(Float.parseFloat(entry.getValue().toString())));
        }
    }

    @Override
    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers, this.categorizationFilter, this.annotations, this.addFieldGroupToQuery, this.fieldsBoost);
    }

    @Override
    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        AssetQuery result = (AssetQuery)this.subCreateQuery(collectionIds);
        result.setText(queryString);
        result.setSpanQueryString("");
        result.setDocumentQueryString(queryString);
        return result;
    }

    @Override
    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new AssetQuery(collectionIds);
    }

    @Override
    public Class<? extends SupaQuery> getQueryClass() {
        return AssetQuery.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Executor
    extends TextQueryExecutor.Executor {
        private String categorizationFilter = null;
        private List<String> annotations = new ArrayList<String>();
        private boolean addFieldGroupToQuery = false;
        private Map<String, Float> fieldsBoost = null;
        AssetQuery aQuery;
        DocLevelQueryUtilities currentQueryUtility;

        public Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers, String categorizationFilter, List<String> annotations, boolean addFieldGroupToQuery, Map<String, Float> fieldsBoost) throws SiapiException {
            super(query, processor, wrappers);
            this.categorizationFilter = categorizationFilter;
            this.annotations = annotations;
            this.addFieldGroupToQuery = addFieldGroupToQuery;
            this.fieldsBoost = fieldsBoost;
            this.aQuery = (AssetQuery)AssetQuery.class.cast(query);
        }

        void updateDocumentQueryString(String documentQueryString) {
            this.aQuery.setDocumentQueryString(documentQueryString);
        }

        @Override
        ExtSpanQuery buildRootQuery(SearchWrapper wrapper) throws ExtendedException, SiapiException, IOException {
            String userDocQueryString = this.tQuery.getDocumentQueryString();
            this.currentWrapper = wrapper;
            this.currentQueryUtility = new DocLevelQueryUtilities(this.currentWrapper);
            DocLevelQueryUtilities docLevelQueryUtilities = new DocLevelQueryUtilities(this.currentWrapper);
            userDocQueryString = userDocQueryString.trim();
            if (this.enableAutoDocLevelQuerying && !userDocQueryString.equals("")) {
                userDocQueryString = userDocQueryString + " " + docLevelQueryUtilities.buildAutoDocQueryAddition(userDocQueryString, DocLevelQueryUtilities.AutoDocQueryConfig.WITHOUT_PLAINTEXT, "title", "filename");
            }
            userDocQueryString = userDocQueryString.trim();
            Query docLevelQuery = docLevelQueryUtilities.parseQuery(userDocQueryString, "_plain", this.addFieldGroupToQuery, this.fieldsBoost);
            docLevelQuery = this.addCategorizationConstraintsQuery(docLevelQuery);
            final ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
            class SetableFloat {
                private float val = 0.0f;

                public float getVal() {
                    return this.val;
                }

                public void setVal(float val) {
                    this.val = val;
                }
            }
            final SetableFloat highestScore = new SetableFloat();
            final BitSet bitSet = new BitSet();
            highestScore.setVal(Float.MIN_VALUE);
            try {
                IndexSearcher searcher = new IndexSearcher(this.currentWrapper.getTextIndexReader());
                searcher.search(docLevelQuery, new HitCollector(){
                    {
                    }

                    public void collect(int doc, float score) {
                        if (score < 0.0f) {
                            return;
                        }
                        scoreDocs.add(new ScoreDoc(doc, score));
                        bitSet.set(doc);
                        if (score >= highestScore.getVal()) {
                            highestScore.setVal(score);
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            HashMap<Integer, Double> docsScoreFactor = this.calcDocsScoreFactor(bitSet, userDocQueryString);
            this.fragmentLookup = new IdentityHashMap();
            ExtSpanDocBitSetQuery extSpanDocQuery = new ExtSpanDocBitSetQuery(bitSet, true);
            extSpanDocQuery.setField("_plain");
            this.scorer.addScorer(extSpanDocQuery, new DocExtSpanScorer(docsScoreFactor, scoreDocs, true, highestScore.getVal()));
            ExtSpanQuery finalQuery = this.addSecurePreFilterQuery(extSpanDocQuery);
            return finalQuery;
        }

        private Query addCategorizationConstraintsQuery(Query finalQuery) {
            if (this.categorizationFilter == null || this.categorizationFilter.equals("")) {
                return finalQuery;
            }
            BooleanQuery boolQ = new BooleanQuery();
            Term term = new Term("categorization", this.categorizationFilter);
            TermQuery termQuery = new TermQuery(term);
            boolQ.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            ((BooleanQuery)finalQuery).add((Query)boolQ, BooleanClause.Occur.MUST);
            return finalQuery;
        }

        private HashMap<Integer, Double> calcDocsScoreFactor(BitSet bitSet, String userDocQueryString) throws ExtendedException, SiapiException, IOException {
            List<DocLevelQueryUtilities.QueryElement> inclusiveQElements = this.currentQueryUtility.inclusiveElements(userDocQueryString, "_plain");
            return this.calcRatioBetweenAnnotationsAndDoc(inclusiveQElements, bitSet);
        }

        private HashMap<Integer, Double> calcRatioBetweenAnnotationsAndDoc(List<DocLevelQueryUtilities.QueryElement> inclusiveQElements, BitSet bitSet) throws SiapiException, ExtendedException, IOException {
            if (this.annotations == null || this.annotations.size() == 0) {
                return null;
            }
            HashMap<Integer, Double> spansCounterAnnotations = new HashMap<Integer, Double>();
            HashMap<Integer, Double> spansCounterCompleteDoc = new HashMap<Integer, Double>();
            HashMap<Integer, Double> ratioBetweenAnnotAndDoc = new HashMap<Integer, Double>();
            String field = "_plain";
            ArrayList<ExtSpanQuery> clauses = new ArrayList<ExtSpanQuery>();
            for (DocLevelQueryUtilities.QueryElement curElement : inclusiveQElements) {
                String[] allPhraseTerms;
                if (curElement.getType() != DocLevelQueryUtilities.QueryElement.Type.PHRASE) {
                    List<String> allSubWords;
                    List<String> allExtTerms = this.currentQueryUtility.getAllExtendedTerms(curElement, field);
                    for (String curExtTerm : allExtTerms) {
                        clauses.add(this.buildTermQuery(field, curExtTerm));
                    }
                    if (this.currentQueryUtility.isEscaped(curElement.getBaseStr()) || curElement.getType().equals((Object)DocLevelQueryUtilities.QueryElement.Type.TERM_ONLY_ORIGINAL) || curElement.isWildCard() || (allSubWords = this.currentQueryUtility.stripAllSubWords(curElement.getBaseStr())).size() <= 0) continue;
                    List<List<String>> extendedPhrases = this.currentQueryUtility.getExtendedPhrases(allSubWords);
                    for (List<String> curPhrase : extendedPhrases) {
                        ArrayList<ExtSpanQuery> tempClauses = new ArrayList<ExtSpanQuery>();
                        for (String curTerm : curPhrase) {
                            tempClauses.add(this.buildTermQuery(field, curTerm));
                        }
                        ExtSpanQuery[] tempClausesArr = tempClauses.toArray(new ExtSpanQuery[tempClauses.size()]);
                        clauses.add(new ExtSpanAllNearQuery(tempClausesArr, 0, true));
                    }
                    continue;
                }
                ArrayList<ExtSpanQuery> tempClauses = new ArrayList<ExtSpanQuery>();
                for (String curTerm : allPhraseTerms = curElement.getBaseStr().split(" ")) {
                    tempClauses.add(this.buildTermQuery(field, this.currentQueryUtility.normAndMakeRegularForm(curTerm)));
                }
                ExtSpanQuery[] tempClausesArr = tempClauses.toArray(new ExtSpanQuery[tempClauses.size()]);
                clauses.add(new ExtSpanAllNearQuery(tempClausesArr, 0, true));
            }
            if (clauses.size() == 0) {
                return spansCounterAnnotations;
            }
            ExtSpanQuery allTermsSpanQuery = QueryBuilder.buildOrQuery(clauses);
            ExtSpanQuery annotationsSpanQuery = this.buildAnnotationsQuery(null);
            ExtSpanVint8Query iQuery = new ExtSpanVint8Query("_plainendpos", "_plain", Integer.MAX_VALUE);
            ExtSpanQuery finalQueryOnlyForAnotations = new ExtSpanContainsQuery(iQuery, annotationsSpanQuery, false).optimize(false);
            ExtSpanQuery finalQueryForCompleteDocs = new ExtSpanContainsQuery(iQuery, allTermsSpanQuery, false).optimize(false);
            finalQueryOnlyForAnotations = this.addSpanDocQuery(bitSet, finalQueryOnlyForAnotations);
            finalQueryForCompleteDocs = this.addSpanDocQuery(bitSet, finalQueryForCompleteDocs);
            ExtSpans extSpansForAnotations = finalQueryOnlyForAnotations.getExtSpans(this.currentWrapper.getTextIndexReader());
            ExtSpans extSpansForCompleteDocs = finalQueryForCompleteDocs.getExtSpans(this.currentWrapper.getTextIndexReader());
            Set<Span> allAnnotationsSpans = this.createSortableSpanSet();
            while (extSpansForAnotations.next()) {
                Span curAnnotationSpan = new Span(extSpansForAnotations.start(), extSpansForAnotations.end(), extSpansForAnotations.doc());
                allAnnotationsSpans.add(curAnnotationSpan);
            }
            int lastDoc = 0;
            int lastStart = 0;
            int lastEnd = 0;
            Double count = null;
            while (extSpansForCompleteDocs.next()) {
                int curDoc = extSpansForCompleteDocs.doc();
                int curStart = extSpansForCompleteDocs.start();
                int curEnd = extSpansForCompleteDocs.end();
                if (curDoc == lastDoc && curStart == lastStart && curEnd == lastEnd) continue;
                Span curSpan = new Span(curStart, curEnd, curDoc);
                count = (Double)spansCounterCompleteDoc.get(curDoc);
                if (count == null) {
                    spansCounterCompleteDoc.put(curDoc, 1.0);
                } else {
                    spansCounterCompleteDoc.put(curDoc, count + 1.0);
                }
                if (allAnnotationsSpans.contains(curSpan)) {
                    count = spansCounterAnnotations.get(curDoc);
                    if (count == null) {
                        spansCounterAnnotations.put(curDoc, 1.0);
                    } else {
                        spansCounterAnnotations.put(curDoc, count + 1.0);
                    }
                }
                lastDoc = curDoc;
                lastStart = curStart;
                lastEnd = curEnd;
            }
            for (int i = 0; i < bitSet.length(); ++i) {
                if (!bitSet.get(i)) continue;
                Double value = null;
                Double frqInAnnotations = spansCounterAnnotations.get(i);
                Double frqInDoc = (Double)spansCounterCompleteDoc.get(i);
                if (frqInAnnotations == null) {
                    frqInAnnotations = 0.0;
                }
                if (frqInDoc == null) {
                    frqInDoc = 0.0;
                }
                value = (frqInAnnotations + 1.0) / (frqInDoc + 1.0);
                ratioBetweenAnnotAndDoc.put(i, value);
            }
            return ratioBetweenAnnotAndDoc;
        }

        private ExtSpanQuery buildTermQuery(String field, String text) {
            return new ExtSpanTermQuery(new Term(field, text));
        }

        private ExtSpanQuery addSpanDocQuery(BitSet bitSet, ExtSpanQuery finalQuery) throws SiapiException, ExtendedException, IOException {
            ExtSpanDocBitSetQuery docQuery = new ExtSpanDocBitSetQuery(bitSet, true);
            docQuery.setField(finalQuery.getField());
            return new ExtSpanContainsQuery(docQuery, finalQuery, false).optimize(false);
        }

        private Set<Span> createSortableSpanSet() {
            TreeSet<Span> allAnnotationsSpans = new TreeSet<Span>(new Comparator<Span>(){

                @Override
                public int compare(Span o1, Span o2) {
                    if (o1.getDocNum() < o2.getDocNum()) {
                        return -1;
                    }
                    if (o1.getDocNum() > o2.getDocNum()) {
                        return 1;
                    }
                    if (o1.getStart() >= o2.getStart() && o1.getEnd() <= o2.getEnd()) {
                        return 0;
                    }
                    return -1;
                }
            });
            return allAnnotationsSpans;
        }

        private ExtSpanQuery buildAnnotationsQuery(ExtSpanQuery query) {
            ArrayList<ExtSpanQuery> annotationClauses = new ArrayList<ExtSpanQuery>();
            for (String curAnnotation : this.annotations) {
                annotationClauses.add(this.buildAnnotationQuery(query, curAnnotation));
            }
            ExtSpanQuery annotationQuery = QueryBuilder.buildOrQuery(annotationClauses);
            return annotationQuery;
        }

        private ExtSpanQuery buildAnnotationQuery(ExtSpanQuery query, String annotation) {
            String field = "_uimatags";
            ExtSpanQuery tagQuery = new ExtSpanTermTagQuery(new Term(field, annotation));
            tagQuery = new ExtSpanQueryFieldChanger(tagQuery, "_plain");
            if (query == null) {
                return tagQuery;
            }
            return new ExtSpanContainsQuery(tagQuery, query);
        }
    }

    private static class AssetQuery
    extends TextQueryExecutor.TextQuery {
        private static final long serialVersionUID = 6718490103018168662L;

        public AssetQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
        }
    }
}

