/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.filter;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.crawler.security.AccessCheckAdapter;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.internal.demo.DocumentResultDemo;
import com.ibm.es.nuvo.crawler.security.internal.demo.DocumentResultSetDemo;
import com.ibm.es.nuvo.crawler.security.model.DocumentResult;
import com.ibm.es.nuvo.crawler.security.model.DocumentResultSet;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.supa.search.filter.ResultFilter;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ScoreDoc;

public class ACLResultFilter
implements ResultFilter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private IndexReader indexReader;
    private String collectionId;
    private UserSecurityContext userSecurityContext;

    public static boolean isAuthorized(String uri, String collectionId, UserSecurityContext userSecurityContext) throws ExtendedException {
        boolean authorized = false;
        try {
            TermDocs termDocs;
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            CollectionConfiguration collectionConfig = configManager.getCollection(collectionId);
            IndexReader reader = IndexReader.open((String)collectionConfig.getIndexPath(IndexDescriptor.IndexType.Text));
            Term uriTerm = new Term("uri", uri);
            int docFreq = reader.docFreq(uriTerm);
            if (docFreq > 0 && (termDocs = reader.termDocs(uriTerm)).next()) {
                Document document = reader.document(termDocs.doc());
                DSSecurityManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getSecurityManager();
                AccessCheckAdapter adapter = manager.getAccessCheckAdapter(collectionId);
                DocumentResultDemo documentResult = new DocumentResultDemo();
                ArrayList<DocumentResult> resultList = new ArrayList<DocumentResult>();
                Field crawlspaceField = document.getField("_crwsp");
                if (crawlspaceField != null) {
                    documentResult.setCrawlSpaceId(crawlspaceField.stringValue());
                }
                String securityUri = document.get("securityuri");
                String orgUri = null;
                orgUri = securityUri != null ? securityUri : document.get("uri");
                documentResult.setURI(orgUri);
                resultList.add(documentResult);
                DocumentResultSetDemo interimResultSet = new DocumentResultSetDemo();
                interimResultSet.setResultList(resultList);
                interimResultSet.setBlockSize(1);
                DocumentResultSet validatedResultSet = adapter.validateDocumentResult(interimResultSet, userSecurityContext.getIdentities());
                authorized = validatedResultSet.iterator().hasNext();
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        return authorized;
    }

    public ACLResultFilter(IndexReader indexReader, String collectionId, UserSecurityContext userSecurityContext) {
        this.indexReader = indexReader;
        this.collectionId = collectionId;
        this.userSecurityContext = userSecurityContext;
    }

    public ScoreDoc[] filter(ScoreDoc[] scoreDocs, int firstRequestedResult, int numRequestedResults) throws ExtendedException {
        ScoreDoc[] filteredDocs = new ScoreDoc[]{};
        try {
            if (this.userSecurityContext == null) {
                return filteredDocs;
            }
            Vector<ScoreDoc> vScoreDocs = new Vector<ScoreDoc>();
            DSSecurityManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getSecurityManager();
            AccessCheckAdapter adapter = manager.getAccessCheckAdapter(this.collectionId);
            DocumentResultSet interimResultSet = this.generateInterimResult(scoreDocs);
            DocumentResultSet validatedResultSet = adapter.validateDocumentResult(interimResultSet, this.userSecurityContext.getIdentities());
            for (DocumentResult temp : validatedResultSet) {
                ScoreDocResultDemo docDemo = (ScoreDocResultDemo)temp;
                vScoreDocs.add(docDemo.getScoreDoc());
            }
            filteredDocs = vScoreDocs.toArray(new ScoreDoc[vScoreDocs.size()]);
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        return filteredDocs;
    }

    private DocumentResultSet generateInterimResult(ScoreDoc[] docs) throws ExtendedException {
        DocumentResultSetDemo interimResultSet = new DocumentResultSetDemo();
        ArrayList<DocumentResult> resultList = new ArrayList<DocumentResult>();
        try {
            for (int i = 0; i < docs.length; ++i) {
                ScoreDocResultDemo aResult = new ScoreDocResultDemo();
                Document d = this.indexReader.document(docs[i].doc);
                Field crawlspaceField = d.getField("_crwsp");
                if (crawlspaceField != null) {
                    aResult.setCrawlSpaceId(crawlspaceField.stringValue());
                }
                aResult.setURI(d.get("uri"));
                aResult.setScoreDoc(docs[i]);
                resultList.add(aResult);
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        interimResultSet.setResultList(resultList);
        interimResultSet.setBlockSize(docs.length);
        return interimResultSet;
    }

    private class ScoreDocResultDemo
    extends DocumentResultDemo {
        private ScoreDoc scoreDoc;

        private ScoreDocResultDemo() {
        }

        public void setScoreDoc(ScoreDoc scoreDoc) {
            this.scoreDoc = scoreDoc;
        }

        public ScoreDoc getScoreDoc() {
            return this.scoreDoc;
        }
    }
}

