/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.search.prefs.SearchPreferences;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.linker.util.LinkerSupportInterface;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.TermLocator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermLocatorImpl
implements TermLocator {
    private Map<String, QueryExecutor> queryExecs = new ConcurrentHashMap<String, QueryExecutor>();
    private Map<String, QueryExecutor> nameLookup = new ConcurrentHashMap<String, QueryExecutor>();
    private Map<String, String> executorDescription = new ConcurrentHashMap<String, String>();
    private String defaultQueryExecutorName;
    private String linkerExecuterName;
    private LinkerSupportInterface linkerSupportOracle;

    public void setQueryExecutors(Map<String, QueryExecutor> executors) {
        for (Map.Entry<String, QueryExecutor> entry : executors.entrySet()) {
            this.addQueryExecutor(entry.getKey(), entry.getValue(), entry.getValue().getDescription());
        }
    }

    public void addQueryExecutor(String name, QueryExecutor executor, String description) {
        if (this.defaultQueryExecutorName == null) {
            this.defaultQueryExecutorName = name;
        }
        this.queryExecs.put(executor.getClass().getName(), executor);
        this.nameLookup.put(name, executor);
        if (description == null) {
            description = "";
        }
        this.executorDescription.put(name, description);
    }

    @Override
    public String[] getQueryExecutorNames() {
        Set<String> names = this.nameLookup.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public QueryExecutor lookup(String path) {
        return this.queryExecs.get(path);
    }

    @Override
    public QueryExecutor lookupByName(String name) {
        return this.nameLookup.get(name);
    }

    @Override
    public void updateQuery(SupaQuery query, SearchPreferences preferences, int startOff, int numResults, boolean filter, UserSecurityContext usc, long queryTimeout) throws SiapiException, ExtendedException {
        boolean dynamicSummary = false;
        for (String collectionId : query.getCollectionIds()) {
            CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
            if (!config.getProvideDynamicSummary()) continue;
            dynamicSummary = true;
            break;
        }
        query.setQueryLanguage(preferences.getQL());
        query.setPredefinedResultsEnabled(true);
        query.setRequestedResultRange(startOff, numResults);
        query.setReturnedAttribute(-1, dynamicSummary);
        query.setReturnedAttribute(-10, true);
        query.setReturnedAttribute(-2, true);
        query.setReturnedAttribute(-11, true);
        query.setReturnedAttribute(-6, true);
        query.setReturnedAttribute(-8, true);
        query.setReturnedAttribute(-9, true);
        query.setReturnedAttribute(-3, true);
        query.setProperty("filter", Boolean.toString(filter));
        query.setProperty("languageFilter", this.getLanguageConstraintsQueryTerm(preferences));
        query.setProperty("earlyTerminationTimeout", Long.toString(queryTimeout));
        query.setCredentials(usc);
    }

    @Override
    public String getDefaultQueryExecutorName() {
        return this.defaultQueryExecutorName;
    }

    public void setDefaultQueryExecutorName(String defaultQueryExecutorName) {
        this.defaultQueryExecutorName = defaultQueryExecutorName;
    }

    private String getLanguageConstraintsQueryTerm(SearchPreferences preferences) {
        String[] filterLanguages;
        String langConstraintsTerm = "";
        String filterOption = preferences.getFO();
        if (filterOption.equals("1") && (filterLanguages = preferences.getFL()) != null && filterLanguages.length > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(" +(");
            for (int i = 0; i < filterLanguages.length; ++i) {
                if (i != 0) {
                    builder.append(" || ");
                }
                builder.append("language");
                builder.append(":");
                builder.append(filterLanguages[i]);
            }
            builder.append(")");
            langConstraintsTerm = builder.toString();
        }
        return langConstraintsTerm;
    }

    @Override
    public String getLinkerExecutorName() {
        return this.linkerExecuterName;
    }

    @Override
    public void setLinkerExecutorName(String name) {
        this.linkerExecuterName = name;
    }

    @Override
    public LinkerSupportInterface getLinkerSupportOracle() {
        return this.linkerSupportOracle;
    }

    public void setLinkerSupportOracle(LinkerSupportInterface oracle) {
        this.linkerSupportOracle = oracle;
    }

    @Override
    public Map<String, String> getQueryExecutorDescriptions() {
        return this.executorDescription;
    }
}

