/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.common.FileFetcherURI;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import com.ibm.supa.search.SearchUtils;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.SpanResultFetcher;
import com.ibm.supa.search.spans.SpanResultUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.lucene.document.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanResultImpl
extends ResultImpl
implements SpanResultFetcher {
    private static final long serialVersionUID = 180719706263707390L;
    private final boolean hasViewAccess;
    private final int start;
    private final int end;
    private int textLengthCoveredBySpan = -1;
    private int startLine = -1;
    private int endLine = -1;
    private String description;
    private String highlightedDocumentURI;
    private String title;
    private Document doc;
    private double spanScore;
    private boolean showScore;
    private SpanResult.Type spanType;
    private SpanResult spanResult;
    private TokenizedDocument tokenizedDocument;

    public SpanResultImpl(TokenizedDocument tDoc, SpanResult result, Query query) {
        super(tDoc.getDocument(), result.doc(), SpanResultImpl.getSpanScore(result), query, result.getCollectionId());
        this.start = result.start();
        this.end = result.end();
        this.doc = tDoc.getDocument();
        this.showScore = true;
        this.spanScore = SpanResultImpl.getSpanScore(result);
        this.spanResult = result;
        this.spanType = result.getType();
        this.tokenizedDocument = tDoc;
        this.hasViewAccess = result.getSearchWrapper().canViewCollectionContents();
    }

    public SpanResult.Type getSpanType() {
        return this.spanType;
    }

    private static double getSpanScore(SpanResult result) {
        return 100.0 - result.penalty();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return super.getDescription();
        }
        return this.description;
    }

    @Override
    public String getHighlightedDocumentURI() {
        return this.highlightedDocumentURI;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHighlightedDocumentURI(String highlightedDocumentURI) {
        this.highlightedDocumentURI = highlightedDocumentURI;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getNonClickThroughDocumentURI() {
        String uri = this.doc.get("uri");
        if (this.isCrawled() && !uri.startsWith("http://") && !uri.startsWith("https://")) {
            String fetchURI = FileFetcherURI.constructFetchableURI(this);
            fetchURI = SearchUtils.replaceSearchContextPath(fetchURI);
            uri = fetchURI.replace("/fetch?", "/fetchContents?");
            StringBuilder sBuf = new StringBuilder(uri);
            sBuf.append('&').append("start=").append(this.start);
            sBuf.append('&').append("end=").append(this.end);
            sBuf.append('&').append("startLine=").append(this.startLine);
            sBuf.append('&').append("endLine=").append(this.endLine);
            sBuf.append('&').append("fetchURL=");
            try {
                sBuf.append(URLEncoder.encode(fetchURI, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            sBuf.append('&').append("title=");
            try {
                sBuf.append(URLEncoder.encode(this.getTitle(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            uri = sBuf.toString();
        }
        return uri;
    }

    @Override
    public String getClickThroughTrackingURL(String resultURL) {
        return SearchUtils.replaceSearchContextPath(super.getClickThroughTrackingURL(resultURL));
    }

    @Override
    public boolean isURIClickable() {
        return this.hasViewAccess && super.isURIClickable();
    }

    public int getTextLengthCoveredBySpan() {
        return this.textLengthCoveredBySpan;
    }

    public void setTextLengthCoveredBySpan(int textLengthCoveredBySpan) {
        this.textLengthCoveredBySpan = textLengthCoveredBySpan;
    }

    @Override
    public SpanResult getSpanResult() {
        return this.spanResult;
    }

    public TokenizedDocument getTokenizedDocument() {
        return this.tokenizedDocument;
    }

    public double getSpanScore() {
        return this.spanScore;
    }

    public void setSpanScore(double spanScore) {
        this.spanScore = spanScore;
    }

    public boolean isShowScore() {
        return this.showScore;
    }

    public void setShowScore(boolean showScore) {
        this.showScore = showScore;
    }

    public void clearNonExporables() {
        this.spanResult = null;
        this.tokenizedDocument = null;
    }

    public static TokenizedDocument[][] toTokenizedDocuments(TreeSet<SpanResultImpl> orderedImpls) {
        SpanResultUtils.CollectionDocs[] cDocs = SpanResultUtils.getCollectionDocs(orderedImpls);
        TokenizedDocument[][] tDocs = new TokenizedDocument[cDocs.length][];
        Iterator<SpanResultImpl> it = orderedImpls.iterator();
        TokenizedDocument nextTDoc = it.next().getTokenizedDocument();
        for (int i = 0; i < cDocs.length; ++i) {
            tDocs[i] = new TokenizedDocument[cDocs[i].docIds.length];
            for (int j = 0; j < tDocs[i].length; ++j) {
                tDocs[i][j] = nextTDoc;
                if (j != 0) {
                    while (tDocs[i][j] == tDocs[i][j - 1]) {
                        tDocs[i][j] = it.next().getTokenizedDocument();
                    }
                }
                if (!it.hasNext()) continue;
                nextTDoc = it.next().getTokenizedDocument();
            }
            TokenizedDocument lastTDoc = tDocs[i][tDocs[i].length - 1];
            while (it.hasNext() && nextTDoc == lastTDoc) {
                nextTDoc = it.next().getTokenizedDocument();
            }
        }
        assert (!it.hasNext());
        return tDocs;
    }

    public static interface Visitor {
        public void visit(SpanResultImpl var1) throws IOException, SiapiException;
    }
}

