/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.search.EmptyQueryException;
import com.ibm.es.nuvo.search.QueryLimitExceededException;
import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.SearchServiceImpl;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.search.cache.CacheSearcher;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.Searchable;
import com.ibm.supa.security.Permission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public class SearchWrapper {
    private static Method GET_INDEX_SEARCHER;
    private static Field DOC_HASHES;
    private String collectionId;
    private SearchableImpl searchable;
    private Object[] params = new Object[1];
    private UserSecurityContext usc;
    private final long indexVersion;

    public SearchWrapper(String collectionId, UserSecurityContext usc) throws SiapiException {
        this.collectionId = collectionId;
        this.searchable = (SearchableImpl)SearchServiceImpl.getInstance().getSearchable(null, collectionId);
        this.usc = usc;
        this.indexVersion = this.getTextIndexReader().getVersion();
    }

    public long getIndexVersion() {
        return this.indexVersion;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public IndexSearcher getIndexSearcher(IndexDescriptor.IndexType type) throws SiapiException {
        if (this.searchable == null) {
            return null;
        }
        this.params[0] = type;
        try {
            return (IndexSearcher)GET_INDEX_SEARCHER.invoke((Object)this.searchable, this.params);
        }
        catch (Exception e) {
            SiapiException exc = new SiapiException(1, 24, "Failed to obtain index searcher");
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public long[] getDocHashes() throws SiapiException {
        try {
            return (long[])DOC_HASHES.get(this.searchable);
        }
        catch (Exception e) {
            SiapiException exc = new SiapiException(1, 24, "Failed to obtain doc hashes");
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public void close() {
        try {
            if (this.searchable != null) {
                SearchServiceImpl.getInstance().putSearchable(this.searchable);
                this.searchable = null;
            }
        }
        catch (ExtendedException e) {
            throw new RuntimeException(e);
        }
    }

    public Searchable getSearchable() {
        return this.searchable;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean equals(Object o) {
        if (o instanceof SearchWrapper) {
            return this.searchable.equals(((SearchWrapper)o).searchable);
        }
        return false;
    }

    public int hashCode() {
        return this.searchable.hashCode() + 1;
    }

    public ResultSet search(Query query) throws ExtendedException {
        try {
            return this.searchable.search(query);
        }
        catch (SiapiException e) {
            if (e.getType() == 15) {
                Message msg = new Message("S0032E.QUERY_BAD_SYNTAX");
                throw new ExtendedException(msg);
            }
            if (e instanceof EmptyQueryException) {
                Message msg = new Message("S0077E.EMPTY_PARSED_QUERY");
                throw new ExtendedException(msg);
            }
            if (e instanceof QueryLimitExceededException) {
                Message msg = new Message("S0215E.PER_DAY_QUERY_LIMIT_EXCEEDED");
                throw new ExtendedException(msg);
            }
            throw new ExtendedException(e.getCause());
        }
    }

    public IndexReader getTextIndexReader() throws SiapiException {
        return this.getIndexSearcher(IndexDescriptor.IndexType.Text).getIndexReader();
    }

    public CollectionConfiguration getCollectionConfig() throws ConfigurationManagerException {
        return ConfigurationManager.getConfigurationManager().getCollection(this.collectionId);
    }

    public boolean canSearchCollection() {
        return this.usc == null || this.usc.hasPermission(this.collectionId, Permission.User.SEARCH);
    }

    public boolean canViewCollectionContents() {
        return this.usc == null || this.usc.hasPermission(this.collectionId, Permission.User.VIEW);
    }

    public void updateCachedProperty(ResultImpl[] resultArray) throws SiapiException, IOException {
        if (resultArray != null) {
            CacheSearcher cacheSearcher = (CacheSearcher)this.getIndexSearcher(IndexDescriptor.IndexType.Cache);
            for (ResultImpl resultImpl : resultArray) {
                this.updateCachedProperty(resultImpl, cacheSearcher);
            }
        }
    }

    public void updateCachedProperty(ResultImpl resultImpl) throws SiapiException, IOException {
        CacheSearcher cacheSearcher = (CacheSearcher)this.getIndexSearcher(IndexDescriptor.IndexType.Cache);
        this.updateCachedProperty(resultImpl, cacheSearcher);
    }

    private void updateCachedProperty(ResultImpl resultImpl, CacheSearcher cacheSearcher) throws IOException {
        resultImpl.setProperty("cached", "false");
        if (cacheSearcher != null && this.canViewCollectionContents() && cacheSearcher.exists(resultImpl.getDocumentID())) {
            resultImpl.setProperty("cached", "true");
        }
    }

    static {
        Class<SearchableImpl> clazz = SearchableImpl.class;
        try {
            Class[] classes = new Class[]{IndexDescriptor.IndexType.class};
            GET_INDEX_SEARCHER = clazz.getDeclaredMethod("getIndexSearcher", classes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        GET_INDEX_SEARCHER.setAccessible(true);
        try {
            DOC_HASHES = clazz.getDeclaredField("docHashCodes");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        DOC_HASHES.setAccessible(true);
    }
}

