/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.util.url.URLEncoderDecoder;
import com.ibm.siapi.SiapiException;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.search.AssociatedQueryState;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.spans.SpanResult;
import com.ibm.supa.search.spans.SpanResultUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchUtils {
    public static ExecutorService SEARCH_EXECUTOR = SUPAUtils.newDaemonExecutor();

    public static boolean needsPrevResults(SearchSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return snapshot.getPreviousSnapshot() != null && snapshot.getAssociationToPreviousQuery() != AssociatedQueryState.NONE;
    }

    public static SearchSnapshot.Results getPrevResults(SearchSnapshot snapshot, SearchWrapper wrapper) throws SiapiException {
        return SearchUtils.getResults(wrapper, snapshot.getPreviousSnapshot());
    }

    public static SearchSnapshot.Results getResults(SearchWrapper wrapper, SearchSnapshot snapshot) throws SiapiException {
        String collectionId = wrapper.getCollectionId();
        SearchSnapshot.Results results = snapshot.getResults(collectionId);
        if (results == null || !results.isSameVersion(wrapper.getIndexVersion())) {
            snapshot.getQueryExecutor().execute(snapshot.getQueryClone(), null, wrapper);
            results = snapshot.getResults(collectionId);
        }
        if (results == null || results.getSpanResults().isEmpty()) {
            return null;
        }
        return results;
    }

    public static SpanResultImpl[] load(List<SpanResult> spanResults, final SupaQuery query, final boolean loadTexts, final boolean showCollectionName, final SpanResultImpl.Visitor ... visitors) throws SiapiException {
        try {
            TreeSet<SpanResult> spanFetchers = SpanResultUtils.toTreeSet(spanResults);
            SpanResultUtils.CollectionDocs[] cDocs = SpanResultUtils.getCollectionDocs(spanFetchers);
            TokenizedDocument[][] tDocs = SpanResultUtils.loadTokenizedDocs(cDocs);
            final Map<SpanResult, String> texts = loadTexts ? SpanResultUtils.loadTexts(spanFetchers, tDocs, "_plain") : null;
            final IdentityHashMap resultMap = new IdentityHashMap(spanResults.size());
            SpanResultUtils.visit(spanFetchers, tDocs, new SpanResultUtils.VisitHandler<SpanResult>(){
                StringBuilder sBuf = new StringBuilder();
                DateFormat dateInstance = DateFormat.getDateInstance(2);
                DateFormat timeInstance = DateFormat.getTimeInstance(3);

                @Override
                public void handle(SpanResult spanResult, TokenizedDocument tDoc) throws IOException, SiapiException {
                    String title;
                    SpanResultImpl resultImpl = new SpanResultImpl(tDoc, spanResult, query);
                    if (loadTexts) {
                        String text = (String)texts.get(spanResult);
                        resultImpl.setDescription(text);
                        resultImpl.setTextLengthCoveredBySpan(text.length());
                    }
                    if (showCollectionName) {
                        this.sBuf.append("Collection: ").append(spanResult.getCollectionId()).append(" - ");
                    }
                    String decodedDocID = URLEncoderDecoder.decode(resultImpl.getDocumentID());
                    this.sBuf.append(decodedDocID);
                    Date date = resultImpl.getDate();
                    if (date != null) {
                        this.sBuf.append(" - ");
                        this.sBuf.append(this.dateInstance.format(date));
                        this.sBuf.append(' ');
                        this.sBuf.append(this.timeInstance.format(date));
                    }
                    resultImpl.setHighlightedDocumentURI(this.sBuf.toString());
                    this.sBuf.setLength(0);
                    TokenVector titleVec = tDoc.getField("title");
                    if (titleVec == null) {
                        if (tDoc.getDocument().getField("title") == null) {
                            TokenVector fileNameVec = tDoc.getField("filename");
                            if (fileNameVec != null) {
                                TokenVectorIterator it = fileNameVec.iterator(TokenVectorIterator.Mode.SUMMARY);
                                while (it.next()) {
                                    if (it.getType() == TToken.Type.WHITESPACE) {
                                        this.sBuf.append(' ');
                                        continue;
                                    }
                                    this.sBuf.append(it);
                                }
                            }
                            title = this.sBuf.toString();
                            if (decodedDocID.startsWith("Notes://")) {
                                if (title.startsWith("NotesDoc:") && title.endsWith(".notes")) {
                                    title = title.substring("NotesDoc:".length(), title.length() - ".notes".length());
                                } else if (title.trim().equals("")) {
                                    title = decodedDocID;
                                }
                            }
                            this.sBuf.setLength(0);
                        } else {
                            title = tDoc.getDocument().getField("title").stringValue();
                            if (title == null) {
                                title = tDoc.getDocument().getField("filename").stringValue();
                            } else if (title == null || title.equals("")) {
                                title = tDoc.getDocument().getField("uri").stringValue();
                            }
                        }
                    } else {
                        TokenVectorIterator it = titleVec.iterator(TokenVectorIterator.Mode.SUMMARY);
                        while (it.next()) {
                            if (it.getType() == TToken.Type.WHITESPACE) {
                                this.sBuf.append(' ');
                                continue;
                            }
                            this.sBuf.append(it);
                        }
                        title = this.sBuf.toString();
                        this.sBuf.setLength(0);
                    }
                    resultImpl.setTitle(title);
                    for (SpanResultImpl.Visitor visitor : visitors) {
                        visitor.visit(resultImpl);
                    }
                    resultMap.put(spanResult, resultImpl);
                }

                @Override
                public void handleNewDoc(TokenizedDocument tDoc) {
                }
            });
            SpanResultImpl[] result = new SpanResultImpl[spanFetchers.size()];
            int i = 0;
            for (SpanResult spanResult : spanResults) {
                SpanResultImpl impl = (SpanResultImpl)resultMap.get(spanResult);
                if (impl == null) continue;
                result[i++] = impl;
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof SiapiException) {
                throw (SiapiException)((Object)e);
            }
            throw new SiapiException(1, 25, "Exception while searching", (Throwable)e);
        }
    }

    public static String replaceSearchContextPath(String uri) {
        return uri.replace(ContextType.Search.getContextPath(), ContextType.Supa.getContextPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getCategorizationValues(String[] collectionIds) {
        HashSet<String> result = new HashSet<String>();
        block15: for (String cId : collectionIds) {
            try {
                SearchWrapper wrapper = new SearchWrapper(cId, null);
                try {
                    IndexReader reader = wrapper.getTextIndexReader();
                    Term preTerm = new Term("categorization", "");
                    String field = preTerm.field();
                    TermEnum termEnum = reader.terms(preTerm);
                    TermDocs termDocs = reader.termDocs(preTerm);
                    try {
                        try {
                            Term term;
                            while ((term = termEnum.term()) != null) {
                                block21: {
                                    if (term.field() != field) {
                                        continue block15;
                                    }
                                    if (reader.docFreq(term) != 0) {
                                        block22: {
                                            try {
                                                termDocs.seek(termEnum);
                                                if (!termDocs.next()) break block21;
                                                if (termDocs.freq() == 0) {
                                                }
                                                break block22;
                                            }
                                            catch (IOException e) {
                                                termDocs = reader.termDocs(preTerm);
                                            }
                                            break block21;
                                        }
                                        String termText = term.text();
                                        if (!termText.contains("\uf749") && !termText.contains("\uf748")) {
                                            result.add(termText);
                                        }
                                    }
                                }
                                if (termEnum.next()) continue;
                                continue block15;
                            }
                        }
                        finally {
                            termEnum.close();
                        }
                    }
                    finally {
                        termDocs.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception occurred for collection " + cId + ". Exception is: ");
                    e.printStackTrace();
                }
                finally {
                    wrapper.close();
                }
            }
            catch (SiapiException e) {
                System.err.println("Exception occurred for collection " + cId + ". Exception is: ");
                e.printStackTrace();
            }
        }
        return result;
    }
}

