/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search;

import com.ibm.supa.search.AssociatedQueryState;
import com.ibm.supa.search.QueryExecutor;
import com.ibm.supa.search.SearchSnapshot;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.spans.SpanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSnapshotImpl
implements SearchSnapshot,
Cloneable {
    private final SupaQuery query;
    private final QueryExecutor queryExecutor;
    private final AssociatedQueryState associationToPreviousQuery;
    private final SearchSnapshot previousSnapshot;
    private Map<String, SearchSnapshot.Results> lookup;
    private String lastCollectionId;
    private SearchSnapshot.Results lastResults;
    private int maxResultsPerCollection = -1;
    private double decayWeighting = 1.0;

    public SearchSnapshotImpl(SupaQuery query, QueryExecutor queryExecutor) {
        this(query, queryExecutor, null, null);
    }

    public SearchSnapshotImpl(SupaQuery query, QueryExecutor queryExecutor, AssociatedQueryState associationToPreviousQuery, SearchSnapshot previousSnapshot) {
        this.query = (SupaQuery)query.clone();
        this.queryExecutor = queryExecutor;
        this.associationToPreviousQuery = associationToPreviousQuery;
        this.previousSnapshot = previousSnapshot;
        this.lookup = Collections.synchronizedMap(new ReferenceMap());
    }

    public int getMaxResultsPerCollection() {
        return this.maxResultsPerCollection;
    }

    @Override
    public void setMaxResultsPerCollection(int maxResultsPerCollection) {
        this.maxResultsPerCollection = maxResultsPerCollection;
    }

    @Override
    public SearchSnapshot.Results getResults(String collectionId) {
        if (collectionId.equals(this.lastCollectionId)) {
            SearchSnapshot.Results result = this.lastResults;
            this.lastCollectionId = null;
            this.lastResults = null;
            return result;
        }
        return this.lookup.get(collectionId);
    }

    @Override
    public void setResults(String collectionId, List<SpanResult> spanResults, long indexVersion) {
        if (this.maxResultsPerCollection >= 0 && spanResults.size() > this.maxResultsPerCollection) {
            List<SpanResult> sortResults = spanResults;
            Collections.sort(sortResults, new Comparator<SpanResult>(){

                @Override
                public int compare(SpanResult o1, SpanResult o2) {
                    return Double.compare(o1.getPenaltyScore().getPenalty(), o2.getPenaltyScore().getPenalty());
                }
            });
            spanResults = new ArrayList<SpanResult>(this.maxResultsPerCollection);
            for (SpanResult spanResult : sortResults) {
                spanResults.add(spanResult);
                if (spanResults.size() != this.maxResultsPerCollection) continue;
                break;
            }
            Collections.sort(spanResults, SpanResult.POSITION_COMPARATOR);
        }
        SearchSnapshot.Results results = new SearchSnapshot.Results(spanResults, indexVersion);
        this.lastCollectionId = collectionId;
        this.lastResults = results;
        this.lookup.put(collectionId, results);
    }

    @Override
    public SupaQuery getQueryClone() {
        return (SupaQuery)this.query.clone();
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public AssociatedQueryState getAssociationToPreviousQuery() {
        return this.associationToPreviousQuery;
    }

    @Override
    public SearchSnapshot getPreviousSnapshot() {
        return this.previousSnapshot;
    }

    @Override
    public SearchSnapshot getReturnedSnapshot() {
        return this.getReturnedSnapshot(this);
    }

    private SearchSnapshot getReturnedSnapshot(SearchSnapshot snapshot) {
        AssociatedQueryState associationToPreviousQuery = snapshot.getAssociationToPreviousQuery();
        if (associationToPreviousQuery != AssociatedQueryState.RETURNED && associationToPreviousQuery != AssociatedQueryState.NONE) {
            return this.getReturnedSnapshot(snapshot.getPreviousSnapshot());
        }
        return snapshot;
    }

    @Override
    public List<String> getPreviousAndCurrentUserQueries() {
        return this.getPreviousAndCurrentUserQueries(this);
    }

    private List<String> getPreviousAndCurrentUserQueries(SearchSnapshot snapshot) {
        ArrayList<String> allQueries = new ArrayList<String>();
        if (snapshot.getPreviousSnapshot() == null) {
            return this.getUserQueries(snapshot);
        }
        allQueries.addAll(this.getPreviousAndCurrentUserQueries(snapshot.getPreviousSnapshot()));
        allQueries.addAll(this.getUserQueries(snapshot));
        return allQueries;
    }

    private List<String> getUserQueries(SearchSnapshot snapshot) {
        ArrayList<String> allQueries = new ArrayList<String>();
        String curQuery = snapshot.getQueryClone().getSpanQueryString();
        if (curQuery != null && !curQuery.equals("")) {
            allQueries.add(curQuery);
        }
        if ((curQuery = snapshot.getQueryClone().getDocumentQueryString()) != null && !curQuery.equals("")) {
            allQueries.add(curQuery);
        }
        return allQueries;
    }

    @Override
    public double getDecayWeighting() {
        return this.decayWeighting;
    }

    public void setDecayWeighting(double decayWeighting) {
        this.decayWeighting = decayWeighting;
    }

    @Override
    public SearchSnapshot clone() {
        try {
            SearchSnapshotImpl result = (SearchSnapshotImpl)super.clone();
            result.lookup = Collections.synchronizedMap(new ReferenceMap());
            result.query.setSearchSnapshot(result);
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

